#include "ArpExample.h"

#ifndef AMKERNEL_AMFILTERCONFIG_H
#include "AmPublic/AmFilterConfigLayout.h"
#endif

#include <experimental/ResourceSet.h>

#ifndef ARPKERNEL_ARPDEBUG_H
#include <ArpKernel/ArpDebug.h>
#endif

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>

ArpMOD();

static BResourceSet gResources;
static int32 gInitResources = 0;
BResourceSet& Resources()
{
	if (atomic_or(&gInitResources, 1) == 0) {
		gResources.AddResources((void*)Resources);
		atomic_or(&gInitResources, 2);
	} else {
		while ((gInitResources&2) ==0) snooze(20000);
	}
	return gResources;
}

/* ----------------------------------------------------------------
   ArpExampleFilter Class
   ---------------------------------------------------------------- */

ArpExampleFilter::ArpExampleFilter(ArpExampleFilterAddOn* addon,
							 AmFilterHolderI* holder,
							 const BMessage* config)
	: AmFilterI(addon),
	  mAddOn(addon),
	  mHolder(holder)
{
	if (config) PutConfiguration(config);
}

ArpExampleFilter::~ArpExampleFilter()
{
}

AmEvent* ArpExampleFilter::HandleEvent(AmEvent* event, const am_filter_params* /*params*/)
{
	if( !event ) return event;
	
	ArpVALIDATE(mAddOn != NULL && mHolder != NULL, return event);
	
	AmEvent* head = event;
	
	if( event->Type() == event->NOTEON_EVENT ) {
		AmNoteOn* note = dynamic_cast<AmNoteOn*>(event);
		if( !note ) return event;
		
		if( event->Time() >= PPQN ) {
			AmEvent* prevEvent = event->Copy();
			prevEvent->SetTime(prevEvent->Time() - PPQN);
			AmNoteOn* prevNote = dynamic_cast<AmNoteOn*>(prevEvent);
			if( !prevNote ) {
				prevEvent->Delete();
			} else {
				prevNote->SetVelocity(prevNote->Velocity()/2);
				event->InsertEvent(prevEvent);
				head = prevEvent;
			}
		}
		
		AmEvent* nextEvent = event->Copy();
		nextEvent->SetTime(nextEvent->Time() + PPQN);
		AmNoteOn* nextNote = dynamic_cast<AmNoteOn*>(nextEvent);
		if( !nextNote ) {
			nextEvent->Delete();
		} else {
			nextNote->SetVelocity(nextNote->Velocity()/2);
			event->AppendEvent(nextEvent);
		}
	}
	
	return head;
}

status_t ArpExampleFilter::GetConfiguration(BMessage* values) const
{
	status_t err = AmFilterI::GetConfiguration(values);
	if (err != B_OK) return err;
	
	return B_OK;
}

status_t ArpExampleFilter::PutConfiguration(const BMessage* values)
{
	status_t err = AmFilterI::PutConfiguration(values);
	if (err != B_OK) return err;
	
	return B_OK;
}

status_t ArpExampleFilter::Configure(ArpVectorI<BView*>& /*panels*/)
{
	return B_OK;
}
	
/* ----------------------------------------------------------------
   ArpExampleFilterAddOn Class
   ---------------------------------------------------------------- */
void ArpExampleFilterAddOn::GetVersion(int32* major, int32* minor) const
{
	*major = 1;
	*minor = 0;
}

BBitmap* ArpExampleFilterAddOn::Image(BPoint requestedSize) const
{
	const BBitmap* bm = Resources().FindBitmap("Class Icon");
	if (bm) return new BBitmap(bm);
	return NULL;
}

extern "C" _EXPORT AmFilterAddOn* make_nth_filter(int32 n, image_id /*you*/,
												  const void* cookie, uint32 /*flags*/, ...)
{
	if (n == 0) return new ArpExampleFilterAddOn(cookie);
	return NULL;
}
