/*****************************************************************************

	Projet	: Pulsar Sample FFT AddOn

	Fichier	: sample_addon.cpp
	Partie	: End

	Auteur	: RM
	Date		: 040597 -- version 0.2 (C funcs)
	Date		: 010797 -- version 0.3 (CFilter)
	Format	: tabs==2

*****************************************************************************/

#include "CFilter.h"

#pragma export on
CFilter * filterInit(uint32 index);
#pragma export reset

static const bool debug=false;

//--------------------------------------------------------------------

//*************************************
class CSampleFftFilter : public CFilter
//*************************************
{
public:

	CSampleFftFilter(void) : CFilter()	{ /* nothing */ }
	virtual ~CSampleFftFilter(void) 		{ /* nothing */ }

	virtual bool load(void);
	virtual bool prepare(void);
	virtual void processFrame8(SFrameInfo &frame);

	virtual BView *settingsOpened(void);

private:
	BView * myview;

}; // end of class defs for CSampleFftFilter


//--------------------------------------------------------------------


//**********************************************
CFilter * filterInit(uint32 index)
//**********************************************
{
	// this add-on only declares ONE filter
	if (index > 0) return NULL;

	CSampleFftFilter *info = new CSampleFftFilter;
	if (!info) return NULL;		// memory error, give up

	// returns the instance -- the caller will check that this instance
	// is derived from CFilter but is _not_ a CFilter...
	return info;
} // end of filterInit


//*******************************
bool CSampleFftFilter::load(void)
//*******************************
{
	sFilter.name = "FFT 2";
	sFilter.author = "R'alf";
	sFilter.info = "Sample code";
	sFilter.majorVersion = 0;
	sFilter.minorVersion = 3;
	sFilter.position = kFilterPositionLast-0.21;
	sFilter.supportedMode = (color_space)(B_COLOR_8_BIT);
	sFilter.hasSettings = true;

	sFilter.modelParam.AddRect("Bass Frame", BRect(10,10,10+255,10+99));
	sFilter.modelParam.AddRect("High Frame", BRect(640-256-10,10,640-256-10+255,10+99));
	sFilter.modelParam.AddBool("Average", true);
	sFilter.modelParam.AddFloat("Divider", 8192.0);

	myview = NULL;

	return true;
}  // end of load for CSampleFftFilter


//**********************************
bool CSampleFftFilter::prepare(void)
//**********************************
{
	return true;
} // end of prepare for CSampleFftFilter


//********************************************
BView * CSampleFftFilter::settingsOpened(void)
//********************************************
{
printf("CSampleFftFilter::settingsOpened -- (%p)\n",myview);
	if (myview) return myview;
	myview = new BView(BRect(0,0,200,50), "myview", B_FOLLOW_ALL, B_WILL_DRAW);
printf("CSampleFftFilter::settingsOpened -- new view %p\n", myview);
	if (!myview) return NULL;
	myview->SetViewColor(150,40,40);
	return myview;
	// DO NOT call inherited here !!	
} // end of settingsOpened for CSampleFftFilter


//***************************************
void CSampleFftFilter::processFrame8(SFrameInfo &frame)
//***************************************
{
	#define VERT 52		// vert pomme (apple green)
	#define JAUNE 250	// jaune pomme

	long xb=10;
	long xa=640-256-10;
	long y=470;
	for(long i=0; i<8; i++)
	{
		int a = frame.meanFftHigh[i]/8192;
		int b = frame.meanFftBass[i]/8192;
		if (a < 0) a = 0;
		if (b < 0) b = 0;
		if (a > 300) a = 300;
		if (b > 300) b = 300;
		
		long y2=y-b;
		long x2=xb+31;
		blitLine8(xb,y,xb,y2,VERT);
		blitLine8(xb,y2,x2,y2,VERT);
		xb+=32;

		y2=y-a;
		x2=xa+31;
		blitLine8(xa,y,xa,y2,JAUNE);
		blitLine8(xa,y2,x2,y2,JAUNE);
		xa += 32;
	}
	
	if(1)
	{
			int a = frame.averageFftHigh/8192;
			int b = frame.averageFftBass/8192;
			if (a < 0) a = 0;
			if (b < 0) b = 0;
			if (a > 300) a = 300;
			if (b > 300) b = 300;
			
			long y2=y-b;
			blitLine8(10,y2,10+256,y2,JAUNE);

			y2=y-a;
			blitLine8(640-256-10,y2,640-10,y2,VERT);
	}		

}  // end of processFrame8 for CSampleFftFilter

// eoc
