//=====================================================================
// rfsvclient.cpp
// © Michael Pieper 2. Apr. 1999
//=====================================================================
//
//  This class is used to manage the Filesystem-addon
//
//=====================================================================
#include "../DebugMsg/debugMsg.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "RfsvClient.h"
#include "RfsvClientAddOn.h"

#include "psionfs.h"
#include "mc_rfile.h"
#include "p_file.h"
#include "../messages.h"

//=====================================================================
// 
RfsvClient::RfsvClient( CONFIG_VAR *conf ) {

	config = conf;		// set the Pointer to the correct value
}

//=====================================================================
// 
void RfsvClient::StartMount( void ) {

	int			result;
	int32		msg;
	int			fd;
	ssize_t		r_byte, send_len;		// signed size_t
	MNT_INFO	mnt_info, *m, *ms;
	char		text[128], *c;
	unsigned char send_buffer[100];
	DIR			*d;

	printf("config->debug set to: %d\n", config->debug);

	if (config->debug) dprint = new DebugMsg( config->debugFile, "RFSV-Client");
	else dprint = new DebugMsg( NULL, NULL );
	
	mount_info = NULL;	// einen Zeiger auf mehrere Strings hintereinander, die die gemounteten Laufwerke angeben
	pid_i = mnt_info.pid_read = create_port(50, READ_PORT);
	pid_o = mnt_info.pid_write = find_port("WritePsion");	// Über diesen Port gehen die zu versendenden Nachrichten

	if (pid_i < B_NO_ERROR || pid_o < B_NO_ERROR) exit_thread(B_ERROR);

	strcpy(text, config->mountPoint);	// Um den MountPoint anzulegen gehen wir den Pfad der Reihe nach durch
	c = text;
	if (*c == '/') c++;					// den allerersten Ordner müssen wir nicht anlegen!
	do {
		c = strchr(c, '/');				// den nächsten Ordner suchen
		if (c != NULL) *c = '\0';
		if ((d = opendir(text)) == NULL) mkdir(text, S_IRWXU);
		else closedir(d);
		if (c != NULL) *c++ = '/';
		else break;						// Schleife beenden
	} while (true);						// Endlosschleife
	
	dprint->String("Try to start the PSION-SYS$RFSV");

	write_port(mnt_info.pid_write, PSION_SSERV, START_RFSV_SERVER , sizeof(START_RFSV_SERVER));
	r_byte = read_port_etc(mnt_info.pid_read, &msg, text, 128, B_TIMEOUT, 10000000L);	/* 10 Sekunde Timeout!	*/
	if (r_byte >= B_NO_ERROR) {				// Mounten nur durchführen, wenn nach 10 Sekunden alles klar ist!

		dprint->String("PSION-Server is running!");

		mnt_info.cid = msg & CID_MASK;

		mnt_info.sem = create_sem(1, "RFSV-NCP-Write");	// Wir brauchen eine Semaphore um das Schreiben auf die Schnittstelle zu serialisieren!
		if (mnt_info.sem >= B_NO_ERROR) {

			// Serverprotokoll im PSION gestartet. Also müssen wir abfragen, welche devices alle vorhanden sind.
			// Dazu wird über eine Schleife mit OPEN DEVREAD STATUSDEVICE ... DEVREAD STATUSDEVICE CLOSE
			// herausgefunden, welche Laufwerke vorhanden sind.

			WordToBytes(RF_FOPEN, send_buffer);		// Öffnen
			WordToBytes(2, &send_buffer[2]);		// Länge 2
			WordToBytes(P_FDEVICE, &send_buffer[4]);	// Device öffnen
           	write_port(mnt_info.pid_write, PSION_CMD + mnt_info.cid, send_buffer, 6);

			dprint->String("FOPEN");
			dprint->Buffer( send_buffer, 6, "<<== Bytes sent:" );

			r_byte = read_port_etc(mnt_info.pid_read, &msg, text, 128, B_TIMEOUT, 10000000L);	/* 10 Sekunde Timeout!	*/
			if (r_byte >= B_NO_ERROR) {				// nach 10 Sekunden alles klar?

				dprint->Buffer( (unsigned char *)text, r_byte, "==>> Bytes read:" );

				if (BytesToWord((unsigned char *)&text[4]) == 0) {
					fd = BytesToWord((unsigned char *)&text[6]);
				} else {
					dprint->String("Error in OPENDEV! Mount canceled!\n");
					return;	// hier muß noch aufgeräumt werden!
				}
				
				do {
					WordToBytes(RF_FDEVICEREAD, send_buffer);		// Alle Devices durchlesen!
					WordToBytes(2, &send_buffer[2]);				// Länge 2
					WordToBytes(fd, &send_buffer[4]);				// Devicefilediskriptor

					acquire_sem(mnt_info.sem);	

					dprint->String("FDEVICEREAD");
					dprint->Buffer( send_buffer, 6, "<<== Bytes sent:" );

        		   	write_port(mnt_info.pid_write, PSION_CMD + mnt_info.cid, send_buffer, 6);
					r_byte = read_port_etc(mnt_info.pid_read, &msg, text, 128, B_TIMEOUT, 10000000L);	/* 10 Sekunde Timeout!	*/

					release_sem(mnt_info.sem);	

					if (r_byte >= B_NO_ERROR) {				// nach 10 Sekunden alles klar?

						dprint->Buffer( (unsigned char *)text, r_byte, "==>> Bytes read:" );

						result = BytesToWord((unsigned char *)&text[4]);
						if (result == 0) {
							strcpy(mnt_info.device, (char *)&text[70]);		// Lats talk about the Devicename
							printf("Device: %s\n", mnt_info.device);
							
							WordToBytes(RF_STATUSDEVICE, send_buffer);		// Alle Devices durchlesen!
							send_len = strlen(mnt_info.device)+1;
							WordToBytes(send_len, &send_buffer[2]);				// Länge 2
							strncpy((char *)&send_buffer[4], mnt_info.device, send_len);	// Devicefilediskriptor

							acquire_sem(mnt_info.sem);	
   			     		   	write_port(mnt_info.pid_write, PSION_CMD + mnt_info.cid, send_buffer, send_len+4);
							r_byte = read_port_etc(mnt_info.pid_read, &msg, text, 128, B_TIMEOUT, 10000000L);	/* 10 Sekunde Timeout!	*/
							release_sem(mnt_info.sem);	

							if (r_byte >= B_NO_ERROR) {				// nach 10 Sekunden alles klar?
								if (BytesToWord((unsigned char *)&text[4]) != 0) printf("DEVICE %s nicht vorhanden!\n", mnt_info.device);
								else {
									strcpy(mnt_info.mnt_pt, config->mountPoint);
									if (config->debug) strcpy(mnt_info.debugFile, config->debugFile);

									c = &mnt_info.mnt_pt[strlen(mnt_info.mnt_pt)];
									if (*c != '/') *c++ = '/';
									strcpy(c, &text[20]);
									
									printf("DEVICE %s should be mounted to %s\n", mnt_info.device, mnt_info.mnt_pt);
									printf("Starten des Mounten....\n");	// Diese Funktion erzeugt auch einen eigenen Port!
									mkdir(mnt_info.mnt_pt, 777);			// Mountpoint erzeugen

									result = mount ("psionfs", mnt_info.mnt_pt, NULL, 0, &mnt_info, sizeof(mnt_info) );

									printf("Mount result: %s\n", strerror(result));
									if (result == B_NO_ERROR) {
										mnt_info.mounted = true;					// all is done correctly
										m = (MNT_INFO *) malloc(sizeof(MNT_INFO));
										if (m != NULL) {							// sortin of the Mountinfo structure
											memcpy(m, &mnt_info, sizeof(MNT_INFO));
											m->next = NULL;
											if (mount_info == NULL) mount_info = m;
											else {
												for (ms = mount_info; ms->next != NULL; ms = ms->next) ;
												ms->next = m;
											}
										}
									}
								}
							}
						}
					} else result = -1;						// Fehler!
					
				} while (result == 0) ;

				WordToBytes(RF_FCLOSE, send_buffer);	// DEVICE schliessen
				WordToBytes(2, &send_buffer[2]);		// Länge 2
				WordToBytes(fd, &send_buffer[4]);		// Devicefilediskriptor

				dprint->String("FCLOSE");
				dprint->Buffer( send_buffer, 6, "<<== Bytes sent:" );

       		   	write_port(mnt_info.pid_write, PSION_CMD + mnt_info.cid, send_buffer, 6);
				r_byte = read_port_etc(mnt_info.pid_read, &msg, text, 128, B_TIMEOUT, 10000000L);	/* 10 Sekunde Timeout!	*/
				
				dprint->Buffer( (unsigned char *)text, r_byte, "==>> Bytes read:" );
				
			}
		}
	}
}

//=====================================================================
// Here we have to implement the unmount functionality

void RfsvClient::WaitForShutdown( void ) {

	thread_id	thr_id;
	char		b[100];
	MNT_INFO	*m;
	ssize_t		erg;
	bigtime_t	wait = 1000000;
	bool		unmount_error;
	
	while (true) {							// we are waiting forever!
		if (receive_data(&thr_id, b, 99) == PSION_DISC) {	// nothing more to do, only wait
			sprintf(b, "Received PSION_DISC");
			dprint->String(b);
		
			do {
				unmount_error = false;
				m = mount_info;
				while (m != NULL) {							// the first run, tries to unmount every device.
					if (m->mounted) {
						erg = unmount(m->mnt_pt);

						sprintf(b, "Unmounting %s -> %s", m->mnt_pt, strerror(erg));
						dprint->String(b);

						if (erg == B_OK) m->mounted = false;	// if it was succesful, then mark this in the MNT_INFO-Structure
						else unmount_error = true;
					}
					m = m->next;
				}
				snooze(wait);
				wait += 1000000;		// next time we wait 1 Second longer!
			} while (unmount_error);	// if an error occured try again this loop
			
			delete_port(pid_i);			// when we leave all, we have to delet our ReadPort
			return;						// and then leave this thread!
		}
	}
}


void WordToBytes(unsigned int i, unsigned char *p) {
    *p++ = i;
    *p = (i >> 8);
}

unsigned int BytesToWord(const unsigned char *c) {
	return ((unsigned int )*c | ((unsigned int )c[1] << 8)); 
}

