//=====================================================================
// ConfigView.h
// © Michael Pieper 28. Mar. 1999
//=====================================================================
//
//  This file defines the class "AddOnConfigView", which is used to
//  manage the PalmBeach ADD-Ons-Configuration
//
//=====================================================================

#include "ConfigView.h"
#include "LinkServerAddOn.h"
#include <InterfaceKit.h>
#include <StorageKit.h>
#include <stdio.h>
#include <string.h>

//=====================================================================
// The Constructor has to implement all things, that are needed to 
// communicate with the User!

AddOnConfigView::AddOnConfigView( BRect frame, CONFIG_VAR *conf )
		: BView(frame, "LinkServerConfig", B_FOLLOW_ALL_SIDES, B_WILL_DRAW)
{
	BRect			r;
	font_height		height;									// Calculate the height of one line!
	float			h;
	
	config = conf;
	
	SetViewColor(ui_color(B_PANEL_BACKGROUND_COLOR));

	GetFontHeight(&height);
	h = height.ascent + height.descent + height.leading + 1;	// add all Font-infos and 1 point

	r = Frame();
	r.InsetBy(5,5);

	BBox *debugBox = new BBox(r, "Settings", B_FOLLOW_LEFT_RIGHT | B_FOLLOW_TOP );	// Setup the Debug-Block
	AddChild(debugBox);

	debugCheckBox = new BCheckBox(r, "Debug", "Write to debugfile", new BMessage( ADDON_DEBUGBUTTON ));
	if (config->debug) debugCheckBox->SetValue(B_CONTROL_ON);
	debugBox->SetLabel( debugCheckBox );	

	r = debugBox->Bounds();
	r.InsetBy(5, h+5);
	
	debugFileButton = new BButton(r, "DebugFileButton", "Debugfile:", new BMessage( ADDON_DEBUGFILESEL ));
	debugFileButton->ResizeToPreferred();
	debugBox->AddChild( debugFileButton );
	
	r.left = debugFileButton->Bounds().right + 5;

	debugTextControl = new BTextControl(r, "DebugFile:", "", config->debugFile, NULL, B_FOLLOW_LEFT_RIGHT|B_FOLLOW_TOP);
	debugTextControl->SetDivider( 0 );
	debugBox->AddChild( debugTextControl );
	debugTextControl->MoveBy(0, (debugFileButton->Bounds().Height() - debugTextControl->Bounds().Height()) / 2);
	
	debugBox->ResizeTo(debugBox->Bounds().Width(), debugFileButton->Frame().bottom + 5);

	if (!config->debug) {						// if the debugmode is off, then disable the debug-things
		debugFileButton->SetEnabled(false);
		debugTextControl->SetEnabled(false);
	}
	
	prefWidth = be_plain_font->StringWidth("WWWWWWWWWW/WWWWWWWWWW/WWWWWWWWWW");	// calculate the maximum width
	prefHeight = debugBox->Frame().bottom + 5;
}

//=====================================================================
// The Denstructor has to setup all values

AddOnConfigView::~AddOnConfigView( void ) {

	strcpy( config->debugFile, debugTextControl->Text() );
}

//============================================================================
// The function AttachedToWindow sets the message for all elements in the view
// because we must be attached to select the View as the target!
//

void AddOnConfigView::AttachedToWindow( void ) {

	debugCheckBox->SetTarget(this);
	debugFileButton->SetTarget(this);
	debugTextControl->SetTarget(this);
}

//===============================================================================
// We are interested in receiving some messages from this view. So we want to do 
// something with them

void AddOnConfigView::MessageReceived( BMessage *msg ) {
	
	int32			state;				// Variable for the ListItem Index
	entry_ref		er;
	BDirectory		dir;
	BEntry			dbf;
	BPath			path;
	char			*f;
	
	switch(msg->what) {
		case ADDON_DEBUGFILESEL:
			dbf.SetTo(config->debugFile);
			dbf.GetParent(&dbf);
			
			saveFilePanel = new BFilePanel(B_SAVE_PANEL, NULL, NULL, B_FILE_NODE, false, NULL, NULL, true, true);
			saveFilePanel->SetTarget(this);
			saveFilePanel->SetSaveText("link-server.log");
         	saveFilePanel->SetPanelDirectory(&dbf);
			saveFilePanel->Show();
			break;
		case B_SAVE_REQUESTED:
			delete saveFilePanel;

			if ( (msg->FindRef("directory", &er) == B_OK) && (msg->FindString("name", &f) == B_OK) ) {
				dir.SetTo(&er);
				dbf.SetTo(&dir, f);
				dbf.GetPath(&path);
				debugTextControl->SetText( path.Path() );
			}
			break;
		case ADDON_DEBUGBUTTON:					// user switched the DebugButton
			if (msg->FindInt32("be:value", &state) == B_OK)	{ // the value-Field contains the Objectstate
				config->debug = (state == B_CONTROL_ON) ? true : false;
				debugFileButton->SetEnabled(state);
				debugTextControl->SetEnabled(state);
			}
			break;
    }
}

//=====================================================================
// This Function is called from PalmBeach to get the Information
// how big the View should be!

void AddOnConfigView::ResizeToPreferred( void ) {
	ResizeTo(prefWidth, prefHeight);
}

//=====================================================================
// This Function is called from PalmBeach to get the Information
// how big the View should be!

void AddOnConfigView::GetPreferredSize( float *width, float *height ) {
	*width = prefWidth;
	*height = prefHeight;
}
