/*
	
	PsiNCPWindow.cpp
	
	Programmstart: 12.9.1998 (Michael Pieper)
	
	Diese Funktion stellt die komplette Handhabung des Statusfensters dar.
	Die verschiedenen Funktionen werden über TabViews geregelt!
*/

// nur zum debuggen!=======================
#include "../DebugWin/debug.h"
//=========================================

#include <stdio.h>
#include <string.h>
#include <DeviceKit.h>
#include <FilePanel.h>
#include <InterfaceKit.h>
#include <StorageKit.h>

#include "thread.h"
#include "PsiNCPWindow.h"
#include "PsionNCP.h"
#include "ReadSerial.h"
#include "WriteSerial.h"
#include "AddOnView.h"
#include "SettingsView.h"

PsiNCPWindow::PsiNCPWindow(BRect frame)
				: BWindow(frame, "Psion-BeOS", B_TITLED_WINDOW, B_NOT_ZOOMABLE )
{
	BRect		r1, r2, all;
	BView		*backgrnd;
	BTabView	*tabView; 
	float		h, w;
	int32		w1, w2;
	
	// Setzen wir die Einstellungen auf den Standardwert!
	
	DataRate = (data_rate) 0;
	connected = false;
	Port = new BSerialPort();
	
	// Zuerst brauchen wir mal einen View, der in unserem Fenster liegt und als Hintergrund
	// dient. Mehr braucht das Teil nicht zu können, daher wird der View ohne Ableitung
	// direkt eingebunden!
	
	all = Bounds();
	backgrnd = new BView(all, "backgrnd", B_FOLLOW_ALL_SIDES, B_WILL_DRAW);
	backgrnd->SetViewColor(ui_color(B_PANEL_BACKGROUND_COLOR));

	AddChild(backgrnd);
	
	// An diesen View hängen wir zwei Buttons an. Links Disconnect und rechts Connect.
	
	BButt_conn = new BButton(all, NULL, "Connect", new BMessage(MSG_CONNECT), B_FOLLOW_BOTTOM | B_FOLLOW_RIGHT);
	BButt_conn->ResizeToPreferred();
	r1 = BButt_conn->Frame();
	
	BButt_disc = new BButton(all, NULL, "Disconnect", new BMessage(MSG_DISCONNECT), B_FOLLOW_BOTTOM | B_FOLLOW_LEFT);
	BButt_disc->ResizeToPreferred();
	r2 = BButt_disc->Frame();
	
	// Und zwar sollen diese Buttons am unteren Ende des Views landen!
	// Dazu muß ein bißchen was berechnet werden!

	h = all.bottom - (r1.Height() + 5);
	w1 = r1.IntegerWidth();
	w2 = r2.IntegerWidth();
	w = (all.right - (w1 + w2 + 10)) / 2;
	
	// Jetzt können wir die Buttons dahin schieben, bevor sie "Geaddet" werden.
	
	BButt_conn->MoveTo(all.right - (w1+w), h);
	BButt_disc->MoveBy(w, h);
	
	backgrnd->AddChild( BButt_conn );
	backgrnd->AddChild( BButt_disc );

	BButt_conn->MakeDefault(true);

	// Als nächstes soll darüber ein BTabView eingebaut werden.
	r1 = Bounds();
	r1.InsetBy(5,5); 
	r1.bottom -= r2.Height() + 10;
	
	tabView = new BTabView(r1, "tab_view", B_WIDTH_FROM_WIDEST); 
	tabView->SetViewColor(ui_color(B_PANEL_BACKGROUND_COLOR));

   
	r1 = tabView->Bounds(); 
	r1.InsetBy(5,5); 
	r1.bottom -= tabView->TabHeight(); 
	tabView->AddTab(new PsiNCPView(r1, "State", "ein Text"), NULL); 

	settingsView = new SettingsView(r1, "Settings", Port);	// Create the SettingsView. We need the pointer
	tabView->AddTab(settingsView, NULL);					// Add it to the TabView!

	addOnView = new AddOnView(r1, "Add-Ons");		// Create the AddOnView. We need the pointer!
	tabView->AddTab(addOnView, NULL);				// Add it to the TabView!

	backgrnd->AddChild(tabView);

	BButt_disc->SetEnabled(false);
	
	if (DataRate != 0 && *PortName != '\0') BButt_conn->SetEnabled(true);
	else BButt_conn->SetEnabled(false);

	NodeMonitorAddons();							// Start the NodeMonitor!

}

// Wird das Fenster wirklich gelöscht, geben wir wieder alles frei!

PsiNCPWindow::~PsiNCPWindow( void ) {

	delete Port;

}

//===============================================================================
// This function is used to start the NodeMonitor with the add-on Folder.
// If there is something, then we have to inform the view about this.
// It is neccesary to start the NodeMonitor in the Window-Class, because
// the view is inactive sometimes.

long PsiNCPWindow::NodeMonitorAddons(void) {

	app_info	apinfo;
	BEntry		ent;
	BPath		path;
	BDirectory	dir;
	node_ref	nref; 
	
	be_app->GetAppInfo(&apinfo);			// we are interested in our Startingdirectory
	ent.SetTo(&apinfo.ref);					// but we can get only the entry_ref of PalmBeach
	ent.GetParent(&dir);					// lets ask about the Directory of PalmBeach
	path.SetTo(&dir, "add-ons");			// and then look into the add-ons Directory
	dir.SetTo(path.Path());					// lats make a directory from the Path
	
	if (dir.InitCheck() == B_OK) {
		dir.GetNodeRef(&nref); 
		watch_node(&nref, B_WATCH_DIRECTORY, this); 
   }

	return 0;
}

// Dieser Programmteil empfängt alle Nachrichten des Fensters
void PsiNCPWindow::MessageReceived(BMessage *msg) {
	
	char		*str, nam[2]="0";
	int8		nr;
	thread_id	thrid;
	BTextControl	*btc;
	BAlert		*alert;
	
	char name[50];
//	uint32  type; 
//	int32	count;
	str = name;
//	for ( int32 i = 0; msg->GetInfo(B_ANY_TYPE, i, &str, &type, &count) == B_OK; i++ ) { 
//		printf("Message %c%c%c%c: %s Type:%c%c%c%c\n", msg->what>>24,msg->what>>16,msg->what>>8,msg->what, str, type>>24,type>>16,type>>8,type);
//	}
//	printf("---------------\n");
	
//	msg->FindInt32("be:value", &count);
//	printf("Be:Value=%ld\n", count);
	
	switch(msg->what) {
		case MSG_DISCONNECT:
			BButt_conn->SetEnabled(true);
			discon_all();
			connected = false;
			BButt_disc->SetEnabled(false);
			break;
		case MSG_CONNECT:
			BButt_conn->SetEnabled(false);
			Port->Open(PortName);
			Port->SetDataRate(DataRate);
			Port->SetBlocking(false); // we need this function because in R4 this was standard, in Genki it isn't

			thrid = spawn_thread(PsiWrite, "WritePsion", B_NORMAL_PRIORITY, Port);
			if (thrid >= B_NO_ERROR) resume_thread(thrid);

			connected = true;
			BButt_disc->SetEnabled(true);
			printf("Connect! %s with %d\n", PortName, DataRate);
			break;
		case MSG_NCP_CONN:		// Nachricht von ReadPort, daß eine Verbindung aktiviert wurde!
			msg->FindString("Portname", &str);
			msg->FindInt8("Portnummer", &nr);
			*nam = nr + '0';
			btc = (BTextControl *) FindView(nam);
			if (btc != NULL) btc->SetText(str);
			break;
		case MSG_NCP_DISC:		// Nachricht von ReadPort, daß eine Verbindung deaktiviert wurde!
			msg->FindInt8("Portnummer", &nr);
			*nam = nr + '0';
			btc = (BTextControl *) FindView(nam);
			if (btc != NULL) btc->SetText("");
			break;
		case B_NODE_MONITOR:	// Message comes from the NODE-Monitor, which tracks the add-ons-Folder
			msg->FindString("name", &str);		// Find the Filename
			addOnView->UpdateAddons( str );		// and start the Update!
			break;
		default:
			alert = new BAlert("", "NCPWindow: unknown Message arrived", "OK"); 
			alert->Go();
	}
	if (DataRate != 0 && *PortName != '\0' && !BButt_disc->IsEnabled()) BButt_conn->SetEnabled(true);
}


// Was solle passieren, wenn das Fenster geschlossen wird ?

bool PsiNCPWindow::QuitRequested()
{
	if (connected) {
		Minimize(true);
		return(false);
	} else {
		be_app->PostMessage(B_QUIT_REQUESTED);
		return(true);
	}
}

PsiNCPView::PsiNCPView(BRect rect, const char *name, const char *text)
	   	   : BView(rect, name, B_FOLLOW_ALL_SIDES, B_WILL_DRAW)
{
	BTextControl	*bt;
	BTextView		*tv;
	BRect			r;
	int 			i;
	char			chan[3] = "0:";
	char			n[2] = "0";
	
	SetViewColor(ui_color(B_PANEL_BACKGROUND_COLOR));
	
	r = Bounds();
	r.right -= r.Width() / 2;
	bt = new BTextControl(r, n, chan, "", NULL);
	bt->SetDivider(10);
	tv = bt->TextView();
	tv->SetFontAndColor(be_fixed_font);
	tv->MakeEditable(false);
	AddChild(bt);
	
	for (i = 1; i < NC_MAX_USER; i++) {
		*chan = *n = '0' + i;
		r = bt->Frame();
		bt = new BTextControl(r, n, chan, "", NULL);
		bt->SetDivider(10);
		bt->MoveBy(0, r.Height()+1);
		tv = bt->TextView();
		tv->SetFontAndColor(be_fixed_font);
		tv->MakeEditable(true);
		AddChild(bt);
	}
}
