#ifndef SHARE_STRINGS_ENGLISH_H
#define SHARE_STRINGS_ENGLISH_H

#include "BeShareNameSpace.h"

namespace beshare {

extern char shortcut(int ws);
extern const char * str(int whichString);
extern void SetLanguage(int whichLanguage);
extern const char * GetLanguageName(int whichLanguage);
extern int GetLanguage();

// Languages that are supported
enum {
   LANGUAGE_ENGLISH = 0,
   LANGUAGE_SPANISH,
   LANGUAGE_GERMAN,
   LANGUAGE_DUTCH,
   LANGUAGE_PORTUGUESE,
   LANGUAGE_FRENCH,
   LANGUAGE_ITALIAN,
   LANGUAGE_RUSSIAN,
   LANGUAGE_SWEDISH,
   LANGUAGE_ESPERANTO,
   LANGUAGE_NORWEGIAN,
   LANGUAGE_SERBIAN,
   LANGUAGE_BULGARIAN,
   LANGUAGE_MALKOVITCH,
   NUM_LANGUAGES
};
 
// Menu shortcuts used in the program
enum {
   SHORTCUT_CONNECT = 0,
   SHORTCUT_DISCONNECT,
   SHORTCUT_OPEN_SHARED_FOLDER,
   SHORTCUT_OPEN_DOWNLOADS_FOLDER,
   SHORTCUT_CLEAR_CHAT_LOG,
   SHORTCUT_RESET_LAYOUT,
   SHORTCUT_QUIT,
   SHORTCUT_FULL_USER_QUERIES,
   SHORTCUT_BEEP_WHEN_MENTIONED,
   SHORTCUT_OPEN_PRIVATE_CHAT_WINDOW,
   SHORTCUT_TOGGLE_FILE_LOGGING,
   SHORTCUT_FILE_SHARING_ENABLED,
   SHORTCUT_OPEN_LOGS_FOLDER,
   NUM_SHORTCUTS
};

// Strings used in the program
enum {
   STR_ANONYMOUS = 0,
   STR_UNKNOWN,
   STR_IS_NOW_CONNECTED,
   STR_HAS_DISCONNECTED,
   STR_USER_NUMBER,
   STR_AKA,
   STR_IS_NOW_KNOWN_AS,
   STR_TRUE,
   STR_FALSE,
   STR_UNKNOWN_TYPE,
   STR_USER,
   STR_IS_DOWNLOADING,
   STR_ERROR_WRITING_TO_FILE,
   STR_AN_ERROR_OCCURRED,
   STR_QUEUED_LOCAL_MACHINE_TOO_BUSY,
   STR_QUEUED_REMOTE_MACHINE_TOO_BUSY,
   STR_SENT,
   STR_RCVD,
   STR_SEC,
   STR_AWAITING_CALLBACK,
   STR_CONNECTING,
   STR_DOWNLOAD_COMPLETE,
   STR_DOWNLOAD_ABORTED,
   STR_COULDNT_CONNECT,
   STR_PREPARING_TO_UPLOAD,
   STR_PREPARING_TO_DOWNLOAD,
   STR_TO,
   STR_FROM,
   STR_ERROR_STARTING_DOWNLOAD_NO_ACCEPT_PORT,
   STR_ERROR_STARTING_DELAYED_CONNECT,
   STR_ERROR_STARTING_DELAYED_CONNECT_NO_TRANSCEIVER_THREAD,
   STR_ERROR_COULDNT_CREATE_CONNECT_THREAD,
   STR_SHARING_PERCENTI_LOCAL_FILES,
   STR_COULDNT_FIND_SHARED_SUBDIRECTORY_FILE_SHARING_DISABLED,
   STR_FILE_NAME_KEY,
   STR_USER_KEY,
   STR_SESSIONID_KEY,
   STR_CONNECTION_KEY,
   STR_FILE,
   STR_CONNECT_TO_SERVER,
   STR_DISCONNECT,
   STR_OPEN_SHARED_FOLDER,
   STR_OPEN_DOWNLOADS_FOLDER,
   STR_CLEAR_CHAT_LOG,
   STR_RESET_LAYOUT,
   STR_ABOUT_BESHARE,
   STR_QUIT,
   STR_ATTRIBUTES,
   STR_SETTINGS,
   STR_MAX_SIMULTANEOUS_UPLOADS,
   STR_MAX_SIMULTANEOUS_DOWNLOADS,
   STR_NO_LIMIT,
   STR_UPLOAD_BANDWIDTH,
   STR_LOG,
   STR_UPLOADS,
   STR_USER_EVENTS,
   STR_QUERY_CHANGES,
   STR_FULL_USER_QUERIES,
   STR_IM_FIREWALLED,
   STR_QUERY,
   STR_START_QUERY,
   STR_STOP_QUERY,
   STR_SERVER,
   STR_USER_NAME_COLON,
   STR_DOWNLOAD_SELECTED_FILES,
   STR_CLEAR_FINISHED_FAILED_TRANSFERS,
   STR_REMOVE_SELECTED,
   STR_CHAT_NOUN,
   STR_NAME,
   STR_ID,
   STR_BESHARE_IS_LISTENING_ON_PORT_PERCENTU,
   STR_COULDNT_START_FILE_SHARING_THREAD,
   STR_CANT_DOWNLOAD_FROM_USER,
   STR_COMMA_NO_CONNECTION_INFORMATION_AVAILABLE,
   STR_CANT_DOWNLOAD_FILES_FROM,
   STR_BECAUSE_BOTH_OF_US_ARE_BEHIND_FIREWALLS,
   STR_FILE_DOWNLOAD_ACCEPT_SESSION_FOR,
   STR_FAILED_TO_INITIALIZE,
   STR_FILE_DOWNLOAD_SESSION_TO,
   STR_CHANGED_QUERY_TO,
   STR_STARTED_QUERY,
   STR_COULDNT_START_SHAREFILETRANSFER_SESSION,
   STR_YOUR_NAME_HAS_BEEN_CHANGED_TO,
   STR_BY,
   STR_UNKNOWN_USER,
   STR_MESSAGE,
   STR_NOT_SENT,
   STR_NO_TARGET_USER_SPECIFIED_IN_MSG,
   STR_STOPPED_QUERY,
   STR_SYSTEM,
   STR_WARNING,
   STR_ERROR,
   STR_ACTION,
   STR_CONNECT_TO,
   STR_CONNECTING_TO,
   STR_PERCENTLU_RESULTS_SHOWN,
   STR_CONNECTED_TO,
   STR_CONNECTION_ESTABLISHED,
   STR_CONNECTING_TO_SERVER_DOTDOTDOT,
   STR_YOU_ARE_NO_LONGER_CONNECTED_TO_THE_MUSCLE_SERVER,
   STR_CONNECTION_TO_SERVER_FAILED,
   STR_ENGLISH,
   STR_SPANISH,
   STR_LANGUAGE_SELECTED,
   STR_LANGUAGE,
   STR_GERMAN,
   STR_KIND,
   STR_FILE_SIZE,
   STR_FILES,
   STR_DUTCH,
   STR_EXAMINING_FILES,
   STR_AVAILABLE_IRC_STYLE_COMMANDS,
   STR_SEND_A_PRIVATE_MESSAGE,
   STR_CHANGE_YOUR_USER_NAME,
   STR_DO_SOMETHING,
   STR_SYNONYM_FOR_ACTION,
   STR_CLEAR_THE_CHAT_LOG,
   STR_START_A_NEW_QUERY,
   STR_STOP_THE_CURRENT_QUERY,
   STR_CONNECT_TO_A_SERVER,
   STR_DISCONNECT_FROM_THE_SERVER,
   STR_QUIT_BESHARE,
   STR_SHOW_THIS_HELP_TEXT,
   STR_TOKEN_NAME_OR_SESSION_ID_TEXT,
   STR_TOKEN_NAME,
   STR_TOKEN_ACTION,
   STR_TOKEN_QUERY_STRING,
   STR_TOKEN_SERVER_NAME,
   STR_PORTUGUESE,
   STR_FRENCH,
   STR_BEEP_WHEN_MENTIONED,
   STR_MAX_SIMULTANEOUS_UPLOADS_PER_USER,
   STR_TIMESTAMPS,
   STR_AUTOCLEAR_COMPLETED_DOWNLOADS,
   STR_MAX_SIMULTANEOUS_DOWNLOADS_PER_USER,
   STR_ITALIAN,
   STR_LOGIN_ON_STARTUP,
   STR_PRIVATE_MESSAGES,
   STR_OPEN_PRIVATE_CHAT_WINDOW,
   STR_BESHARE_PRIVATE_CHAT,
   STR_CHAT_WITH,
   STR_ERROR_NO_USER_SPECIFIED,
   STR_SAVE_PRESET,
   STR_RESTORE_PRESET,
   STR_ERROR_UNKNOWN_COMMAND,
   STR_TYPE_HELP_FOR_LIST_OF_AVAILABLE_COMMANDS,
   STR_PERCENTLU_DASH_PERCENTLU_OF_PERCENTLU_RESULTS_SHOWN,
   STR_DISPLAY,
   STR_INFO_MESSAGES,
   STR_WARNING_MESSAGES,
   STR_ERROR_MESSAGES,
   STR_LOGGING_ENABLED,
   STR_LOGGING_DISABLED,
   STR_RESULTS_PER_PAGE,
   STR_SWITCH_TO_PAGE,
   STR_SPECIFY_USERS_TO_IGNORE,
   STR_IGNORE_PATTERN_SET_TO,
   STR_IGNORE_PATTERN_REMOVED,
   STR_TOKEN_NAMES_OR_SESSION_IDS,
   STR_MOVE_UP,   
   STR_MOVE_DOWN,   
   STR_HALT_DOWNLOAD,   
   STR_RESTART_DOWNLOAD,   
   STR_OPEN_FILE,
   STR_RUSSIAN,
   STR_CHAT_VERB,
   STR_CURRENT_IGNORE_PATTERN_IS,
   STR_DISABLED,
   STR_TRANSFERS_IN_PROGRESS_ARE_YOU_SURE_YOU_WANT_TO_QUIT,
   STR_DONT_QUIT,
   STR_MODIFICATION_TIME,
   STR_ESPERANTO,
   STR_SWEDISH,
   STR_PING_OTHER_CLIENTS,
   STR_PING_REPLY_LIMS,
   STR_SENT_PING_REQUEST_TO,
   STR_NORWEGIAN,
   STR_SERBIAN,
   STR_AUTO_AWAY_TAG,
   STR_AUTO_AWAY,
   STR_MINUTES,
   STR_TOKEN_MESSAGE_STRING,
   STR_CHANGE_THE_AUTO_AWAY_MESSAGE,
   STR_AWAY_MESSAGE_SET_TO,
   STR_FORCE_AWAY_STATE,
   STR_OPEN_FOLDER,
   STR_WATCH_PATTERN_SET_TO,
   STR_WATCH_PATTERN_REMOVED,
   STR_CURRENT_WATCH_PATTERN_IS,
   STR_SPECIFY_USERS_TO_WATCH,
   STR_ONLOGIN_COMMANDS_CLEARED,
   STR_TOKEN_COMMAND,
   STR_ADD_STARTUP_COMMAND, 
   STR_CLEAR_STARTUP_COMMANDS,
   STR_ADDED_STARTUP_COMMAND,
   STR_WATCH,
   STR_SERVER_STATUS_REQUESTED,
   STR_MEMORY_USED_AVAILABLE,
   STR_SERVER_STATUS,
   STR_SERVER_VERSION,
   STR_LOCAL_SESSION_ROOT,
   STR_SERVER_MEMORY_USAGE,
   STR_REQUEST_SERVER_STATUS,
   STR_SERVER_UPTIME,
   STR_WEEKS,
   STR_DAYS,
   STR_SYSTEM_UPTIME,
   STR_LOGGED_IN_FOR,
   STR_FILE_SHARING_ENABLED,
   STR_BAN_USER_FOR,
   STR_USER_AT_IP_PS_BANNED_FOR,
   STR_HOURS,
   STR_FOREVER,
   STR_REMOVE_ALL_UPLOAD_BANS,
   STR_REMOVING_PLU_UPLOAD_BANS,
   STR_AUTOPRIV_PATTERN_SET_TO,
   STR_AUTOPRIV_PATTERN_REMOVED,
   STR_SPECIFY_AUTOPRIV_USERS,
   STR_CURRENT_AUTOPRIV_PATTERN_IS,
   STR_ERROR_UNKNOWN_DATA_FORMAT,
   STR_OPEN_LOGS_FOLDER,
   STR_STATUS,
   STR_YOUR_STATUS_HAS_BEEN_CHANGED_TO,
   STR_IS_NOW,
   STR_LOAD,
   STR_SET_USER_STATUS_STRING,
   STR_BULGARIAN,
   STR_PATH,
   STR_RETAIN_FILE_PATHS,
   STR_SET_ALIAS,
   STR_REMOVED_ALIAS,
   STR_TOKEN_NAME_AND_VALUE,
   STR_CREATE_AN_ALIAS,
   STR_REMOVE_AN_ALIAS,
   STR_MOVE_TO_TOP,
   STR_MOVE_TO_BOTTOM,
   STR_SET_CUSTOM_WINDOW_TITLE,
   STR_CUSTOM_WINDOW_TITLE_IS_NOW,
   STR_AUTOUPDATE_SERVER_LIST,
   STR_ADDED_SERVER,
   STR_REMOVED_SERVER,
   STR_BESHARE_UPGRADE_NOTICE,
   STR_EXECUTE_SHELL_COMMAND,
   STR_EXECUTING_SHELL_COMMAND,
   STR_TOKEN_SHELL_COMMAND,
   STR_IDLE_COMMAND_SET_TO,
   STR_SET_COMMAND_FOR_WHEN_TRANSFERS_CEASE,
   STR_TOKEN_FONT_SIZE,
   STR_SET_FONT_SIZE,
   STR_FONT_SIZE_SET_TO,
   STR_FONT_SIZE_RESET_TO_DEFAULT,
   NUM_STRINGS
};

};  // end namespace beshare

#endif
