#include "PulseView.h"

static const short shades[] = {80, 88, 97, 106, 115, 124, 132, 141, 150, 159,
								168, 176, 185, 194, 203, 212, 220, 229, 238, 247};

void TPulseView::do_init ()
{
	BRect f = Frame();
	BRect draggerFrame (5, f.bottom - f.top - 12, 12, f.bottom - f.top - 5);
	AddChild (new BDragger (draggerFrame, this, 0));
	
	system_info si;
	get_system_info ( &si );
	numCPUs = si.cpu_count;
	
	SetViewColor (0, 0, 0);
	prevTicks = new double [numCPUs];
	memset (prevTicks, 0, numCPUs * sizeof(double));
	currentPositions = new int [numCPUs];
	memset (currentPositions, 0, numCPUs * sizeof(int));
	computeThread = spawn_thread (ComputeCPUTime, "ComputeCPUTime", B_NORMAL_PRIORITY, this);
	resume_thread (computeThread);
}

int32 TPulseView::ComputeCPUTime(void * data) {
	TPulseView *me = (TPulseView*) data;
	int numCPUs = me->numCPUs;
	double *prevTicks = me->prevTicks;
	int *currentPositions = me->currentPositions;
	
	bigtime_t lastUpdateTime = system_time();
	system_info fSysInfo;
	
	for (;;) {
		bigtime_t now = system_time();
		double scaleFactor = (100 / 4.9) / (now - lastUpdateTime);
		lastUpdateTime = now;
		get_system_info (&fSysInfo);
		for(int i=0; i < numCPUs; i++ ) 
		{
			int fNew = (fSysInfo.cpu_infos[i].active_time - prevTicks[i]) * scaleFactor;
			prevTicks[i] = fSysInfo.cpu_infos[i].active_time;
			if (fNew < 0)
				fNew = 0;
			if (fNew > 20)
				fNew = 20;
			if (fNew == currentPositions[i])
				continue;
			BRect drawRect (0, PROGRESS_HEIGHT * i + 2, 0, PROGRESS_HEIGHT * i + PROGRESS_HEIGHT - 1);
			me->Window()->Lock();
			if (fNew > currentPositions[i]) {
				for (int counter = currentPositions[i]; counter < fNew; counter++) {
					me->SetHighColor (0, shades[counter], 0);
					drawRect.left = counter * 7 + 2;
					drawRect.right = drawRect.left + 5;
					me->FillRect (drawRect);
				}
			}
			else {
				me->SetHighColor(75,75,75);
				for (int counter = fNew; counter <= currentPositions[i]; counter++) {
					drawRect.left = counter * 7 + 2;
					drawRect.right = drawRect.left + 5;
					me->FillRect (drawRect);
				}
			}
			me->Window()->Unlock();
			currentPositions[i] = fNew;
		}
		me->Flush();
		snooze(200000);
	}
}

status_t TPulseView::Archive(BMessage *data, bool deep) const
{
	inherited::Archive (data, deep);
	data->AddString ("class", "TPulseView");
	data->AddString ("add_on", "application/x-vnd.CS-MPUL");
	return B_OK;
}

TPulseView* TPulseView::Instantiate (BMessage *data)
{
	if (validate_instantiation (data, "TPulseView"))
		return new TPulseView (data);
	else
		return NULL;
}

void TPulseView::Draw (BRect /*updateRect*/) {
	int counter;
	for (int whichCPU = 0; whichCPU < numCPUs; ++whichCPU) {
		for (counter = 0; counter < currentPositions[whichCPU]; ++counter) {
			SetHighColor (0, shades[counter], 0);
			FillRect (BRect ((counter * 7) + 2, PROGRESS_HEIGHT*whichCPU + 2,
				(counter * 7) + 7, PROGRESS_HEIGHT*whichCPU + PROGRESS_HEIGHT - 1));
		}
		SetHighColor(75,75,75);
		for (counter = currentPositions[whichCPU]; counter < 20; ++counter) {
			FillRect (BRect ((counter * 7) + 2, PROGRESS_HEIGHT*whichCPU + 2,
				(counter * 7) + 7, PROGRESS_HEIGHT*whichCPU + PROGRESS_HEIGHT - 1));
		}
	}
}
