// MiniPulse
//
// MiniPulse 2:
//	Extended (Nov 2/1997) by Chris Herborth (chrish@qnx.com) to remember
//	its window position via libprefs.

#include <app/Application.h>
#include <interface/Window.h>
#include <stdio.h>
#include <stdlib.h>
#include <new.h>

#include "PulseView.h"
#include "Preferences.h"

Preferences *myPrefs;
PreferenceSet *mySettings;

class TPulseWindow : public BWindow {
	private:
		float screenRight, screenBottom;
		
	public:
		TPulseWindow( BRect frame )
			: BWindow( frame, "CPU Monitor", B_TITLED_WINDOW, B_NOT_RESIZABLE | B_NOT_ZOOMABLE )
		{
			system_info si;
			get_system_info ( &si );
			int numCPUs = si.cpu_count;
			
			ResizeTo (PROGRESS_WIDTH, numCPUs*PROGRESS_HEIGHT + 1);
			
			Lock();
			AddChild (new TPulseView(BRect (0, 0, PROGRESS_WIDTH, numCPUs*PROGRESS_HEIGHT + 1)));
			Unlock();
			Show();
		}

// TODO:
//
//	Should use this to make sure the MiniPulse is still visible on-screen somewhere?
//		
//		virtual void ScreenChanged (BRect frame, color_space)
//		{
//			MoveBy (frame.right - screenRight, frame.bottom - screenBottom);
//			screenRight = frame.right;
//			screenBottom = frame.bottom;
//		}

		bool QuitRequested()
		{
			// Save off our settings...
			BRect frame = Frame();
			if( mySettings->SetData( "frame", &frame, sizeof( frame ), B_RECT_TYPE ) ) {
				puts( "Can't save frame settings!\n" );
			} else if( mySettings->Save() ) {
				puts( "Can't save settings!\n" );
			}
		
			be_app->PostMessage(B_QUIT_REQUESTED);
			return TRUE;
		}
};

// Application mainline
int main( void )
{
	// Create a Preferences object.
	try {
		myPrefs = new Preferences( "x-vnd.CS-MiniPulse" );
		if( myPrefs->InitCheck() ) {
			fprintf( stderr, "Can't initialize preferences!\n" );
			return EXIT_FAILURE;
		}
	} catch ( bad_alloc &ex ) {
		fprintf( stderr, "Can't allocate preferences object!\n" );
		return EXIT_FAILURE;
	}

	// Create a PreferenceSet object.	
	try {
		mySettings = new PreferenceSet( *myPrefs, "hierarchical/extendable/settings", true );
		if( mySettings->InitCheck() ) {
			fprintf( stderr, "Can't get settings!\n" );
			return EXIT_FAILURE;
		}
	} catch ( bad_alloc &ex ) {
		fprintf( stderr, "Can't allocate preference set object!\n" );
		return EXIT_FAILURE;
	}

	// Create a BApplication object.
	BApplication *my_app;
	try {
		my_app = new BApplication("application/x-vnd.CS-MiniPulse");
	} catch ( bad_alloc &ex ) {
		fprintf( stderr, "Out of memory: Can't allocate BApplication object!\n" );
		return EXIT_FAILURE;
	}

	// Ask for our window frame from the preferences system.
	BRect frame;
	const void *data;
	size_t size;
	uint32 type = '    ';
	if( mySettings->GetData( "frame", data, size, type ) || ( type != B_RECT_TYPE ) ) {
		frame.Set( 100, 100, 1, 1 );
	} else {
		memcpy( &frame, data, size );
	}

	// Now create our window.
	TPulseWindow *my_window;
	try {
		my_window = new TPulseWindow( frame );
	} catch ( bad_alloc &ex ) {
		fprintf( stderr, "Out of memory: Can't allocate Pulse window!\n" );
		return EXIT_FAILURE;
	}

	// Start the app running; when it's done, we go away.
	my_app->Run();
	delete my_app;

	return EXIT_SUCCESS;
}
