//uInt32Gadget.cpp

#define BUILDING_LIB 1

#include <stdio.h>
#include <memory>
#include <SupportDefs.h>
//#include <string>
#include <String.h>
#include <string.h>
#include <stdlib.h>
#include <limits.h>
#include <float.h>
#include <errno.h>
#include <ctype.h>
#include <Application.h>
#include <Rect.h>
#include <Message.h>
#include <MenuItem.h>
#include <MenuBar.h>
#include <PopUpMenu.h>
#include <Window.h>
#include <View.h>
#include <SupportDefs.h>
#include <Beep.h>
#include <List.h>
#include <TextControl.h>
#include <TextView.h>
#include <ScrollView.h>
#include <Font.h>
#include <OS.h>
#include <Button.h>
#include <StatusBar.h>
#include <CheckBox.h>
#include <PictureButton.h>
#include <ColorControl.h>
#include <RadioButton.h>
#include <Point.h>
#include <TypeConstants.h>
#include <ListView.h>
#include <GraphicsDefs.h>
#include <File.h>
#include <Screen.h>
#include <Alert.h>
#include <Resources.h>
#include <StringView.h>
#include "DnumSpecificWindows.h"
#include "layoutMatrixItem.h"
#include "layoutMatrix.h"
#include "uInt32Gadget.h"
#include "Preferences.h"
#include "myroColour.h"
#include "myPreferences.h"
#include "warning.h"

UInt32Gadget	::	~UInt32Gadget() 
{
	//left blank
};//end


//ctor
UInt32Gadget	::	UInt32Gadget(	uint32 ui32paramInitValue,
						const char * paramName, 
						const char * paramLabel, 
						uint32 ui32paramMsg, 
						float fparamPixWidth,
						LayoutMatrix * lpparamLayoutMatrix,
						bool bparamMakeFocus) 
		: 	BTextControl(	BRect(0, 0, 32, 32), 
							paramName, 
							paramLabel, 
							NULL, 
							new BMessage(ui32paramMsg), 
							B_FOLLOW_NONE, 
							B_WILL_DRAW | B_NAVIGABLE),
			 bmMakeFocus(	bparamMakeFocus)
{
	try
	{
		LayoutMatrixItem * lmi = new LayoutMatrixItem(	(void *)this,
														lpparamLayoutMatrix,
														KIND_UINT32GADG);
		lpparamLayoutMatrix->mpLayoutMatrixItems->AddItem((void *)lmi);
	}
	catch (...)
	{
		warning(myPrefs->FailMemory);
		return;
	}
	lpparamLayoutMatrix->AddToChildren(this);
	SetFont(myPrefs->GetPreferredFont());
	char buf[16];
	sprintf(buf, "%lu", ui32paramInitValue);
	SetText(buf);
	if (fparamPixWidth)
	{
		mfPixWidth = fparamPixWidth;
	}
	else
	{
		BView bv(BRect(0, 0, 32, 32), "NoShowView", B_FOLLOW_NONE, 0);
		bv.SetFont(myPrefs->GetPreferredFont());
		mfPixWidth = bv.StringWidth(paramLabel);
	}
}//end


void 
UInt32Gadget	::	AttachedToWindow(	void)
{
	SetDrawingMode(B_OP_ADD);
	BTextControl	::	AttachedToWindow();
	rgb_color tempRgbColor;
	myPrefs->GetPreferredUInt32GadgetHighColor(&tempRgbColor);
	SetHighColor(tempRgbColor);
	myPrefs->GetPreferredUInt32GadgetLowColor(&tempRgbColor);
	SetLowColor(tempRgbColor);
	myPrefs->GetPreferredUInt32GadgetViewColor(&tempRgbColor);
	SetViewColor(tempRgbColor);
	if (bmMakeFocus) 
	{
		MakeFocus();
	}
}//end
