//truncateString.cpp

#define BUILDING_LIB 1

#include <stdio.h>
#include <SupportDefs.h>
#include <memory>
//#include <string>
#include <String.h>
#include <string.h>
#include <stdlib.h>
#include <limits.h>
#include <float.h>
#include <errno.h>
#include <ctype.h>
#include <Application.h>
#include <Rect.h>
#include <Message.h>
#include <MenuItem.h>
#include <MenuBar.h>
#include <PopUpMenu.h>
#include <Window.h>
#include <View.h>
#include <SupportDefs.h>
#include <Beep.h>
#include <List.h>
#include <TextControl.h>
#include <TextView.h>
#include <ScrollView.h>
#include <Font.h>
#include <OS.h>
#include <Button.h>
#include <StatusBar.h>
#include <CheckBox.h>
#include <PictureButton.h>
#include <ColorControl.h>
#include <RadioButton.h>
#include <Point.h>
#include <TypeConstants.h>
#include <ListView.h>
#include <GraphicsDefs.h>
#include <File.h>
#include <Screen.h>
#include <Alert.h>
#include <Resources.h>
#include <StringView.h>
#include "DnumSpecificWindows.h"
#include "truncateString.h"
#include "warning.h"
#include "Preferences.h"
#include "myPreferences.h"

bool
TruncateString(	const char * paramString,
				char * paramIntoBuf,
				float paramMaxPixelWidth,
				BFont * paramFont)
{
	BView view(BRect(0, 0, 32, 32), "NoShowView", B_FOLLOW_NONE, 0);
	view.SetFont(paramFont);
	float truncStringPixLen = view.StringWidth(paramString);
	if (truncStringPixLen <= paramMaxPixelWidth)
	{
		strcpy(paramIntoBuf, paramString);
		return true;
	}
	uint32 stringLen = strlen(paramString);
	if (stringLen < 5)
	{
		warning(myPrefs->truncShort);
		return false;
	}
	uint32 stringCenter = stringLen / 2;
	bool tooLong = true;
	uint32 remove = 1;
	char * tempBuf = new char[stringLen];
	do
	{
		tempBuf[0] = '\0';
		uint32 scminus = (stringCenter - remove);
		strncpy(tempBuf, paramString, scminus);
		tempBuf[scminus] = '\0';
		strcat(tempBuf, "…");
		strcat(tempBuf, &paramString[(stringCenter + remove)]);
		truncStringPixLen = view.StringWidth(tempBuf);
		if (truncStringPixLen <= paramMaxPixelWidth)
		{
			tooLong = false;
			strcpy(paramIntoBuf, tempBuf);
		}
		else
		{
			remove++;
		}
	}
	while (tooLong);
	delete [] tempBuf;
	return true;
}//end