//myStatusBar

#define BUILDING_LIB 1


#include <stdio.h>
#include <memory>
//#include <string>
#include <SupportDefs.h>
#include <String.h>
#include <string.h>
#include <stdlib.h>
#include <limits.h>
#include <float.h>
#include <errno.h>
#include <ctype.h>
#include <Application.h>
#include <Rect.h>
#include <Message.h>
#include <MenuItem.h>
#include <MenuBar.h>
#include <PopUpMenu.h>
#include <Window.h>
#include <View.h>
#include <SupportDefs.h>
#include <Beep.h>
#include <List.h>
#include <TextControl.h>
#include <TextView.h>
#include <ScrollView.h>
#include <Font.h>
#include <OS.h>
#include <Button.h>
#include <StatusBar.h>
#include <CheckBox.h>
#include <PictureButton.h>
#include <ColorControl.h>
#include <RadioButton.h>
#include <Point.h>
#include <TypeConstants.h>
#include <ListView.h>
#include <GraphicsDefs.h>
#include <File.h>
#include <Screen.h>
#include <Alert.h>
#include <Resources.h>
#include <StringView.h>
#include "DnumSpecificWindows.h"
#include "layoutMatrixItem.h"
#include "Preferences.h"
#include "myroColour.h"
#include "myPreferences.h"
#include "myStatusBar.h"
#include "layoutMatrix.h"
#include "warning.h"

MyStatusBar	::	~MyStatusBar() 
{
	//left blank
};//end


//ctor
MyStatusBar	::	MyStatusBar(	BRect paramFrame,
								const char * paramName,
								const char * paramLabel,
								const char * paramTrailingLabel,
								float fparamMaxValue,
								float fparamValue,
								LayoutMatrix * lpparamLayoutMatrix) 
				: 
					BStatusBar(	paramFrame,
								paramName,
								paramLabel,
								paramTrailingLabel),
					fValue(fparamValue)
{
	try
	{
		LayoutMatrixItem * lmi = new LayoutMatrixItem(	(void *)this,
														lpparamLayoutMatrix,
														KIND_MYSTATUSBAR);
		lpparamLayoutMatrix->mpLayoutMatrixItems->AddItem((void *)lmi);
	}
	catch (...)
	{
		warning(myPrefs->FailMemory);
		return;
	}
	SetMaxValue(fparamMaxValue);
	lpparamLayoutMatrix->AddToChildren((void *)this);
}//end


void
MyStatusBar	::	MyGetPreferredSize(	float * fpparamWidth,
									float * fpparamHeight)
{
	BView	bv(BRect(0, 0, 32, 32), "NoShowView", B_FOLLOW_NONE, 0);
	bv.SetFont(myPrefs->GetPreferredFont());
	font_height	fontHeight;
	bv.GetFontHeight(&fontHeight);
	float totalFontHeight = fontHeight.ascent + fontHeight.descent + fontHeight.leading;
	float barHeight = myPrefs->GetPreferredBarHeight();
	SetBarHeight(barHeight);
	float padWidth = 2 * bv.StringWidth("M");//needs some padding
	float textWidth = bv.StringWidth(Text());
	float trailingTextWidth = bv.StringWidth(TrailingText());
	float labelWidth = bv.StringWidth(Label());
	float trailingLabelWidth = bv.StringWidth(TrailingLabel());
	float totalWidth = textWidth + trailingTextWidth + labelWidth + trailingLabelWidth + padWidth;
	*fpparamWidth = totalWidth;
	*fpparamHeight = totalFontHeight + barHeight;//may need some padding??
}//end


void 
MyStatusBar	::	AttachedToWindow() 
{
	BView::AttachedToWindow();
	rgb_color tempRgbColor;
	myPrefs->GetPreferredMyStatusBarHighColor(&tempRgbColor);
	SetHighColor(tempRgbColor);
	myPrefs->GetPreferredMyStatusBarLowColor(&tempRgbColor);
	SetLowColor(tempRgbColor);
	myPrefs->GetPreferredMyStatusBarViewColor(&tempRgbColor);
	SetViewColor(tempRgbColor);
	Update(fValue);
}//end