//myListView.cpp

#define BUILDING_LIB 1

#include <stdio.h>
#include <memory>
//#include <string>
#include <SupportDefs.h>
#include <String.h>
#include <string.h>
#include <stdlib.h>
#include <limits.h>
#include <float.h>
#include <errno.h>
#include <ctype.h>
#include <Application.h>
#include <Rect.h>
#include <Message.h>
#include <MenuItem.h>
#include <MenuBar.h>
#include <PopUpMenu.h>
#include <Window.h>
#include <View.h>
#include <SupportDefs.h>
#include <Beep.h>
#include <List.h>
#include <TextControl.h>
#include <TextView.h>
#include <ScrollView.h>
#include <Font.h>
#include <OS.h>
#include <Button.h>
#include <StatusBar.h>
#include <CheckBox.h>
#include <PictureButton.h>
#include <ColorControl.h>
#include <RadioButton.h>
#include <Point.h>
#include <TypeConstants.h>
#include <ListView.h>
#include <GraphicsDefs.h>
#include <File.h>
#include <Screen.h>
#include <Alert.h>
#include <Resources.h>
#include <StringView.h>
#include "DnumSpecificWindows.h"
#include "layoutMatrixItem.h"
#include "layoutMatrix.h"
#include "Preferences.h"
#include "myroColour.h"
#include "dataNode.h"
#include "myListView.h"
#include "warning.h"
#include "dataList.h"
#include "myPreferences.h"

MyListView	::	~MyListView() 
{
	//left blank
};//end


//ctor
MyListView	::	MyListView(	const char * paramName,
							DataList * pparamDataList,
							uint32 ui32paramSelectMsg,
							uint32 ui32paramInvokeMsg,
							list_view_type ui32paramSelectType,
							LayoutMatrix * lpparamLayoutMatrix) 
				: 
					BListView(	BRect(0,0,32,32), 
								paramName, 
								ui32paramSelectType, 
								B_FOLLOW_LEFT | B_FOLLOW_TOP, 
								B_WILL_DRAW | B_NAVIGABLE | B_FRAME_EVENTS),
					fmWidth(0),
					fmHeight(0)
{
	try
	{
		LayoutMatrixItem * lmi = new LayoutMatrixItem(	(void *)this,
														lpparamLayoutMatrix,
														KIND_MYLISTVIEW);
		lpparamLayoutMatrix->mpLayoutMatrixItems->AddItem((void *)lmi);
	}
	catch (...)
	{
		warning(myPrefs->FailMemory);
		return;
	}
	lpparamLayoutMatrix->AddToChildren((void *)this);
	try
	{
		float temp = 0;
		BView bv(BRect(0, 0, 32, 32), "NoShowView", B_FOLLOW_NONE, 0);
		bv.SetFont(myPrefs->GetPreferredFont());
		font_height fontHeight;
		bv.GetFontHeight(&fontHeight);
		bv.RemoveSelf();
		fmHeight = fontHeight.ascent + fontHeight.descent + fontHeight.leading;
		fmHeight *= pparamDataList->list->CountItems();
		DataNode * node;
		//#pragma warn_possunwant off
		for (	int32 i = 0; 
				node = (DataNode *)pparamDataList->list->ItemAt(i); 
				i++) 
		{
		//#pragma warn_possunwant reset
			const char * name = node->GetText();
			BStringItem * bsi = new BStringItem(name);
			AddItem(bsi);
			bsi->SetEnabled(true);
			temp = bv.StringWidth(name);
			if (temp > fmWidth)
			{
				fmWidth = temp;
			}
		}
		temp = fontHeight.ascent + fontHeight.descent + fontHeight.leading;
		temp *= .5;
		fmHeight += temp;
		temp = bv.StringWidth("ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890");
		temp /= 36;
		fmWidth += (temp / 2);
		if (ui32paramSelectMsg)
		{
			SetSelectionMessage(new BMessage(ui32paramSelectMsg));
		}
		if (ui32paramInvokeMsg)
		{
			SetInvocationMessage(new BMessage(ui32paramInvokeMsg));
		}
		rgb_color viewColor;
		myPrefs->GetPreferredMyListViewViewColor(&viewColor);
		SetViewColor(viewColor);
		myPrefs->GetPreferredMyListViewHighColor(&viewColor);
		SetHighColor(viewColor);
		myPrefs->GetPreferredMyListViewLowColor(&viewColor);
		SetLowColor(viewColor);
	}
	catch (...)
	{
		warning(myPrefs->FailMemory);
		throw;
	}
}//end


void 
MyListView	::	AttachedToWindow() 
{
	BListView::AttachedToWindow();
	rgb_color tempRgbColor;
	myPrefs->GetPreferredMyListViewViewColor(&tempRgbColor);
	SetViewColor(tempRgbColor);
	myPrefs->GetPreferredMyListViewHighColor(&tempRgbColor);
	SetHighColor(tempRgbColor);
	myPrefs->GetPreferredMyListViewLowColor(&tempRgbColor);
	SetLowColor(tempRgbColor);
}//end


void
MyListView	::	MyGetPreferredSize(	float * fpparamWidth,
									float * fpparamHeight)
{
	*fpparamHeight = fmHeight;
	*fpparamWidth = fmWidth;
}//end