//basicColorWindow.cpp

#define BUILDING_LIB 1

#include <stdio.h>
#include <memory>
//#include <string>
#include <SupportDefs.h>
#include <String.h>
#include <string.h>
#include <stdlib.h>
#include <limits.h>
#include <float.h>
#include <errno.h>
#include <ctype.h>
#include <Application.h>
#include <Rect.h>
#include <Message.h>
#include <MenuItem.h>
#include <MenuBar.h>
#include <PopUpMenu.h>
#include <Window.h>
#include <View.h>
#include <SupportDefs.h>
#include <Beep.h>
#include <List.h>
#include <TextControl.h>
#include <TextView.h>
#include <ScrollView.h>
#include <Font.h>
#include <OS.h>
#include <Button.h>
#include <StatusBar.h>
#include <CheckBox.h>
#include <PictureButton.h>
#include <ColorControl.h>
#include <RadioButton.h>
#include <Point.h>
#include <TypeConstants.h>
#include <ListView.h>
#include <GraphicsDefs.h>
#include <File.h>
#include <Screen.h>
#include <Alert.h>
#include <Resources.h>
#include <StringView.h>
#include "DmenuMsg.h"
#include "DnumSpecificWindows.h"
#include "DcolorControlMessages.h"
#include "windowGuts.h"
#include "s2f.h"
#include "layoutMatrixItem.h"
#include "layoutMatrix.h"
#include "textItem.h"
#include "myStringDrawer.h"
#include "Preferences.h"
#include "myCheckBox.h"
#include "myColorControl.h"
#include "colorWell.h"
#include "prefPanelWindow.h"
#include "basicColorWindow.h"
#include "warning.h"
#include "myroColour.h"
#include "myPreferences.h"
#include "verify.h"
#include "colorWell.h"
#include "myColorControl.h"
	

//ctor
BasicColorWindow	::	BasicColorWindow(	BRect	paramBound,
									const char * paramWindowTitle,
									const char * paramScrollViewName,
									const char * paramNamePrefFrame)
				: 
				WindowGuts(	paramBound, 
							paramWindowTitle, 
							paramScrollViewName,
							paramNamePrefFrame,
							myPrefs->PrefSignature,
							myPrefs->mpPreferenceSet),
				pmViewColorControl(NULL),
				pmHighColorControl(NULL),
				pmLowColorControl(NULL),
				pmViewColorWell(NULL),
				pmHighColorWell(NULL),
				pmLowColorWell(NULL)
{
	sem_id calc_sem;
	if ((calc_sem = create_sem(1, "calc_sem")) < B_NO_ERROR)
	{
		warning(myPrefs->FailCreateSemaphore);
		return;
	}
	acquire_sem(calc_sem);
	try 
	{
		LayoutMatrix * pholdTitleLayoutMatrix = new LayoutMatrix(BESTSIZE, 1, 1, this);//rows,columns
/////////////////////////////////////////////////////////////////////////////////////////////
		BFont * pBFont = new BFont(myPrefs->GetPreferredFont());
		float fontSize = pBFont->Size();
		fontSize *= 3;
		if (fontSize > 200)
		{
			fontSize = 200;
		}
		pBFont->SetSize(fontSize);
		pBFont->SetShear(122);
		//will need offset for demo--use a seperate matrix and get it's bottom
		MyStringDrawer * pMyStringDrawer = new MyStringDrawer(	"basicColorHeading", 
																myPrefs->BasicColorWindowHeading1,
																pBFont,
																pholdTitleLayoutMatrix);
/////////////////////////////
		if (!myPrefs->bUseColorControl && !myPrefs->bUseColorWell)
		{
			warning(myPrefs->noCCenabled);
		}
		LayoutMatrix * pholdViewCCLayoutMatrix = NULL;
		LayoutMatrix * pholdHighCCLayoutMatrix = NULL;
		LayoutMatrix * pholdLowCCLayoutMatrix = NULL;
		MyStringDrawer * pMyStringDrawerAXX = NULL;
		MyStringDrawer * pMyStringDrawerBXX = NULL;
		MyStringDrawer * pMyStringDrawerCXX = NULL;
		rgb_color color;//re-use for every setvalue
		if (myPrefs->bUseColorControl)
		{
			pholdViewCCLayoutMatrix = new LayoutMatrix(BESTSIZE, 2, 1, this);//rows,columns
	/////////////////////////////////////////////////////////////////////////////////////
			pMyStringDrawerAXX = new MyStringDrawer(	"MyStringDrawerAXX", 
														myPrefs->ColorWindowHeading2,
														NULL,
														pholdViewCCLayoutMatrix);
	////////////////////////////////////////////////////////////////////
			pmViewColorControl = new MyColorControl(	BPoint(1, 1), 
														B_CELLS_8x32,//lots of other options! Make a pref??
														1,
														"ColorControlAXX", 
														COLORCONTROL_VIEW, 
														true,
														//this,
														pholdViewCCLayoutMatrix);
			myPrefs->GetPreferredViewColor(&color);
			pmViewColorControl->SetValue(color);
	/////////////////////
			pholdHighCCLayoutMatrix = new LayoutMatrix(BESTSIZE, 2, 1, this);//rows,columns
	////////////////////////////////
			pMyStringDrawerBXX = new MyStringDrawer(	"MyStringDrawerBXX", 
														myPrefs->ColorWindowHeading3,
														NULL,
														pholdHighCCLayoutMatrix);
	/////////////////////////////////////////////
			pmHighColorControl = new MyColorControl(	BPoint(1, 1), 
														B_CELLS_8x32,
														1,
														"HighColorControlBXX", 
														COLORCONTROL_HIGH, 
														true,
														//this,
														pholdHighCCLayoutMatrix);
			myPrefs->GetPreferredHighColor(&color);
			pmHighColorControl->SetValue(color);
	//////////////////////////////////////////////////////////////
			pholdLowCCLayoutMatrix = new LayoutMatrix(BESTSIZE, 2, 1, this);//rows,columns
	///////////////////////////////////////////////////
			pMyStringDrawerCXX = new MyStringDrawer(	"MyStringDrawerCXX", 
														myPrefs->ColorWindowHeading4,
														NULL,
														pholdLowCCLayoutMatrix);
	///////////////////////////////////////////////////////////////////
			pmLowColorControl = new MyColorControl(	BPoint(1, 1), 
													B_CELLS_8x32,
													1,
													"LowColorControlCXX", 
													COLORCONTROL_LOW, 
													true,
													//this,
													pholdLowCCLayoutMatrix);
			myPrefs->GetPreferredLowColor(&color);
			pmLowColorControl->SetValue(color);
		}
////////////////////////
		LayoutMatrix * pholdColorWellLayoutMatrix = NULL;
		TextItem * pholdMainViewColorWellText = NULL;
		TextItem * pholdMainHighColorWellText = NULL;
		TextItem * pholdMainLowColorWellText = NULL;
		if (myPrefs->bUseColorWell)
		{
			pholdColorWellLayoutMatrix = new LayoutMatrix(BESTSIZE, 3, 1, this);//rows,columns
	//////////////
			pholdMainViewColorWellText = new TextItem(	myPrefs->ColorWindowHeading5,
														pholdColorWellLayoutMatrix);
			pmViewColorWell = new ColorWell(	"ColorWellViewColorPref",
												VIEW_COLOR,
												pholdMainViewColorWellText,
												pholdColorWellLayoutMatrix);
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			pholdMainHighColorWellText = new TextItem(	myPrefs->ColorWindowHeading6,
														pholdColorWellLayoutMatrix);
			pmHighColorWell = new ColorWell(	"ColorWellHighColorPref", 
												HIGH_COLOR,
												pholdMainHighColorWellText,
												pholdColorWellLayoutMatrix);
	////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			pholdMainLowColorWellText = new TextItem(	myPrefs->ColorWindowHeading7,
														pholdColorWellLayoutMatrix);
			pmLowColorWell = new ColorWell(	"ColorWellLowColorPref", 
											LOW_COLOR,
											pholdMainLowColorWellText,
											pholdColorWellLayoutMatrix);
		}
//////////////
		release_sem(calc_sem);
		pholdTitleLayoutMatrix->Calc(MATRIXHORIZONTALOFFSET, MATRIXVERTICALOFFSET, calc_sem);
		float bottom = pholdTitleLayoutMatrix->bottom;
		if (myPrefs->bUseColorControl)
		{
			pholdViewCCLayoutMatrix->Calc(MATRIXHORIZONTALOFFSET, bottom, calc_sem);
			pholdHighCCLayoutMatrix->Calc(pholdViewCCLayoutMatrix->right, bottom, calc_sem);
			pholdLowCCLayoutMatrix->Calc(pholdHighCCLayoutMatrix->right, bottom, calc_sem);
			bottom = pholdLowCCLayoutMatrix->bottom;
		}
		if (myPrefs->bUseColorWell)
		{
			pholdColorWellLayoutMatrix->Calc(MATRIXHORIZONTALOFFSET, bottom, calc_sem);
		}
	}
	catch (...)
	{
		warning(myPrefs->CaughtBasicColorWindowCTOR);
		release_sem(calc_sem);
		throw;
	}
	try 
	{
		BMenuItem *	menuItem;
		BMenu *		APPMenu = new BMenu(myPrefs->AppMenuLabel);
		menuItem = new BMenuItem(	myPrefs->AboutMenuLabel, 
									new BMessage(ABOUT_BASICCOLORWINDOW));
		APPMenu->AddItem(menuItem);
		menuItem = new BMenuItem(	myPrefs->CloseWindow, 
									new BMessage(B_QUIT_REQUESTED));
		APPMenu->AddItem(menuItem);
		menuItem = new BMenuItem(	myPrefs->QuitMenuLabel, 
									new BMessage(QUIT_APP));
		APPMenu->AddItem(menuItem);
		pMenuBar->AddItem(APPMenu);
	}
	catch(...) 
	{
		throw;
	}
}//end


//dtor
BasicColorWindow	::	~BasicColorWindow() 
{
	if (myPrefs->pPrefPanelWindow)//can get a race if not checked
	{
		myPrefs->pPrefPanelWindow->mpPrefWindows[PP_BASIC] = NULL;
	}
}//end


bool
BasicColorWindow	::	QuitRequested(	void) 
{
	BRect frame = Frame();
	myPrefs->SetPreferredBasicColorWindowRect(frame);
	if (pmViewColorControl)//if you got one you got 'em all
	{
		rgb_color color(pmViewColorControl->ValueAsColor());
		myPrefs->SetPreferredViewColor(&color);
		color = pmHighColorControl->ValueAsColor();
		myPrefs->SetPreferredHighColor(&color);
		color = pmLowColorControl->ValueAsColor();
		myPrefs->SetPreferredLowColor(&color);
	}
	return(WindowGuts::QuitRequested());
}//end


void
BasicColorWindow	::	ResetDemo(	void)
{
	myPrefs->bPrefChangesMade = true;
}//end


void
BasicColorWindow	::	MessageReceived(	BMessage * pparamMessage) 
{
	switch(pparamMessage->what) 
	{
		case ABOUT_BASICCOLORWINDOW:
		{
			BString warn = myPrefs->AboutBasicColorWindowMsg1;
			warn += myPrefs->AboutBasicColorWindowMsg2;
			warning(warn.String());
		break;
		}
		case QUIT_APP:
			if (Verify(myPrefs->ReallyQuitApp))
			{
				be_app->PostMessage(B_QUIT_REQUESTED);
			}
		break;
		case COLORCONTROL_VIEW:
		case COLORCONTROL_HIGH:
		case COLORCONTROL_LOW:
			ResetDemo();
		break;
		case roColourDROPPEDMESSAGE: 
		{
    		rgb_color * pRGBColor;
    		rgb_color color;  		
    		int32 numRGBBytes = sizeof(struct rgb_color);
	        if (	pparamMessage->FindData(	"RGBColor",
		       									B_RGB_COLOR_TYPE, 
												(const void**)&pRGBColor, 
												&numRGBBytes ) 
					== B_OK)
	        {
	           	color = *pRGBColor;
	            if (pparamMessage->WasDropped()) 
	            {
					int32 colorToChange;
					if (	pparamMessage->FindInt32(	"ColorToChange",
														&colorToChange)
							 == B_OK)
					{
						switch(colorToChange)
						{
							case VIEW_COLOR:
								myPrefs->SetPreferredViewColor(&color);
								pmViewColorControl->SetValue(color);
							break;
							case HIGH_COLOR:
								myPrefs->SetPreferredHighColor(&color);
								pmHighColorControl->SetValue(color);
							break;
							case LOW_COLOR:
								myPrefs->SetPreferredLowColor(&color);
								pmLowColorControl->SetValue(color);
							break;
							case NO_COLOR:
								warning(myPrefs->DemoRoNo);
							break;
							default:
								warning(myPrefs->RoBadMsg);
								throw;
							break;
						}
						ResetDemo();
					}
				}
			}
		break;
		}
		default:
			WindowGuts::MessageReceived(pparamMessage);
		break;
	}
}//end
