// ***************************************************************************
// Implementation System Includes
// ***************************************************************************

// ***************************************************************************
// Implementation Project Includes
// ***************************************************************************

#include "Hustler.h"
#include "HustlerApp.h"
#include "HustlerMain.h"

// ***************************************************************************
// Implementation Constant Definitions
// ***************************************************************************

// ***************************************************************************
// Implementation Type Definitions
// ***************************************************************************

// ***************************************************************************
// Implementation Variable Definitions
// ***************************************************************************

// ***************************************************************************
// Implementation Function Declarations
// ***************************************************************************

// ***************************************************************************
// Global Variable Definitions
// ***************************************************************************

// ***************************************************************************
// PUBLIC Member Function Definitions: Lifecycle
// ***************************************************************************

// ===========================================================================
// Constructor
// ===========================================================================

tHustlerApp::tHustlerApp() 
  : BApplication(APP_SIGNATURE)
{ 
  /*!
   * [NOTE] More than one replicant is allowed.
   *
   * Every time the Hustler application is run it adds a new replicant to the
   * Deskbar. This is okay, since a user may have more than one CD-ROM drive,
   * and might want to play several CDs at the same time (although this is
   * not very likely). Because each replicant is self-contained, we don't 
   * have to worry about synchronization issues between them.
   *
   * If for some reason I want to restrict the number of replicants, it
   * should happen here, in tHustlerApp's constructor. We should ask the 
   * Deskbar if a Hustler replicant already exists (by sending scripting 
   * commands to its Shelf), and if it does, we quit without sending another
   * replicant.
   */
   
  // Archive the Hustler replicant.
  BMessage lMessage(B_ARCHIVED_OBJECT);
  tHustler* lpHustler = new tHustler();
  lpHustler->Archive(&lMessage);
  delete lpHustler;

  // Send the replicant to the deskbar.
  BMessenger lMessenger("application/x-vnd.Be-TSKB");
  lMessenger.SendMessage(&lMessage);

  BBG_WRITE(("[tHustlerApp::tHustlerApp] Replicant sent to the Deskbar."));
  
  // Commit suicide.
  PostMessage(B_QUIT_REQUESTED);
}

// ***************************************************************************
// PUBLIC Member Function Definitions: Operators
// ***************************************************************************

// ***************************************************************************
// PUBLIC Member Function Definitions: Operations
// ***************************************************************************

// ***************************************************************************
// PUBLIC Member Function Definitions: Access
// ***************************************************************************

// ***************************************************************************
// PUBLIC Member Function Definitions: Inquiry
// ***************************************************************************

// ***************************************************************************
// PROTECTED Member Function Definitions
// ***************************************************************************

// ***************************************************************************
// PRIVATE Member Function Definitions
// ***************************************************************************

// ***************************************************************************
// Helper Function Definitions
// ***************************************************************************

// ***************************************************************************
// Global Function Definitions
// ***************************************************************************

// ***************************************************************************
// Implementation Function Definitions
// ***************************************************************************
