//
//
//	regex compiler C++ wrapper
//
//								(C) Alain Gautherot 1999

#if !defined(_REGULAR_EXPRESSION_H_)
#define _REGULAR_EXPRESSION_H_

#include "HomerLibBuild.h"

#include <support/SupportDefs.h>
#include <sys/types.h>
#include <malloc.h>
#include "my_regex.h"
#include <stdio.h>


enum
{
	// predefined syntaxes
	EMACS_SYNTAX					= RE_SYNTAX_EMACS,
	AWK_SYNTAX						= RE_SYNTAX_AWK,
	GNU_AWK_SYNTAX					= RE_SYNTAX_GNU_AWK,
	POSIX_AWK_SYNTAX				= RE_SYNTAX_POSIX_AWK,
	GREP_SYNTAX						= RE_SYNTAX_GREP,
	EGREP_SYNTAX					= RE_SYNTAX_EGREP,
	POSIX_EGREP_SYNTAX				= RE_SYNTAX_POSIX_EGREP,
	ED_SYNTAX						= RE_SYNTAX_ED,
	SED_SYNTAX						= RE_SYNTAX_SED,
	BASIC_POSIX_SYNTAX				= RE_SYNTAX_POSIX_BASIC,
	MININAL_BASIC_POSIX_SYNTAX		= RE_SYNTAX_POSIX_MINIMAL_BASIC,
	EXTENDED_POSIX_SYNTAX			= RE_SYNTAX_POSIX_EXTENDED,
	EXTENDED_MINIMAL_POSIX_SYNTAX	= RE_SYNTAX_POSIX_MINIMAL_EXTENDED,

	ICASE_SYNTAX					= 0x80000000
};

//---------------------------------------------------------
// regular expression
//---------------------------------------------------------
typedef reg_syntax_t	RegexSyntax;
class RegexString;

class HOMER_LIB_SYMBOL			RegularExpression
{
	friend RegexString;

	status_t					status;
	struct re_pattern_buffer	regexp;

	void						AllocateTranslationTable();

public:
	RegularExpression(const char* , RegexSyntax = EXTENDED_POSIX_SYNTAX, bool = false);
	~RegularExpression();

	status_t					InitCheck() const;
	bool						CompileFastMap();

	void						UnsetTranslation();
	void						SetTranslation(const char , const char , uint32 = 1);
	void						SetTranslation(const char , const char , const char );
	void						SetCaseSensitive();
	void						SetCaseInsensitive();
};


//---------------------------------------------------------
// regex match
//---------------------------------------------------------
class HOMER_LIB_SYMBOL	RegexMatch
{
	enum
	{
		NOMATCH_OFFSET	= 0x80000000
	};

public:
	regoff_t			start;
	regoff_t			end;

	RegexMatch(regoff_t s = NOMATCH_OFFSET, regoff_t e = NOMATCH_OFFSET)
	: start(s), end(e)
	{}
	~RegexMatch()
	{}
	bool			IsNull() const
	{ return (start >= 0) && (start == end); }
	bool			IsValid(int maxlen) const
	{ return (start >= 0) && (start <= end) && (end <= maxlen); }

	RegexMatch&		operator=(const RegexMatch& m)
	{ start = m.start; end = m.end; return *this;}
	bool			operator==(const RegexMatch& m) const
	{ return (start == m.start) && (end == m.end); }
	bool			operator!=(const RegexMatch& m) const
	{ return !(*this == m); }
	void			Print()
	{ printf("(%d %d)", start, end); }
};


//---------------------------------------------------------
// regex string
//---------------------------------------------------------
class HOMER_LIB_SYMBOL			RegexString
{
	//-----------------------------------------------------------
	class						RegexRegisters
	{
	public:
		struct re_registers		registers;

		RegexRegisters()
		{
			registers.num_regs = 0;
			registers.start = NULL;
			registers.end = NULL;
		}
		~RegexRegisters()
		{ Reset(); }
		void					GetRange(regoff_t& s, regoff_t& e) const
		{
			s = registers.start[0];
			e = registers.end[0];
		}
		void					Reset()
		{
			registers.num_regs = 0;
			if (registers.start != NULL)
			{
				free(registers.start);
				registers.start = NULL;
			}
			if (registers.end != NULL)
			{
				free(registers.end);
				registers.end = NULL;
			}
		}
		void					Dump(char* s)
		{
			for (int32 i = 0; i < registers.num_regs; i++)
			{
				if (registers.start[i] >= 0)
					printf("%d/ %d-%d: %s\n", i, registers.start[i],
						registers.end[i], s+registers.start[i]);
			}
		}
	};


	//-----------------------------------------------------------
	int					stringLen;
	char*				stringPtr;
	RegexRegisters		reg;

	const char*			strcasechr(const char* , const char );
	const char*			strcasestr(const char* , const char* );

public:
	RegexString(char* );
	~RegexString();

	bool				IsEmpty() const;
	char*				GetString() const;

	bool				Skip(const RegexMatch& , char** = NULL);
	bool				Skip(int = 1, char** = NULL);

	// search methods
	RegexMatch			Search(RegularExpression* , bool = true);
	RegexMatch			Search(const char* , bool = true);
	RegexMatch			Search(const char , bool = true);
	RegexMatch			SearchLast(RegularExpression* , bool = true);
	RegexMatch			SearchLast(const char* , bool = true);
	RegexMatch			SearchLast(const char , bool = true);

	// match methods
	RegexMatch			Match(RegularExpression* , bool = true);
	RegexMatch			Match(const char* , bool = true);
	RegexMatch			Match(const char , bool = true);
	RegexMatch			MatchLast(RegularExpression* , bool = true);
	RegexMatch			MatchLast(const char* , bool = true);
	RegexMatch			MatchLast(const char , bool = true);
};


#endif /* _REGULAR_EXPRESSION_H_ */

