//
//
//	Homer command
//
//								(C) Alain Gautherot 1999

#if !defined(_HOMER_COMMAND_H_)
#define _HOMER_COMMAND_H_

#include "HomerBuild.h"
#include "HomerLibBuild.h"

#include "MessagesList.h"

#include <interface/StringView.h>
#include <storage/File.h>
#include <storage/Path.h>
#include <storage/Entry.h>
#include <storage/Directory.h>

#include <stdio.h>


//---------------------------------------------------------
// Homer command
//---------------------------------------------------------
class HOMER_LIB_SYMBOL		HomerCommand
{
	char*					name;

public:
	HomerCommand();
	~HomerCommand();

	char*					GetName() const;
	void					SetName(const char* );

	BView*					DefaultCommandView(const char* );
	virtual BView*			CommandView();
	virtual status_t		GetConfig(BMessage* , BView* );
	virtual status_t		SetConfig(BMessage* , BView* );
	virtual status_t		Process(entry_ref , BMessage* , BLooper* );

	struct HOMER_LIB_SYMBOL FileProcessor
	{
		entry_ref			ref;
		FileProcessor(const entry_ref& r): ref(r) {}
		virtual ~FileProcessor() {}
		virtual status_t	Process(BFile* in, BFile* out)
		{ return B_OK; }
	};
	static status_t			ProcessFile(FileProcessor& );

	struct HOMER_LIB_SYMBOL LineProcessor
	{
		entry_ref			ref;
		LineProcessor(const entry_ref& r): ref(r) {}
		virtual ~LineProcessor() {}
		virtual status_t	Process(char* l, int lc)
		{ return B_OK; }
	};
	enum
	{
		MAX_LINE_SIZE		= 256
	};
	static status_t		ProcessLines(BFile* , LineProcessor& );
};

#if defined(_BUILDING_ADDON_)
extern char HOMER_SYMBOL	addonName[];
extern char HOMER_SYMBOL	addonVersion[];
extern char HOMER_SYMBOL	addonAuthor[];
extern char HOMER_SYMBOL	addonEmail[];
extern "C" HOMER_SYMBOL 	HomerCommand* instantiate_command();
#endif /* _BUILDING_ADDON_ */


#endif /* _HOMER_COMMAND_H_ */
