//
//
//	Homer
//
//								(C) Alain Gautherot 1999

#ifndef _HOMER_H_
#define _HOMER_H_

#include "HomerLibBuild.h"
#include <app/Application.h>


enum
{
	HOMER_SETTINGS			= 'Hset',
	HOMER_EDITOR_SETTINGS	= 'Heds',
	HOMER_FILTER_SETTINGS	= 'Hfts',
	HOMER_COMMAND_SETTINGS	= 'Hcds',

	ADD_HOMER_MESSAGE		= 'Hmsg',
	ADD_ADDON_MESSAGE		= 'Haom'
};

extern int main();

class EntriesRoster;
extern EntriesRoster*	filtersRoster;
extern EntriesRoster*	commandsRoster;


//---------------------------------------------------------
// Homer application
//---------------------------------------------------------
class MessageListItem;
class HOMER_LIB_SYMBOL	Homer: public BApplication
{
public:
	Homer(BWindow* (*)(bool ), const char* );
	virtual ~Homer();

	static status_t		_ReadPrefs(const char* , uint32 , BMessage* );
	static status_t		ReadPrefs(BMessage* );
	static status_t		ReadEditorPrefs(BMessage* );
	static status_t		ReadFilterPrefs(const char* , BMessage* );
	static status_t		ReadCommandPrefs(const char* , BMessage* );

	static status_t		_WritePrefs(const char* , uint32 , BMessage* );
	static status_t		WritePrefs(BMessage* );
	static status_t		WriteEditorPrefs(BMessage* );
	static status_t		WriteFilterPrefs(const char* , BMessage* );
	static status_t		WriteCommandPrefs(const char* , BMessage* );

	static void			Init();
	static void			Exit();
	static void			SetSignature(EntriesRoster* , const char* );
	static BWindow*		BuildWindow(bool = true);

	static void			SendHomerMessage(MessageListItem* , BLooper* );
	static void			SendAddOnMessage(MessageListItem* , BLooper* );

	static char*		PreprocessString(const entry_ref& , const char* );
	static void			PreprocessStrings(const entry_ref& , BMessage* );
};


#endif /* _HOMER_H_ */
