.\"
.\" Copyright (c) Mark J. Kilgard, 1996.
.\"
.TH glutSolidTeapot 3GLUT "3.7" "GLUT" "GLUT"
.SH NAME
glutSolidTeapot, glutWireTeapot - render a solid or wireframe teapot respectively. 
.SH SYNTAX
.nf
.LP
void glutSolidTeapot(GLdouble size);
void glutWireTeapot(GLdouble size);
.fi
.SH ARGUMENTS
.IP \fIsize\fP 1i
Relative size of the teapot. 
.SH DESCRIPTION
glutSolidTeapot and glutWireTeapot render a solid or wireframe
teapot respectively. Both surface normals and texture coordinates for the
teapot are generated. The teapot is generated with OpenGL evaluators. 
.SH BUGS
The teapot is greatly over-tesselated; it renders way too slow.

OpenGL's default glFrontFace state assumes that front facing polygons
(for the purpose of face culling)
have vertices that wind counter clockwise when projected into window
space.  This teapot is rendered with its front facing polygon vertices
winding clockwise.  For OpenGL's default back face culling to work,
you should use:
.nf
.LP
  glFrontFace(GL_CW);
  glutSolidTeapot(size);
  glFrontFace(GL_CCW);
.fi
.LP
Both these bugs reflect issues in the original aux toolkit's
teapot rendering routines (GLUT used the same teapot rendering routine).
.SH SEE ALSO
glutSolidSphere, glutSolidCube, glutSolidCone, glutSolidTorus, glutSolidDodecahedron,
glutSolidOctahedron, glutSolidTetrahedron, glutSolidIcosahedron
.SH AUTHOR
Mark J. Kilgard (mjk@nvidia.com)
