//a function to inspect a string to see if it is a valid uint32, then convert it if it is
#include "s2uint32.h"
#include "warning.h"
#include <limits.h>
#include <errno.h>
#include <ctype.h>

uint32 
s2uint32(	const char * in) 
{
/*Joerg (Stegemenn??) said to try using strtoul, so here is a first approximation
It seems to me we need a whole new range of these:
uint32 strtouint32(char, char *, int);
int32 strtoint32(char, char *, int);
int64 strtoint64(char, char *, int);
etc.
I'm not even sure in reality that the following is correct for uint32!
*/
	//first we must test for negativity in the string--strtoul() does not do this
	long			len = strlen(in);
	for (long i = 0; i < len; i++)
	{
		if (in[i] == '-')
		{
			warning("Entry negative!\n\nSetting value to 0.\n\nMust be a non-negative value between 0 and 4294967295, inclusive.\n");
			return(0);
		}
		else if (!(isspace(in[i])))//just skip over whitespaces
		{
			i = len;
		}
	}
	char *			cpError = NULL;
	unsigned long	ulResult = strtoul(in, &cpError, 10);
	if (errno == ERANGE)
	{
		warning("Overflow, number too big!\n\nSetting value to 4294967295.\n");
		return(ULONG_MAX);
	}
	else if (*cpError)
	{
		warning("Entry not a valid uint32 digit!\n\nSetting value to 0.\n\nMust be a non-negative value between 0 and 4294967295, inclusive.\n");
		return(0);
	}
	else return (uint32)ulResult;
}//end