//scrolling pref window

#include "textItem.h"
#include "layoutMatrixItem.h"
#include "layoutMatrix.h"
#include "myStringDrawer.h"
#include "warning.h"
#include "preferences.h"
#include "myRoColor.h"
#include "myPreferences.h"
#include "myApp.h"
#include "windowGuts.h"
#include "myCheckBox.h"
#include "prefPanelWindow.h"
#include "fontPrefWindow.h"
#include "fontDisplayWindow.h"
#include <memory>

//ctor
FontDisplayWindow	::	FontDisplayWindow(	BRect paramBound,
											const char * ccpparamWindow,
											const char * ccpparamScrollViewName,
											const char * ccpparamNamePrefFrame,
											const char * ccpparamPutString)
			: 
				WindowGuts(	paramBound, 
							ccpparamWindow, 
							ccpparamScrollViewName,
							ccpparamNamePrefFrame),
				mcpPutString(ccpparamPutString)
{
	sem_id calc_sem;
	if ((calc_sem = create_sem(1, "calc_sem")) < B_NO_ERROR)
	{
		warning("Could not create_sem.\n");
		return;
	}
	acquire_sem(calc_sem);
	try 
	{
		BWindow bw(	BRect(0, 0, 32, 32), 
					"noshow", 
					B_DOCUMENT_WINDOW, 
					/*B_WILL_ACCEPT_FIRST_CLICK*/0);
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		auto_ptr<LayoutMatrix> apStringDrawerLayoutMatrix(new LayoutMatrix(&bw, BESTSIZE, 1, 1));//rows,columns
		LayoutMatrix *	pholdStringDrawerLayoutMatrix = apStringDrawerLayoutMatrix.get();
		apStringDrawerLayoutMatrix.release();
		AddToLayoutMatrixList(pholdStringDrawerLayoutMatrix);
/////////////////////////////////////////////////////////////////////////////////////////////
		auto_ptr<BFont> apBFont(new BFont(myPrefs->GetPreferredFont()));
		BFont * pBFont = apBFont.get();
		apBFont.release();
		auto_ptr<MyStringDrawer> apMyStringDrawer(new MyStringDrawer(	"displayFontMyStringDrawer", 
																		mcpPutString, 
																		B_FOLLOW_NONE, 
																		B_WILL_DRAW,
																		pBFont));
		MyStringDrawer * pMyStringDrawer = apMyStringDrawer.get();
		apMyStringDrawer.release();
		pholdStringDrawerLayoutMatrix->AddToChildren((void *)pMyStringDrawer);
		auto_ptr<LayoutMatrixItem> apMyStringDrawerLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																							(void *)pMyStringDrawer, 
																							pholdStringDrawerLayoutMatrix->itemsList,
																							KIND_STRINGDRAWER));
///////////////////////////////////////////////////////////////////////////////////////////////////////
		release_sem(calc_sem);
		pholdStringDrawerLayoutMatrix->Calc(	MATRIXHORIZONTALOFFSET, 
												MATRIXVERTICALOFFSET, 
												calc_sem);
	}
	catch (...)
	{
		release_sem(calc_sem);
		throw;
	}
	BMenuItem *	menuItem;
	BMenu *		appMenu = new BMenu("app");
	try 
	{
		auto_ptr<BMessage> msg(new BMessage(ABOUT_FONTDISPLAYWINDOW));
		menuItem = new BMenuItem(	"about...", 
									msg.get());
		msg.release();
	}
	catch(...) 
	{
		throw;
	}
	appMenu->AddItem(menuItem);
	try 
	{
		auto_ptr<BMessage> msg(new BMessage(B_QUIT_REQUESTED));
		menuItem = new BMenuItem(	"Close window", 
									msg.get());
		msg.release();
	}
	catch(...) 
	{
		throw;
	}
	appMenu->AddItem(menuItem);
	pMenuBar->AddItem(appMenu);
}//end


//dtor
FontDisplayWindow	::	~FontDisplayWindow() 
{	
	if (myPrefs->pPrefPanelWindow)
	{
		if (myPrefs->pPrefPanelWindow->mpFontPrefWindow)
		{
	
			((FontPrefWindow *)(myPrefs->pPrefPanelWindow->mpFontPrefWindow))->mpFontDisplayWindow = NULL;
		}
	}
}//end


void
FontDisplayWindow	::	MessageReceived(	BMessage * pparamMessage) 
{
	switch(pparamMessage->what) 
	{
		
		case ABOUT_FONTDISPLAYWINDOW:	
		{
			warning("about Font Display window\n");
		break;
		}
		default:
			WindowGuts::MessageReceived(pparamMessage);
		break;
	}
}//end


bool
FontDisplayWindow	::	QuitRequested() 
{
	BRect frame = Frame();
	myPrefs->SetPreferredFontDisplayWindowRect(frame);
	return(WindowGuts::QuitRequested());
}//end