/*
Name:
GUS_DRV2.C

Description:
  GUS native driver (using onboard DRAM and mixer), based on the MikMod
  virtual timer interrupt.  This driver is good for situations where
  high-accuracy timing of music and other things is needed, but it
  WILL NOT work in Windows (see GUS_DRV1.C).

Portability:

MSDOS:  BC(y)   Watcom(y)       DJGPP(y)
Win95:  n
Os2:    n
Linux:  n

(y) - yes
(n) - no (not possible or not useful)
(?) - may be possible, but not tested

*/

#include "gus.h"
#include "mikmod.h"
#include "timer.h"


void GUS_OldUpdate(void)
{
    md_player();
                       
    if(GUS_BPM != md_bpm)
    {  VT_SetBPM(playertimer,md_bpm);
       GUS_BPM=md_bpm;
    }
    GUS_Common_Update();
}

BOOL GUS_OldInit(void)
{
    if(GUS_Common_Init()) return 1;
    playertimer = VT_Alloc();
    VT_SetHandler(playertimer,GUS_OldUpdate);

    return 0;
}


void GUS_OldExit(void)
{
    VT_Free(playertimer);
    UltraClose();
    if(ghld!=NULL) free(ghld);
    ghld = NULL;
}


void GUS_OldPlayStart(void)
{
    GUS_Common_Start();
    VT_SetBPM(playertimer,125);
    VT_Start(playertimer);
}

void GUS_OldPlayStop(void)
{
    VT_Stop(playertimer);
    UltraDisableOutput();
}



MDRIVER drv_oldgus =
{   NULL,
    "Gravis Ultrasound",
    "MikMod GUS Driver v2.0 (virtual timer)",
    GUS_IsThere,
    GUS_Load,
    GUS_UnLoad,
    GUS_SampleSpace,
    GUS_SampleLength,
    GUS_OldInit,
    GUS_OldExit,
    GUS_SetNumChannels,
    GUS_OldPlayStart,
    GUS_OldPlayStop,
    GUS_Dummy,
    GUS_VoiceSetVolume,
    GUS_VoiceSetFrequency,
    GUS_VoiceSetPanning,
    GUS_VoicePlay,
    GUS_VoiceStop,
    GUS_VoiceStopped,
    GUS_VoiceReleaseSustain,
    GUS_VoiceGetPosition,
    GUS_RealVolume
};

