/*
Name:
GUS_DRV1.C

Description:
  GUS native driver (using onboard DRAM and mixer), based on the GUS timer
  interrupt.  This is the Windows-friendly GUS driver, but is not as accur-
  ate as the virtual timer version (GUS_DRV2.C)

Portability:

MSDOS:  BC(y)   Watcom(y)       DJGPP(y)
Win95:  n
Os2:    n
Linux:  n

(y) - yes
(n) - no (not possible or not useful)
(?) - may be possible, but not tested

*/

#include "gus.h"
#include "mirq.h"



void GUS_Update(void)
{
    if(timecount<timeskip)
    {  timecount++;
       return;
    }
    timecount=1;

    md_player();

    if(GUS_BPM != md_bpm)
    {   UltraSetBPM(md_bpm);
        GUS_BPM = md_bpm;
    }
    GUS_Common_Update();
}
        

BOOL GUS_Init(void)
{
    if(GUS_Common_Init()) return 1;
    UltraTimer1Handler(GUS_Update);

    return 0;
}



void GUS_Exit(void)
{
    UltraClose();
    if(ghld!=NULL) free(ghld);
    ghld = NULL;
}


void GUS_PlayStart(void)
{
    GUS_Common_Start();
    UltraSetBPM(125);
}



void GUS_PlayStop(void)
{
    UltraStopTimer(1);
    UltraDisableOutput();
}



MDRIVER drv_gus =
{   NULL,
    "Gravis Ultrasound",
    "MikMod GUS Driver v2.1 (gus timer)",
    GUS_IsThere,
    GUS_Load,
    GUS_UnLoad,
    GUS_SampleSpace,
    GUS_SampleLength,
    GUS_Init,
    GUS_Exit,
    GUS_SetNumChannels,
    GUS_PlayStart,
    GUS_PlayStop,
    GUS_Dummy,
    GUS_VoiceSetVolume,
    GUS_VoiceSetFrequency,
    GUS_VoiceSetPanning,
    GUS_VoicePlay,
    GUS_VoiceStop,
    GUS_VoiceStopped,
    GUS_VoiceReleaseSustain,
    GUS_VoiceGetPosition,
    GUS_RealVolume
};  


