/*
	DUALPLAYER V1.04 (c) by Tinic Uro

	PlayList class
*/	

#ifndef _PL_OBJECT_
#define _PL_OBJECT_

#include "zoonic.h"
#include "Dual.h"	// dualplayer object methods

/*
	Superclass name and version
*/
static const char *pl_superclass="dualplayer/playlister/baseplaylist.zclass"; 
static const int32 pl_version=1;

/* 
	Methods
*/
enum
{
	PL_ACTIVATE=0x1000,					// void (void)						Activate the playlist. Preferably load the list here.
	PL_DISACTIVATE,						// void (void)						Disactivate, e.g. also destroy window, remove any locks.
	PL_SHOW,							// void (void)						Show the window if applicable
	PL_HIDE,							// void (void)						Hide the window if applicable
	PL_REFRESH,							// void (void)						Refresh the whole window
	PL_PLAYNEXT,						// void (void)						Play next entry
	PL_PLAYPREV,						// void (void)						Play previous entry
	PL_PLAYCURRENT,						// void (void)						Play current entry
	PL_PLAYNUM,							// void (int32 num)					Play spefific entry, based on the fastbuttons
	PL_PLAYRANDOM,						// void (void)						Play random entry
	PL_KEYDOWN,							// void (char *data, int32 num)	Forwarded KeyDown() from all Views
	PL_SETATTR=B_METHOD_SETATTR,		// int32 (int32 attr, int32 data)
	PL_GETATTR=B_METHOD_GETATTR	,		// int32 (int32 attr, int32 data)
};

/*
	Attributes
*/
enum
{
	PL_ATTR_PREFS=0x10,					// S--	BMessage *					Preferences object of DualPlayer.
	PL_ATTR_ID,							// -G-  char *						ID String of the playlist. MUST be valid!!
	PL_ATTR_DUALOBJECT,					// S--	Object *					callback object to perform actions in DualPlayer.
	PL_ATTR_PREFSDIR,					// S--	char *						path of the DualPlayer preferences directory
	PL_ATTR_ISHIDDEN,					// -G- 	int32						Is the window hidden?
	PL_ATTR_NUMENTRIES,					// -G-	int32						Num of entries, not used yet
	PL_ATTR_LISTUSED,					// -G-	int32						Can the list be used, are there any entries? 
										//									Return FALSE if the list is empty or locked.
};
										// |||
										// ||+- Direct return. If not set, data should contain a pointer to store the data.
										// ||
										// |+-- Getable Attribute
										// |
										// +--- Setable Attribute

#endif