/*
	LightZButton class	V0.1alpha
*/

#include <InterfaceKit.h>
#include "LightZButton.h"

LightZButton::
LightZButton(
	BRect 		 frame,
	const char 	*name,
	const char 	*label,
	BMessage 	*message,
	uint32 resizeMask,
	uint32 flags):
BControl(frame,name,label,message,resizeMask,flags)
{
	SetMessage(message);
	SetFlags(Flags()|B_NAVIGABLE);
	msg=message;
	marked=FALSE;
}

void LightZButton::DrawExtra(bool selected)
{
	struct font_height 	fi;
	BRect				temp;
	BPoint				foo;
	float				add;
	if(Window()->Lock())
	{
	
		SetFont(be_plain_font);
		SetFontSize(10.0);
	
		if(!selected) 	SetHighColor(222,222,222);
		else			SetHighColor(188,188,188);
		if(!selected) 	SetLowColor(222,222,222);
		else			SetLowColor(188,188,188);

		if(marked)
		{
			SetHighColor(100,166,222);
			SetLowColor(100,166,222);
		}
			
		FillRect(Bound);
	
	
		if(!selected)	SetHighColor(128,128,128);
		else			SetHighColor(128,128,128);

		StrokeRect(BRect(BPoint(0,0),BPoint(0,Bound.Height()-1)));
		StrokeRect(BRect(BPoint(0,0),BPoint(Bound.Width()-1,0)));

		if(!selected)	SetHighColor(255,255,255);
		else			SetHighColor(192,192,192);

		StrokeRect(BRect(BPoint(1,1),BPoint(1,Bound.Height()-2)));
		StrokeRect(BRect(BPoint(1,1),BPoint(Bound.Width()-2,1)));

		if(!selected)	SetHighColor(192,192,192);
		else			SetHighColor(255,255,255);
	
		StrokeRect(BRect(BPoint(1,Bound.Height()-1),BPoint(Bound.Width()-1,Bound.Height()-1)));
		StrokeRect(BRect(BPoint(Bound.Width()-1,1),BPoint(Bound.Width()-1,Bound.Height()-1)));

		GetFontHeight(&fi);
		
		if(!selected)	SetHighColor(128,128,128);
		else			SetHighColor(128,128,128);
		
		StrokeRect(BRect(BPoint(0,Bound.Height()),BPoint(Bound.Width(),Bound.Height())));
		StrokeRect(BRect(BPoint(Bound.Width(),0),BPoint(Bound.Width(),Bound.Height())));
		
		SetHighColor(0,0,0);

		SetDrawingMode(B_OP_COPY);
	
		if(!IsEnabled()) SetHighColor(128,128,128);
	
		if(selected)add=0;else add=-1;
	
		MovePenTo(BPoint(((Bound.Width()-StringWidth(Label()))/2)+add+1,(Bound.Height()+fi.ascent)/2+add));
		DrawString(Label());	
		
		if(IsFocus())
		{
			BRect r=Bound;	
			r.left+=2;
			r.top+=2;
			r.right-=2;
			r.bottom-=2;
			SetHighColor(66,66,66);
			StrokeRect(r,B_MIXED_COLORS);
		}

		Sync();
		Window()->Unlock();
	}
}

void LightZButton::SetMark(bool state)
{
	marked=state;
	Draw(Bound);
}

bool LightZButton::IsMarked(void)
{
	return marked;
}

void LightZButton::AttachedToWindow(void)
{
	Bound=Bounds();	
}

LightZButton::~LightZButton()
{
}

void LightZButton::SetPictureType(int32 type)
{
	Draw(Bound);
}

void LightZButton::Draw(BRect updateRect)
{
	DrawExtra(FALSE);	
}

void LightZButton::KeyDown(const char *data, int32 num)
{
	switch(data[0])
	{
		case	B_ENTER:
				DrawExtra(TRUE);
				if(IsEnabled())Window()->PostMessage(msg);
				snooze(50000);
				DrawExtra(FALSE);
				break;
				
		case	B_FUNCTION_KEY:
		case	B_LEFT_ARROW:
		case	B_RIGHT_ARROW:
		case	's':
		case	'S':
		case	B_ESCAPE:
		case	'P':
		case	'p':
				if(Parent())Parent()->KeyDown(data,num);
				break;

		default:
				BControl::KeyDown(data,num);
				break;
	}
}

void LightZButton::MouseDown(BPoint point)
{
	uint32 	buttons;
	bool	selected=TRUE,oldsel=FALSE;
	
	if(!IsEnabled())return;

	DrawExtra(TRUE);
	MakeFocus();
	do 
	{
		snooze(30000);
		if
		(
			  (point.x>(Bound.RightBottom().x))
			||(point.y>(Bound.RightBottom().y))
			||(point.x<(Bound.LeftTop().x))
			||(point.y<(Bound.LeftTop().y))
		)
		{
			selected=FALSE;
			if(oldsel==TRUE)
			{
				DrawExtra(FALSE);
				oldsel=FALSE;
			}
		}
		else
		{
			selected=TRUE;
			if(oldsel==FALSE)
			{
				DrawExtra(TRUE);
				oldsel=TRUE;
			}
		}
		GetMouse(&point, &buttons);
	} 
	while ( buttons );
	
	DrawExtra(FALSE);
	
	if(selected)
	{
		if(IsEnabled())Invoke();
	}
}