///////////////////////////////////////////
//
// file:  App.h
//
// Copyright 1998 Johnny Be Good! Software
//
//                John R. Ashmun
//                jrashmun@halcyon.com
//
///////////////////////////////////////////

#include <Application.h>
#include <E-mail.h>
#include <parsedate.h>

#include "DirRefFilter.h"

extern void increment_file_name_version( char* );
extern void time_to_date_time_file_name_string( char*, time_t );

class Application : public BApplication
{
   public:
      char*         buffer;
      char*         buffer2;
      char*         date;
      char*         enclosure;
      char*         final_boundary;
      char*         from;
      char*         mime_version;
      char*         name;
      char*         priority;
      char*         reply_to;
      char*         sent;
      char*         subject;
      char*         to;
      int           header_length;
      int           content_length;
      time_t        message_time;
      off_t         file_size;
      BList*        entry_list;
      entry_ref*    scriptref;
      BFilePanel*   open_panel;
      BFilePanel*   save_panel;
      DirRefFilter* dirs_only_filter;
      int32         nargs;

      Application( );

      ~Application( );

      void RefsReceived( BMessage* );

      void ReadyToRun( );

      void MessageReceived( BMessage* );

   private:
      void process_entry( BEntry );

      void parse_header_line( const char*, char** );
};
