/*
 * Copyright (C) 1999 Daisuke Sato
 * Author : D.Sato <satozzz@cadvision.com>
 *
 * There are no warranties of any kind for this program. If you use this
 * program, you do so at your own risk. The authors are not responsible for any
 * damages  that might result from using this program.
 */
#ifndef _STRETC_H
#define _STRETC_H

#include <Be.h> 

typedef enum {
    STR_FETCH_INIT = 0,
    STR_FETCH_NEXT
} str_fetch_t ;

class strEtc
{
    private :
        char *initp ;
        char *work ;
        int   wklen ;
        int   count ;
        
        int   len ;
        
        int   _Lstrlen ( const char *source ) ;
        char *_Lstrstr ( const char *str, const char *seek ) ;
        char *_Ltok    ( char *strToken, const char *strDelimit ) ;
        
    public :
        strEtc  ( const char *buff, const int buflen ) ;
        ~strEtc () ;
        
        void unpack     ( const char *separator,
                                int  *n_item,
                                char *item[] ) ;
        int  strcount   ( const char *str ) ;
        char *strFetch  ( const char *separator, str_fetch_t flg ) ;
        void unpackChar ( const char *separator, 
                                int  *n_item, 
                                char *item[] ) ;
        char *charTok   ( const char       *separator, 
                          const str_fetch_t flg ) ;
        int  countChar  ( const char *str ) ;
} ;

#endif