/*
 * Copyright (C) 1999 Daisuke Sato
 * Author : D.Sato <satozzz@cadvision.com>
 *
 * There are no warranties of any kind for this program. If you use this
 * program, you do so at your own risk. The authors are not responsible for any
 * damages  that might result from using this program.
 */
#include "corsrep.h"


char *charORstrReplace::_LcharORstrtok( const char *strToken, 
                                        const char *strDelimit ) 
{
    static char *str ;
    static int   dlen ;
    static char *top ;
    register int i ;

    if( strToken != NULL ){ /* Initialize */
        top  = str = ( char * )strToken ;
        dlen = strlen( strDelimit ) ;
	}
    else{
        top = str ;
	}

	while( *str != ( char )NULL ){
		for( i = 0; i < dlen; i++ ){
			if( *str == *( strDelimit + i ) ){
                if( memcmp( str, strDelimit, dlen ) == 0 ){
                    *str = ( char )NULL ;
                    str += dlen ;
                }
                else{
    				*str = ( char )NULL ;
	    			str++ ;
                }
				return top ;
			}
		}
	    str++ ;
	}

    if( *top == ( char )NULL ) return NULL ;
	return top ;
}


char *charORstrReplace::_charORstrFetch( const char *str,
                                         const char *separator,
                                         const int   flg )
{
    static char *getP, *ret ;
 
    if( flg == 0 ){ /* Initialize */
        getP = ( char * )str ;
    }
    
    getP = _LcharORstrtok( getP, separator ) ;
    ret = getP ;
    getP = NULL  ;
    
    return ret ;   
}


int charORstrReplace::strcount( const char *src,  /* In */
                                const char *str ) /* In */
{
    register int *get ;
    register int *tmp;
    int len ;

    len = strlen( str ) ;
    count = 0 ;
    get = ( int * )src ;
    while( (tmp = ( int * )strstr( ( char * )get, ( char * )str ) ) ){
        get = tmp + len ;
        count++ ;
    }
     return count ;
}/* strcount END */


void charORstrReplace::replace( FILE *out, 
                                char *src,         /* In */
                                const char *to,    /* In */ 
                                const char *from ) /* In */
{
    char *ret ;
    int   c ;

    c = 0 ;
    while( (ret = _charORstrFetch( src, from, c++ )) != NULL ){
        fprintf( out, "%s%s", ret, to ) ;
    }
}
/*
 * End.
 */
