/*******************************************************************************/
//
// ClockView.cpp
//
//
/*******************************************************************************/

//#include <stdio.h>

#include "ClockView.h"

extern const char *CLOCK_RAM_SIGNATURE;
extern bool NotReplicant;

ClockView::ClockView( BRect r )
	: BStringView( r, "ClockView", TimeStr, B_FOLLOW_NONE,
	B_WILL_DRAW|B_PULSE_NEEDED )
{
//  If replicant upper-left should be 0,0; otherwise set by ClockWindow?
	BRect draggerRect(Bounds());
	draggerRect.OffsetTo( B_ORIGIN );
	draggerRect.top = draggerRect.bottom-7;
	draggerRect.left = draggerRect.right-7;
	BDragger *dragger = new BDragger( draggerRect, this, 0 );
	AddChild( dragger );
	InitView();
}


// The next three functions are for implementating as Replicant.
ClockView::ClockView( BMessage *data )
	: BStringView( data )
{
}

status_t
ClockView::Archive( BMessage *data, bool deep ) const
{
	
	BView::Archive( data, deep );
	data->AddString( "add_on", CLOCK_RAM_SIGNATURE );
	return B_NO_ERROR;
}


ClockView*
ClockView::Instantiate( BMessage *data )
{
	if ( !validate_instantiation( data, "ClockView" ) ) return NULL;
	NotReplicant = false;
	ClockView * CV = new ClockView( data );
	CV->InitView();
	return CV;
}


ClockView::~ClockView()
{
}


//  Move to Constructor?
void
ClockView::InitView( void ){
	// Build pop-up menu.  NOTE:
	// Changing order of AddItem() calls will break switch{} in Refresh().
	ClockMenu = new BPopUpMenu( "ClockRAM" );
	BMenuItem *item;
	item = new BMenuItem( "Hours:Minutes", NULL );
	ClockMenu->AddItem( item );
	item = new BMenuItem( "Hours:Minutes:Seconds", NULL );
	ClockMenu->AddItem( item );
	item = new BMenuItem( "Month/Day/Year", NULL );
	ClockMenu->AddItem( item );
	ClockMenu->AddSeparatorItem();
	item = new BMenuItem( "Display Free RAM", NULL );
	// Set this marked (default RAM display - just cosmetic; only read at MouseDown().
	item->SetMarked( true );
	// This is real default:
	MenuIdx = 4;
	ClockMenu->AddItem( item );
	if( NotReplicant ){
		ClockMenu->AddSeparatorItem();
		item = new BMenuItem( "Quit", new BMessage(B_QUIT_REQUESTED), 'Q' );
		ClockMenu->AddItem( item );
		SetViewColor( 200, 200, 200, 0 );
		SetLowColor( 200, 200, 200, 0 );
	}
	//item->SetEnabled( FALSE );

	// Set text attrs.
	SetAlignment( B_ALIGN_CENTER );
	SetFontSize(11.0);
}


void
ClockView::AttachedToWindow( void ){
	// Trying to call this before here was very bad... :->
	BWindow *ParentWindow = Window();
	ParentWindow->SetPulseRate( 5000000 );
	Pulse();	// Is this legal?
}


// Why does this exist as implemented?
void
ClockView::MessageReceived( BMessage *m )
{
	switch ( m->what ) {
		default:
			BView::MessageReceived( m );
	}
}

void
ClockView::MouseDown( BPoint p )
{
	BMenuItem *selected;

	ConvertToScreen( &p );
	selected = ClockMenu->Go( p );

	if ( selected ) {
		selected->SetMarked( !(selected->IsMarked()) );
		//=JB - should just set true; can set false if you select
		//  what is already selected. - Yep, it does...
		MenuIdx = ClockMenu->IndexOf( selected );
		// Adjust pulse rate as appropriate to task;
		//   theoretically saves bandwidth?
		BWindow *ParentWindow = Window();
		switch ( MenuIdx ){
			case 0:
				// Hours:Minutes.
				ParentWindow->SetPulseRate( 10000000 );	// 10 secs.
				Pulse();	// Is this legal?  (Well, it works...)
				break;
			case 1:
				// Hours:Minutes:Seconds.
				ParentWindow->SetPulseRate( 1000000 );	// 1 sec.
				Pulse();
				break;
			case 2:
				// Month/Date/Year.
				ParentWindow->SetPulseRate( 0 );
				Pulse();
				break;
			case 4:
				// Free RAM. (case 3 is a separator)
				ParentWindow->SetPulseRate( 5000000 );	// 5 secs.
				Pulse();
				break;
			case 6:
				// Quit. (case 5 is a separator)
					be_app->PostMessage(B_QUIT_REQUESTED);
				break;
//			default:
//				sprintf( TimeStr, "%lu - %i:%02i", GetFreeBytes(), hour, min );
//				break;
		}
	}
}

/* Probably DON'T want to use MouseDown() handle menu events.
   MessageReceived() is where it really should be done, but it works...?
*/
void
ClockView::Pulse( void )
{
	if ( Window()->Lock() ) {
		switch ( MenuIdx ){
			case 0:
				// Hours:Minutes.
				GetTime();
				sprintf( TimeStr, "%i:%02i %s", local->tm_hour, local->tm_min, apm );
				break;
			case 1:
				// Hours:Minutes:Seconds.
				GetTime();
				sprintf( TimeStr, "%i:%02i:%02i %s", local->tm_hour, local->tm_min, local->tm_sec, apm );
				break;
			case 2:
				// Month/Date/Year.
				GetTime();
				sprintf( TimeStr, "%i/%02i/%02i", (local->tm_mon+1), local->tm_mday, local->tm_year );
				break;
			case 4:
				// Free RAM. (case 3 is the separator)
				sprintf( TimeStr, "%lu Bytes", GetFreeBytes() );
				break;
//			default:
//				// Free RAM, 12 hour time, w/o secs
//				GetTime();
//				sprintf( TimeStr, "%lu - %i:%02i", GetFreeBytes(), hour, min );
//				break;
		}

		SetText( TimeStr );

		Invalidate();
		Sync();
		Window()->Unlock();
	}
}

void
ClockView::GetTime( void ){
		time( &cur_t);
		local = localtime( &cur_t );

		// Convert to 12 hour time.
		if( local->tm_hour > 12 ){
			local->tm_hour = local->tm_hour - 12;
			apm = "PM";
		}
		else {
			apm = "AM";
			if( local->tm_hour==0 ){
				local->tm_hour = 12;
			}
		}
}

long
ClockView::GetFreeBytes( void ){
	// Free Bytes = (MaxPages - UsedPages) * BytesPerPage.
	get_system_info( &SysInfo );
	FreeBytes = (SysInfo.max_pages - SysInfo.used_pages) * B_PAGE_SIZE;
	return FreeBytes;
}

/*** EOF - ClockView.cpp ***/