
#ifndef VIEDMAINWINDOW_HEADER
#define VIEDMAINWINDOW_HEADER

#include "PrefsPanel/ViEdView_L0S0.h"
#include <InterfaceKit.h>


class ViEdMainWindow : public BWindow
{
public:
	ViEdMainWindow(BRect, const char *, window_look, window_feel, uint32, uint32);
	~ViEdMainWindow();
	void MessageReceived(BMessage *);
	bool QuitRequested();
private:
	ViEdView_L0S0 *	view_L0S0;
	
public: // Static
	static bool RequestWindow() { bool Ok= (B_NO_ERROR==acquire_sem_etc(WindowSemaphore, 1, B_TIMEOUT, 50)); if (!Ok) ShowWindow(); return (Ok);  }
	static void FreeWindow()    { release_sem(WindowSemaphore); the_win= NULL; }
	static bool CreateWinSemaphore() { return ((WindowSemaphore = create_sem(1, "PluginPanelMainWindow")) != B_NO_ERROR); }
	static void DeleteWinSemaphore() { delete_sem(WindowSemaphore); }
	static void SendToWindow(uint32 Command) { BMessenger Msgr(the_win, NULL); if (Msgr.IsValid()) Msgr.SendMessage (Command); }
	static void ShowWindow() { BMessenger Msgr(the_win, NULL); if (Msgr.IsValid()) Msgr.SendMessage ('ShoW'); }
	static void QuitWindow(long dSeconds=99999) { BMessenger Msgr(the_win, NULL); if (Msgr.IsValid()) Msgr.SendMessage (B_QUIT_REQUESTED); WaitForNoWindow(dSeconds); }
	static void WaitForNoWindow(long dSeconds=99999) { bool UnwantedWait= (the_win!=NULL); while(dSeconds-->0 && the_win) snooze(100*1000); if (UnwantedWait) snooze(400*1000); }
	static void CreateWindow();
private: // Static
	static sem_id WindowSemaphore;
	static BWindow *the_win;
};

#endif