#include "PluginView.h"
#include "PrefsPanel/ViEdMainWindow.h"

#define M_MENU_PREFS		100

#define ef else if

PluginView::PluginView(BRect frame, VisualizationPlugin *plug, uint32 resizingMode, uint32 flags) :BView(frame, "", resizingMode, flags)
{
	plugin= plug;
}

PluginView::~PluginView()
{
}

void PluginView::AttachedToWindow()
{
	FixPopupMenu();
	MakeFocus(true);
}

void PluginView::MessageReceived(BMessage *message)
{
	switch ( message->what )
	{
		case M_MENU_PREFS:
			if (ViEdMainWindow::RequestWindow()) {
				ViEdMainWindow::CreateWindow();
			}
			break;
   		default:
			BView::MessageReceived(message);
			break;
	}
}

void PluginView::MouseDown(BPoint point) 
{
	uint32 buttons;

	GetMouse(&point, &buttons, true);
	if (buttons == 1)	{
		if (!Window()->IsActive()) {
			Window()->Activate(true);
		}
	}
	ef (buttons == 2)	{
		ConvertToScreen(&point);
		popupMenu->SetTargetForItems(this);
		popupMenu->Go(point, true, false, true);
	}
}

struct CLMenuItem {
	char *name;
	int MCode;
	uint32 Modifier;
	char Shortcut;
	int MarkNr;
};
#define MCODE_SUBMENU_START   -1
#define MCODE_SUBMENU_STOP    -2
#define MCODE_SEPARATOR       -3

void PluginView::FixPopupMenu()
{
	static const struct CLMenuItem items[]= 
	{
		{ "Preferences",      M_MENU_PREFS,     B_COMMAND_KEY,'p', 0 }
	};
	BMenuItem *mi;
	BMenu *m[5];
	int Max, Level;
	
	popupMenu = new BPopUpMenu("Main menu", false, false, B_ITEMS_IN_COLUMN);
	Max = sizeof(items) / sizeof(struct CLMenuItem);
	m[Level=0]= popupMenu;
	for (int L= 0; L<Max; ++L)	{
		if (items[L].MCode==MCODE_SUBMENU_START) {
			m[++Level]= new BMenu(items[L].name);
			m[Level-1]->AddItem(new BMenuItem(m[Level]));
		}
		ef (items[L].MCode==MCODE_SUBMENU_STOP) {
			m[Level--]->SetTargetForItems(this);
		}
		ef (items[L].MCode==MCODE_SEPARATOR) {
			mi= new BSeparatorItem();
			m[Level]->AddItem(mi);
		}
		else {
			mi = new BMenuItem(items[L].name ,new BMessage(items[L].MCode), items[L].Shortcut, items[L].Modifier);
//			if (items[L].MarkNr!=NOT_MARKED)
//				Prefs.SetMenuItem (items[L].MarkNr, mi);
			m[Level]->AddItem(mi);
			if (items[L].Shortcut)
				Window()->AddShortcut(items[L].Shortcut, items[L].Modifier, new BMessage(items[L].MCode), this);
		}
	}
	popupMenu->SetTargetForItems(this);
}

void PluginView::KeyDown(const char *bytes, int32 numBytes)
{
	BMessage *msg= Window()->CurrentMessage();
	plugin->SendToCLAmp(msg);
}

void PluginView::WindowActivated(bool Active)
{
	if (Active) MakeFocus(true);
}
