#ifndef CLAMP_FRONTEND_MSGS_H
#define CLAMP_FRONTEND_MSGS_H

#define CL_AMP_FRONTEND_MSGR		'CLAm' // (C)(L)-(A)mp (m)essenger
 #define CL_AMP_MESSENGER_NAME	"Msgr"	// Contains a BMessenger

#define CL_AMP_FRONTEND_INFO		'CLAi' // (C)(L)-(A)mp (i)nfo
 #define CL_AMP_INFO_FLAGS		"Flags"	// To define which extra info the frontend need
 										// Sent as a long
  #define IFLAG_SPECTRUM	0x0001		// Extra info from the spectrum analyzer is required
  #define IFLAG_VUMETER		0x0002		// Extra info from the VU Meter is required
 #define CL_AMP_INFO_NAME		"Info"	// Contains a FrontEndInfo structure,
 										// sent as a String!
 #define CL_AMP_AINFO_NAME		"AInfo"	// Contains a FrontEndAudioInfo structure,
 										// sent as a String!

#define M_PLAY_THIS			800
 #define CL_AMP_THIS_NAME		"FileName"	// Contains a String!
 #define CL_AMP_FADING			"Fade"		// Contains a bool!
#define M_BUTTON_PREV		801
#define M_BUTTON_PLAY		802
#define M_BUTTON_PAUSE		803
#define M_BUTTON_STOP		804
#define M_BUTTON_NEXT		805
#define M_BUTTON_EJECT		806
#define M_BUTTON_CLOSE		807
#define M_SET_VOLUME		808
 #define CL_AMP_SLIDER			"Slider"		// Contains a short! [0-1000]
 #define CL_AMP_VOLUME			CL_AMP_SLIDER	// Contains a short! [0-1000]
#define M_SET_SPEED			809
 #define CL_AMP_SPEED			CL_AMP_SLIDER	// Contains a short! [0-1000]
#define M_SET_PANNING		810
 #define CL_AMP_PANNING			CL_AMP_SLIDER	// Contains a short! [0-1000]
#define M_SKIP_BACKWARDS	811
#define M_SKIP_FORWARDS		812

#define CL_AMP_ADD_FILES		"AddFiles"

#define MAX_FRONTEND_SONG_NAME	80

// The following is for the Flags member in FrontEndInfo
#define FRONTEND_NO_TOTTIME  0x0001  // CL-Amp can't estimate a total time for the current file

struct FrontEndInfo {
	unsigned long Flags;
	long CurrTime, TotTime;
	char SongTitle[MAX_FRONTEND_SONG_NAME];
	bool Playing, Paused;
	long Position, Frequency, BitRate;
	short Volume, Speed, Panning; // Panning is not used in CL-Amp (at least, not yet!)
	bool Stereo, Fading;
};

#define MAX_SPECTRUMDATA	76

struct FrontEndAudioInfo {
	unsigned short VUMeterData[2];
	unsigned char  SpectrumData[2][MAX_SPECTRUMDATA];
};

#endif
