/**********************************************/
/*               FrontEnd.cpp                 */
/*                                            */
/*          This file is a part of            */
/*      CL-Amp's FrontEnd Developer Kit       */
/*                                            */
/* Made by Claes Löfqvist (slarti@tripnet.se) */
/*                                            */
/**********************************************/

#include "FrontEnd.h"

CLAFE_Receiver::CLAFE_Receiver() : BLooper("CL-Amp FrontEnd Mailbox", B_DISPLAY_PRIORITY)
{
	if ((DataSemaphore = create_sem(1, "FrontEnd Mailbox")) < B_NO_ERROR)
		InitOkay= false;
	else
		InitOkay= true;
	NewInfo= false;
	MessengerOk= false;
}

CLAFE_Receiver::~CLAFE_Receiver()
{
	delete_sem(DataSemaphore);
}

void CLAFE_Receiver::SendMsg(BMessage *msg)
{
	BMessage Msg(CL_AMP_FRONTEND_MSGR);

	if (MessengerOk) {
		if (!CL_Amp.IsValid()) {
			if (AutoStart && !be_roster->IsRunning(CLAmp_Signature))
				be_roster->Launch(CLAmp_Signature);
			BMessenger Msgr(CLAmp_Signature);
			BMessenger ReplyTo(this);
			Msgr.SendMessage(&Msg, ReplyTo);
		}
		BMessenger ReplyTo(this);
		if (ReplyTo.IsValid())
			CL_Amp.SendMessage(msg, ReplyTo);
	}
}

void CLAFE_Receiver::MessageReceived(BMessage *msg)
{
 	struct FrontEndInfo *info;
 	ssize_t Len;

	switch(msg->what) {
		case CL_AMP_FRONTEND_MSGR:
			if (Lock()) {
				if (B_OK==msg->FindMessenger(CL_AMP_MESSENGER_NAME, &CL_Amp))
					MessengerOk= true;
				Unlock();
			}
			break;
		case CL_AMP_FRONTEND_INFO:
			if (B_OK==msg->FindData(CL_AMP_INFO_NAME, B_STRING_TYPE, (const void **)&info, &Len)) {
				if (Len>=(ssize_t)sizeof(CLAmp_Info) && Lock()) {
					memcpy (&CLAmp_Info, info, sizeof(CLAmp_Info));
					NewInfo= true;
					Unlock();
				}
			}
			break;
		default:
			BLooper::MessageReceived(msg);
	}
}

void CLAFE_Receiver::StartCLAmp()
{
	BMessage Msg(CL_AMP_FRONTEND_MSGR);

	if (AutoStart && !be_roster->IsRunning(CLAmp_Signature))
		be_roster->Launch(CLAmp_Signature);
	BMessenger Msgr(CLAmp_Signature);
	BMessenger ReplyTo(this);
	if (Msgr.IsValid()) {
		Msgr.SendMessage(&Msg, ReplyTo);
	}
}

CLAmp_FrontEnd::CLAmp_FrontEnd(bool AutoInfo, bigtime_t SnoozeValue)
{
	if ((DataSemaphore = create_sem(1, "FrontEnd_data")) < B_NO_ERROR)
		InitOkay= false;
	else
		InitOkay= true;
	ourMailbox= new CLAFE_Receiver();
	if (ourMailbox) {
		ourMailbox->Run();
		InitOkay|= ourMailbox->InitCheck();
	}
	else
		InitOkay= false;
	Interval= SnoozeValue;
	AutoUpdateInfo= AutoInfo;
}

CLAmp_FrontEnd::~CLAmp_FrontEnd()
{
	StopRunning();
	if (ourMailbox) {
		ourMailbox->LockLooper();
		ourMailbox->Quit();
	}
}

int32 CLAmp_FrontEnd::Main()
{
	thread_id Id= ourMailbox->Thread();

	ourMailbox->StartCLAmp();
	if (Id!=B_ERROR) set_thread_priority(Id, Priority);

	ThreadInit();
	while (!ChkAbort()) {
		if (AutoUpdateInfo)
			SendInfoRequest();
		snooze (Interval);
	}
	ThreadCleanUp();
	return (0);
}
