/*******************************************************/
/*                       Lists.h                       */
/*                                                     */
/*  Started at  940409               Last Rev  960320  */
/*                                                     */
/*                   © Claes Löfqvist                  */
/*******************************************************/
    

#ifndef CLAES_LISTS_HPP
   #define CLAES_LISTS_HPP 
   
   #ifndef CLAES_CLAES_HPP
    #include <Claes/Claes.hpp>
   #endif
 
   
template <class NEW_NODE>
class CLList {
public:
	CLList () { H.p= T.n= 0; H.n= &T; T.p= &H; H.SetInvalid(); T.SetInvalid();};
	NEW_NODE *Head () const {return (( H.n->Valid() ) ? H.n : 0);};
	NEW_NODE *Tail () const {return (( T.p->Valid() ) ? T.p : 0);};
	NEW_NODE *Nr (int Nr) const;
	int HowMany () const;
	Bool InList (const NEW_NODE *the_n) const { for (register NEW_NODE *n=Head(); n; n=n->Next()) if (n==the_n) return (TRUE); return (FALSE); };
	void AddHead (NEW_NODE *n);
	void AddTail (NEW_NODE *n);
	NEW_NODE *RemHead (void);
	NEW_NODE *RemTail (void);
	void FreeAbundance(int Max) { NEW_NODE *n,*last; if (Max==0) FreeAll(); else { if ((last=Nr(Max-1))!=NULL) while((n=last->Next())!=NULL) delete (n); } }
	void FreeAll () { while (H.n->Valid()) delete (H.n); };
	virtual ~CLList () { FreeAll(); };
private:
		NEW_NODE H, T;
};

template <class NEW_NODE>
class CLNode {
friend class CLList<NEW_NODE>;
public:
	CLNode() { Status= v_Alone; };
	NEW_NODE *Next () const {return (( n->Valid() ) ? n : 0);};
	NEW_NODE *Prev () const {return (( p->Valid() ) ? p : 0);};
	void AddBefore (NEW_NODE *NewN);
	void AddAfter  (NEW_NODE *NewN);
	NEW_NODE *First () const { NEW_NODE *nn=NULL; if (Status==v_InList) for (nn=(NEW_NODE *)this; nn->p->Status==v_InList; ) nn=nn->p; return(nn); }
	NEW_NODE *Last  () const { NEW_NODE *nn=NULL; if (Status==v_InList) for (nn=(NEW_NODE *)this; nn->n->Status==v_InList; ) nn=nn->n; return(nn); }
	void Remove (void);
	virtual ~CLNode (void) {if (InList()) Remove();};
protected:
	void SetInvalid() { Status=v_Invalid;};
	Bool Valid() {return(Status!=v_Invalid);};
	Bool InList() {return(Status==v_InList);};
	Bool Alone() {return(Status==v_Alone);};
	NEW_NODE *n;	// Pointer to next
	NEW_NODE *p;	// Pointer to previous
	enum { v_Invalid, v_Alone, v_InList } Status;
};




/*******************************************************/
/*  Gjord  880302                                      */

template <class NEW_NODE>
void CLNode<NEW_NODE>::AddAfter (NEW_NODE *NewN)
{
	ASSERT ( !Alone() || NewN->Alone());
   this->n->p= NewN;
   NewN->n= this->n;
   NewN->p= (NEW_NODE*)this;
   this->n= NewN;
   NewN->Status= v_InList;
}                
/*******************************************************/
/*  Gjord  880302                                      */
 
template <class NEW_NODE>
void CLNode<NEW_NODE>::AddBefore (NEW_NODE *NewN)
{
	ASSERT ( !Alone() || NewN->Alone());
   this->p->n= NewN;
   NewN->p= this->p;
   NewN->n= (NEW_NODE*)this;
   this->p= NewN;
   NewN->Status= v_InList;
}   
/*******************************************************/
/*  Gjord  880302                                      */
 
template <class NEW_NODE>
void CLList<NEW_NODE>::AddHead (NEW_NODE *NewN)
{
	H.AddAfter (NewN);
}
/*******************************************************/
/*  Gjord  880302                                      */
 
template <class NEW_NODE>
void CLList<NEW_NODE>::AddTail (NEW_NODE *NewN)
{
	T.AddBefore (NewN);
}
/*******************************************************/
/*  Gjord  880302                                      */
 
template <class NEW_NODE>
NEW_NODE *CLList<NEW_NODE>::Nr (int Nr) const
{
	NEW_NODE *n;

	for (n=Head(); n && (Nr-->0); n=n->Next());
	return (n);
}
/*******************************************************/
/*  Gjord  880302                                      */
 
template <class NEW_NODE>
int CLList<NEW_NODE>::HowMany () const
{
	NEW_NODE *n;
	int Nr=0;

	for (n=Head(); n; n=n->Next()) ++Nr;
	return (Nr);
}
/*******************************************************/
/*  Gjord  880302                                      */
 
template <class NEW_NODE>
void CLNode<NEW_NODE>::Remove (void)
{
   p->n= n;
   n->p= p;
   Status= v_Alone;
}
/*******************************************************/
/*  Gjord  880302                                      */
 
template <class NEW_NODE>
NEW_NODE *CLList<NEW_NODE>::RemHead (void)
{
	register NEW_NODE *Node= Head();

   if (Node)
		Node->Remove ();
	return (Node);
}
/*******************************************************/
/*  Gjord  880302                                      */
 
template <class NEW_NODE>
NEW_NODE *CLList<NEW_NODE>::RemTail (void)
{
	register NEW_NODE *Node= Tail();

   if (Node)
		Node->Remove ();
	return (Node);
}
                            
#endif
