//scrolling title window

#include "windowGuts.h"
#include <memory>
#include <string>
#include "DlayoutMatrix.h"
#include "XlayoutMatrixItem.h"
#include "layoutMatrixItem.h"
#include "layoutMatrix.h"
#include "myButton.h"
#include "myCheckBox.h"
#include "textItem.h"
#include "myStringDrawer.h"
#include "myPopUpMenu.h"
#include "myPictureButton.h"
#include "myColorControl.h"
#include "myStatusBar.h"
#include "myRadioView.h"
#include "myTextView.h"
#include "titleWindow.h"
#include "XtitleWindow.h"
#include "Dreopen.h"
#include "DmenuMsg.h"
#include "Xwarning.h"
#include "preferences.h"
#include "myPreferences.h"
#include "myroColour.h"
#include "myApp.h"
#include "bottomLine.h"
#include "Xverify.h"

//ctor
TitleWindow	::	TitleWindow(	BRect paramBound,
								const char * paramWindowTitle,
								const char * paramScrollViewName,
								const char * paramNamePrefFrame)
			: 
				WindowGuts(	paramBound, 
							paramWindowTitle, 
							paramScrollViewName,
							paramNamePrefFrame),
				savePanel(NULL), 
				saveMessenger(NULL), 
				loadPanel(NULL), 
				loadMessenger(NULL), 
				pSaveButton(NULL),
				pLoadButton(NULL),
				pNewButton(NULL),
				pRealButton(NULL)
{
	sem_id calc_sem;
	if ((calc_sem = create_sem(1, "calc_sem")) < B_NO_ERROR)
	{
		warning(FailCreateSemaphore);
		return;
	}
	acquire_sem(calc_sem);
	try 
	{
		LayoutMatrix *	pholdLayoutMatrix = new LayoutMatrix(BESTSIZE, 6, 1, this);//rows,columns
/////////////////////////////////////////////////////////////////////////////////////////////
		BFont * pBFont = new BFont();//note-- using system be_plain_font
		//NOT preferredFont(), just for something different
		float fontSize = pBFont->Size();
		fontSize *= 4;
		if (fontSize > 200)
		{
			fontSize = 200;
		}
		pBFont->SetSize(fontSize);
		pBFont->SetShear(122);
		MyStringDrawer * pMyStringDrawer = new MyStringDrawer(	"MyStringDrawer", 
																ProgramName, 
																B_FOLLOW_NONE, 
																B_WILL_DRAW,
																pBFont,
																pholdLayoutMatrix);
		auto_ptr<LayoutMatrixItem> apMyStringDrawerLayoutMatrixItem(new LayoutMatrixItem(	(void *)pMyStringDrawer, 
																							pholdLayoutMatrix->itemsList,
																							KIND_STRINGDRAWER));
////////////////////////////////////////////////////////////////////////////////////////////
		BFont * p1BFont = new BFont();//note-- using system be_plain_font
		//NOT preferredFont(), just for something different
		float font1Size = p1BFont->Size();
		font1Size *= 2.5;
		if (font1Size > 200)
		{
			font1Size = 200;
		}
		p1BFont->SetSize(font1Size);
		MyStringDrawer * p1MyStringDrawer = new MyStringDrawer(	"MyStringDrawer", 
																ProgramNameSubTitle, 
																B_FOLLOW_NONE, 
																B_WILL_DRAW,
																p1BFont,
																pholdLayoutMatrix);
		auto_ptr<LayoutMatrixItem> ap1MyStringDrawerLayoutMatrixItem(new LayoutMatrixItem(	(void *)p1MyStringDrawer, 
																							pholdLayoutMatrix->itemsList,
																							KIND_STRINGDRAWER));
//////////////////////////////////////////////////////////////////
		pNewButton = new MyButton(	"NewButton", 
									CreateNewLable, 
									BLNEW, 
									B_FOLLOW_NONE, 
									B_WILL_DRAW,
									pholdLayoutMatrix);
		auto_ptr<LayoutMatrixItem> apNewButtonLayoutMatrixItem(new LayoutMatrixItem(	(void *)pNewButton, 
																						pholdLayoutMatrix->itemsList,
																						KIND_MYBUTTON));

////////////////////////////////////////////
		pLoadButton = new MyButton(	"LoadButton", 
									LoadPreviousLable, 
									BLLOAD, 
									B_FOLLOW_NONE, 
									B_WILL_DRAW,
									pholdLayoutMatrix);
		auto_ptr<LayoutMatrixItem> apLoadButtonLayoutMatrixItem(new LayoutMatrixItem(	(void *)pLoadButton, 
																						pholdLayoutMatrix->itemsList,
																						KIND_MYBUTTON));
///////////////////////////////////////////////////////////////////////
		pSaveButton = new MyButton(	"SaveButton", 
									SaveLable, 
									BLSAVE, 
									B_FOLLOW_NONE, 
									B_WILL_DRAW,
									pholdLayoutMatrix,
									false);
		auto_ptr<LayoutMatrixItem> apSaveButtonLayoutMatrixItem(new LayoutMatrixItem(	/*(void *)*/pSaveButton, 
																						pholdLayoutMatrix->itemsList,
																						KIND_MYBUTTON));
//////////////////////////////////////////////////////////////////////
		pRealButton = new MyButton(	"RealButton", 
									RealLable, 
									REALMSG, 
									B_FOLLOW_NONE, 
									B_WILL_DRAW,
									pholdLayoutMatrix,
									false);
		auto_ptr<LayoutMatrixItem> apRealButtonLayoutMatrixItem(new LayoutMatrixItem(	(void *)pRealButton, 
																						pholdLayoutMatrix->itemsList,
																						KIND_MYBUTTON));
/////////////////////////////////////////////////////////////////////
		release_sem(calc_sem);
		pholdLayoutMatrix->Calc(MATRIXHORIZONTALOFFSET, MATRIXVERTICALOFFSET, calc_sem);
	}
	catch (...)
	{
		warning(CaughtTitleWindowCTOR);
		release_sem(calc_sem);
		throw;
	}
	try
	{
		BMenuItem *	menuItem;
		BMenu * APPMenu = new BMenu(AppMenuLable);
		menuItem = new BMenuItem(	AboutMenuLable, 
									new BMessage(ABOUT_TITLEWINDOW));
		APPMenu->AddItem(menuItem);
		menuItem = new BMenuItem(	PreferenceMenuLable, 
									new BMessage(PREFSMSG));
		APPMenu->AddItem(menuItem);
		menuItem = new BMenuItem(	CloseWindow, 
									new BMessage(B_QUIT_REQUESTED));
		APPMenu->AddItem(menuItem);
		menuItem = new BMenuItem(	QuitMenuLable, 
									new BMessage(QUIT_APP));
		APPMenu->AddItem(menuItem);
		pMenuBar->AddItem(APPMenu);
		BMenu *		fileMenu = new BMenu(FileMenuLable);
		menuItem = new BMenuItem(	CreateNewLable, 
									new BMessage(BLNEW));
		fileMenu->AddItem(menuItem);
		menuItem = new BMenuItem(	LoadPreviousLable, 
									new BMessage(BLLOAD));
		fileMenu->AddItem(menuItem);
		menuItem = new BMenuItem(	SaveLable, 
									new BMessage(BLSAVE));
		menuItem->SetEnabled(false);
		fileMenu->AddItem(menuItem);
		pMenuBar->AddItem(fileMenu);
	}
	catch (...)
	{
		warning(CaughtTitleWindowCTOR);
		throw;
	}
}//end


//dtor
TitleWindow	::	~TitleWindow() 
{
	if (pSaveButton)
	{
		pSaveButton->RemoveSelf();
		delete pSaveButton;
	}
	if (pLoadButton)
	{
		pLoadButton->RemoveSelf();
		delete pLoadButton;
	}
	if (pNewButton)
	{
		pNewButton->RemoveSelf();
		delete pNewButton;
	}
	if (pRealButton)
	{
		pRealButton->RemoveSelf();
		delete pRealButton;
	}
	delete savePanel;
	delete saveMessenger;
	delete loadPanel;
	delete loadMessenger;
	myApp->pTitleWindow = NULL;
	if (myPrefs->bPrefChangesMade)
	{
		myApp->PostMessage(REOPEN_TITLE);
	}
	else
	{
		if (!myApp->bEditingUniverse)
		{
			myApp->PostMessage(B_QUIT_REQUESTED);
		}
	}
}//end


void
TitleWindow	::	MessageReceived(	BMessage * pparamMessage) 
{
	BWindow * panelWindow;
	switch(pparamMessage->what) 
	{
		case ABOUT_TITLEWINDOW:	
		{
			string warn = AboutTitleWindowMsg1;
			warn += AboutTitleWindowMsg2;
			warning(warn.c_str());
		break;
		}
		case QUIT_APP:
			if (Verify(ReallyQuitApp))
			{
				myApp->PostMessage(B_QUIT_REQUESTED);
			}
		break;
		case BLNEW:
		{	
			try
			{
				myApp->PostMessage(new BMessage(BLNEW));
			}
			catch (...)
			{
				warning(FailMemory);
				throw;
			}
		break;
		}
		case LOADFROMPANEL:	
		{
			entry_ref ref;
			if (pparamMessage->FindRef("refs", &ref) >= B_OK) 
			{
				BFile file(&ref, B_READ_ONLY);
				status_t fileStatus;
				if ((fileStatus = file.InitCheck()) == B_NO_ERROR) 
				{
					warning("debug loading\n");
				}
				else 
				{
					warning(FailFileInitCheck);
				}
			}
			else 
			{
				warning(FailFileFindRef);
			}
		break;
		}
		case PREFSMSG:
		{
			myPrefs->OpenPreferencesPanel();
		break;
		}
		case BLLOAD:
		{
			if (!loadPanel) 
			{
				try 
				{
					loadMessenger = new BMessenger(this);
				}
				catch (...) 
				{
					warning(FailMemory);
					throw;
				}
				try 
				{
					loadPanel = new BFilePanel(	B_OPEN_PANEL, 
												loadMessenger, 
												NULL, 
												B_FILE_NODE, 
												false, 
												new BMessage(LOADFROMPANEL), 
												NULL, 
												false, 
												true);
					panelWindow = loadPanel->Window();
					panelWindow->SetTitle(OpenScenario);
					loadPanel->Show();
				}
				catch (...) 
				{
					warning(FailMemory);
					throw;
				}
			}
			else 
			{
				loadPanel->Show();
			}
		break;
		}
		case BLSAVE:
		{
			if (!savePanel) 
			{
				try 
				{
					saveMessenger = new BMessenger(this);
				}
				catch (...) 
				{
					warning(FailMemory);
					throw;
				}
				try 
				{
					savePanel = new BFilePanel(	B_SAVE_PANEL, 
												saveMessenger, 
												NULL, 
												B_FILE_NODE, 
												false, 
												new BMessage(SAVEFROMPANEL), 
												NULL, 
												false, 
												true);
					panelWindow = savePanel->Window();
					panelWindow->SetTitle(SaveScenario);
					savePanel->Show();
				}
				catch (...) 
				{
					warning(FailMemory);
					throw;
				}
			}
			else 
			{
				savePanel->Show();
			}
		break;
		}
		case SAVEFROMPANEL: 
		{
			entry_ref ref;
			const char * fileName;
			if (pparamMessage->FindRef("directory", &ref) >= B_OK) 
			{
				if (pparamMessage->FindString("name", &fileName) >= B_OK) 
				{
					BFile file;
					BDirectory dir = BDirectory(&ref);
					status_t result = file.SetTo(	&dir, 
													fileName, 
													B_WRITE_ONLY | B_CREATE_FILE | B_ERASE_FILE);
					if (result >= B_OK) 
					{
						warning("debug saving\n");
					}
					else 
					{
						warning(FailFileSetTo);
					}
				}
				else 
				{
					warning(FailFileName);
				}
			}
			else 
			{
				warning(FailFileDir);
			}
		break;
		}
		default:
			WindowGuts::MessageReceived(pparamMessage);
		break;
	}
}//end


bool
TitleWindow	::	QuitRequested(	void) 
{
	BRect frame = Frame();
	myApp->SetPreferredTitleWindowRect(frame);
	return(WindowGuts::QuitRequested());
}//end
