//universe.cpp

#include "constants.h"
#include "Xwarning.h"
#include "Xunique.h"
#include "dobj.h"
#include "def.h"
#include "error.h"
#include "mergeHow.h"
#include "mergeNode.h"
#include "mergeList.h"
#include "XdataNode.h"
#include "XdataList.h"
#include "dataNode.h"
#include "dataList.h"
#include "XdataNode.h"
#include "XdataList.h"
#include "universalConstants.h"
#include "XuIntPtrNode.h"
#include "uIntPtrNode.h"
#include "ptrList.h"
#include "mPtrNode.h"
#include "Xuniverse.h"
#include "universe.h"

Universe	::	Universe() 
{
	err = NO_ERR;
}//end


Universe	::	Universe(	Universe * fromItem, 
							const char * paramname) 
{
	err = NO_ERR;
	name = (char *)malloc(strlen(paramname) + 1);
	if (name) {
		DataNode * node = new DataNode(this);
		if (node) {
			strcpy(name, paramname);
			MinWidth = fromItem->MinWidth;
			MaxWidth = fromItem->MaxWidth;
			MinHeight = fromItem->MinHeight;
			MaxHeight = fromItem->MaxHeight;
			MinDepth = fromItem->MinDepth;
			MaxDepth = fromItem->MaxDepth;
			MinSofL = fromItem->MinSofL;
			MaxSofL = fromItem->MaxSofL;
			MinPropFuelUse = fromItem->MinPropFuelUse;
			MaxPropFuelUse = fromItem->MaxPropFuelUse;
			MinPropAccel = fromItem->MinPropAccel;
			MaxPropAccel = fromItem->MaxPropAccel;
			MinFTLFuelUse = fromItem->MinFTLFuelUse;
			MaxFTLFuelUse = fromItem->MaxFTLFuelUse;
			MinFTLAccel = fromItem->MinFTLAccel;
			MaxFTLAccel = fromItem->MaxFTLAccel;
			MinInstFuelUse = fromItem->MinInstFuelUse;
			MaxInstFuelUse = fromItem->MaxInstFuelUse;
			MinElectronMass = fromItem->MinElectronMass;
			MaxElectronMass = fromItem->MaxElectronMass;
			MinNeutronMass = fromItem->MinNeutronMass;
			MaxNeutronMass = fromItem->MaxNeutronMass;
			MinProtonMass = fromItem->MinProtonMass;
			MaxProtonMass = fromItem->MaxProtonMass;
			MinNumGalaxy = fromItem->MinNumGalaxy;
			MaxNumGalaxy = fromItem->MaxNumGalaxy;
			if (!Unique()) {
				err = CREATEDNOTADDED;
				return;
			}
			if (dataListGlobal[UNIVERSE_TYPE]->AddItem(node)) {
				universeCurrent = this;
				err = CREATED;
				return;
			}
			err = NO_ADDITEM;
		}
		err = NO_DATANODE;
	}
	err = NO_NAME;
}//end


Universe	::	Universe(	Universe * fromItem, 
				MergeList * list) 
{
	err = NO_ERR;
	name = (char *)malloc(strlen(fromItem->name) + 1);
	if (name) {
		MergeNode * node = new MergeNode(this, MERGEDNOT);
		if (node) {
			strcpy(name, fromItem->name);
			MinWidth = fromItem->MinWidth;
			MaxWidth = fromItem->MaxWidth;
			MinHeight = fromItem->MinHeight;
			MaxHeight = fromItem->MaxHeight;
			MinDepth = fromItem->MinDepth;
			MaxDepth = fromItem->MaxDepth;
			MinSofL = fromItem->MinSofL;
			MaxSofL = fromItem->MaxSofL;
			MinPropFuelUse = fromItem->MinPropFuelUse;
			MaxPropFuelUse = fromItem->MaxPropFuelUse;
			MinPropAccel = fromItem->MinPropAccel;
			MaxPropAccel = fromItem->MaxPropAccel;
			MinFTLFuelUse = fromItem->MinFTLFuelUse;
			MaxFTLFuelUse = fromItem->MaxFTLFuelUse;
			MinFTLAccel = fromItem->MinFTLAccel;
			MaxFTLAccel = fromItem->MaxFTLAccel;
			MinInstFuelUse = fromItem->MinInstFuelUse;
			MaxInstFuelUse = fromItem->MaxInstFuelUse;
			MinElectronMass = fromItem->MinElectronMass;
			MaxElectronMass = fromItem->MaxElectronMass;
			MinNeutronMass = fromItem->MinNeutronMass;
			MaxNeutronMass = fromItem->MaxNeutronMass;
			MinProtonMass = fromItem->MinProtonMass;
			MaxProtonMass = fromItem->MaxProtonMass;
			MinNumGalaxy = fromItem->MinNumGalaxy;
			MaxNumGalaxy = fromItem->MaxNumGalaxy;
			if (list->AddItem(node)) {
				node->placedAt = list->list->IndexOf(list->list->LastItem());
				err = CREATED;
				return;
			}
			err = NO_ADDITEM;
		}
		err = NO_DATANODE;
	}
	err = NO_NAME;
}//end


Universe	::	~Universe() 
{
	//left blank
}//end


bool 
Universe	::	Unique() 
{
	DataNode * node;
	for (	int32 i = 0;
			#pragma warn_possunwant off
			node = (DataNode * )dataListGlobal[UNIVERSE_TYPE]->list->ItemAt(i);
			#pragma warn_possunwant reset
			i++) 
	{
		if (!strcmp(name, node->MyName(UNIVERSE_TYPE))) 
		{
			warning(FailCreate[UNIVERSE_TYPE]);
			warning(FailCreateName);
			return false;
		}
		if (MinSofL == ((Universe * )node->data)->MinSofL) 
		{
			if (MinPropFuelUse == ((Universe * )node->data)->MinPropFuelUse) 
			{
				if (MinPropAccel == ((Universe * )node->data)->MinPropAccel)
				{
					if (MinFTLFuelUse == ((Universe * )node->data)->MinFTLFuelUse) 
					{
						if (MinFTLAccel == ((Universe * )node->data)->MinFTLAccel)
						{
							if (MinInstFuelUse == ((Universe * )node->data)->MinInstFuelUse) 
							{
								if (MinElectronMass == ((Universe * )node->data)->MinElectronMass) 
								{
									if (MinProtonMass == ((Universe * )node->data)->MinProtonMass) 
									{
										if (MinNeutronMass == ((Universe * )node->data)->MinNeutronMass) 
										{
											if (MaxSofL == ((Universe * )node->data)->MaxSofL) 
											{
												if (MaxPropFuelUse == ((Universe * )node->data)->MaxPropFuelUse) 
												{
													if (MaxPropAccel == ((Universe * )node->data)->MaxPropAccel)
													{
														if (MaxFTLFuelUse == ((Universe * )node->data)->MaxFTLFuelUse) 
														{
															if (MaxFTLAccel == ((Universe * )node->data)->MaxFTLAccel)
															{
																if (MaxInstFuelUse == ((Universe * )node->data)->MaxInstFuelUse) 
																{
																	if (MaxElectronMass == ((Universe * )node->data)->MaxElectronMass) 
																	{
																		if (MaxProtonMass == ((Universe * )node->data)->MaxProtonMass) 
																		{
																			if (MaxNeutronMass == ((Universe * )node->data)->MaxNeutronMass) 
																			{
																				warning(FailCreate[UNIVERSE_TYPE]);
																				warning(FailCreateData);
																				return false;
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}	
										}
									}
								}
							}
						}
					}
				}	
			}
		}
	}
	return true;
}//end


bool 
Universe	::	Save(	BFile * file) 
{
	if (!BuildConstantsSave(file)) 
	{
		return false;
	}
	if (UniversalConstants::Save(file)) 
	{
		return true;
	}
	if (SaveUniverse(file)) 
	{
		return true;
	}
	return false;
}//end


bool 
Universe	::	Load(	BFile * file) 
{
	if (!BuildConstantsLoad(file)) 
	{
		return false;
	}
	if (UniversalConstants::Load(file)) 
	{
		return true;
	}if (LoadUniverse(file)) 
	{
		return true;
	}
	return false;
}//end


bool 
Universe	::	Copy(	Universe * fromItem) 
{
	if (name && fromItem->name) 
	{
		if (strcmp(name, fromItem->name)) 
		{
			if (name) 
			{
				free(name);
			}
			name = (char *)malloc(strlen(fromItem->name) + 1);
			if (name) 
			{
				strcpy(name, fromItem->name);
			}
			else 
			{
				err = NO_NAME;
				warning(FailName);
				return false;
			}
		}
	}
//	debug must do object as well
	return true;
}//end