//universalConstants.cpp

#include "dobj.h"
#include "constants.h"
#include "Xwarning.h"
#include "error.h"
#include "mergeHow.h"
#include "mergeNode.h"
#include "mergeList.h"
#include "dataNode.h"
#include "XdataNode.h"
#include "XdataList.h"
#include "dataList.h"
#include "XuniversalConstants.h"
#include "universalConstants.h"

UniversalConstants	::	UniversalConstants() 
					:
						MinWidth(100),//if these values change, change as well
						MaxWidth(1000),//in editUniverseWindow at:
						MinHeight(80),//case EDITUNIVERSEDFLTCONSTANTS:
						MaxHeight(1000),
						MinDepth(10),
						MaxDepth(1000),
						MinSofL(1),
						MaxSofL(20),
						MinPropFuelUse(1),
						MaxPropFuelUse(10),
						MinPropAccel(1),
						MaxPropAccel(10),
						MinFTLFuelUse(10),
						MaxFTLFuelUse(100),
						MinFTLAccel(10),
						MaxFTLAccel(100),
						MinInstFuelUse(10),
						MaxInstFuelUse(200),
						MinElectronMass(1),
						MaxElectronMass(20),
						MinNeutronMass(1),
						MaxNeutronMass(5),
						MinProtonMass(20),
						MaxProtonMass(40),
						MinNumGalaxy(1),
						MaxNumGalaxy(5)
{
	//left blank
};//end


UniversalConstants	::	UniversalConstants(	UniversalConstants * fromItem, 
											const char * paramname) 
{
	err = NO_ERR;
	name = (char *)malloc(strlen(paramname) + 1);
	if (name) 
	{
		DataNode * node = new DataNode(this);
		if (node) 
		{
			strcpy(name, paramname);
			MinWidth = fromItem->MinWidth;
			MaxWidth = fromItem->MaxWidth;
			MinHeight = fromItem->MinHeight;
			MaxHeight = fromItem->MaxHeight;
			MinDepth = fromItem->MinDepth;
			MaxDepth = fromItem->MaxDepth;
			MinSofL = fromItem->MinSofL;
			MaxSofL = fromItem->MaxSofL;
			MinPropFuelUse = fromItem->MinPropFuelUse;
			MaxPropFuelUse = fromItem->MaxPropFuelUse;
			MinPropAccel = fromItem->MinPropAccel;
			MaxPropAccel = fromItem->MaxPropAccel;
			MinFTLFuelUse = fromItem->MinFTLFuelUse;
			MaxFTLFuelUse = fromItem->MaxFTLFuelUse;
			MinFTLAccel = fromItem->MinFTLAccel;
			MaxFTLAccel = fromItem->MaxFTLAccel;
			MinInstFuelUse = fromItem->MinInstFuelUse;
			MaxInstFuelUse = fromItem->MaxInstFuelUse;
			MinElectronMass = fromItem->MinElectronMass;
			MaxElectronMass = fromItem->MaxElectronMass;
			MinNeutronMass = fromItem->MinNeutronMass;
			MaxNeutronMass = fromItem->MaxNeutronMass;
			MinProtonMass = fromItem->MinProtonMass;
			MaxProtonMass = fromItem->MaxProtonMass;
			MinNumGalaxy = fromItem->MinNumGalaxy;
			MaxNumGalaxy = fromItem->MaxNumGalaxy;
			if (!Unique()) 
			{
				err = CREATEDNOTADDED;
				return;
			}
			if (dataListGlobal[UNIVERSALCONSTANTS_TYPE]->AddItem(node)) 
			{
				universalConstantsCurrent = this;
				err = CREATED;
				return;
			}
			err = NO_ADDITEM;
			return;
		}
		err = NO_DATANODE;
		return;
	}
	err = NO_NAME;
}//end


bool 
UniversalConstants	::	Unique() 
{
	DataNode * node;
	for (	int32 i = 0;
			#pragma warn_possunwant off
			node = (DataNode * )dataListGlobal[UNIVERSALCONSTANTS_TYPE]->list->ItemAt(i);
			#pragma warn_possunwant reset
			i++) 
	{
		if (!strcmp(name, node->MyName(UNIVERSALCONSTANTS_TYPE))) 
		{
			warning(FailCreate[UNIVERSALCONSTANTS_TYPE]);
			warning(FailCreateName);
			return false;
		}
		if (MinSofL == ((UniversalConstants * )node->data)->MinSofL) 
		{
			if (MinPropFuelUse == ((UniversalConstants * )node->data)->MinPropFuelUse) 
			{
				if (MinPropAccel == ((UniversalConstants * )node->data)->MinPropAccel)
				{
					if (MinFTLFuelUse == ((UniversalConstants * )node->data)->MinFTLFuelUse) 
					{
						if (MinFTLAccel == ((UniversalConstants * )node->data)->MinFTLAccel)
						{
							if (MinInstFuelUse == ((UniversalConstants * )node->data)->MinInstFuelUse) 
							{
								if (MinElectronMass == ((UniversalConstants * )node->data)->MinElectronMass) 
								{
									if (MinProtonMass == ((UniversalConstants * )node->data)->MinProtonMass) 
									{
										if (MinNeutronMass == ((UniversalConstants * )node->data)->MinNeutronMass) 
										{
											if (MaxSofL == ((UniversalConstants * )node->data)->MaxSofL) 
											{
												if (MaxPropFuelUse == ((UniversalConstants * )node->data)->MaxPropFuelUse) 
												{
													if (MaxPropAccel == ((UniversalConstants * )node->data)->MaxPropAccel)
													{
														if (MaxFTLFuelUse == ((UniversalConstants * )node->data)->MaxFTLFuelUse) 
														{
															if (MaxFTLAccel == ((UniversalConstants * )node->data)->MaxFTLAccel)
															{
																if (MaxInstFuelUse == ((UniversalConstants * )node->data)->MaxInstFuelUse) 
																{
																	if (MaxElectronMass == ((UniversalConstants * )node->data)->MaxElectronMass) 
																	{
																		if (MaxProtonMass == ((UniversalConstants * )node->data)->MaxProtonMass) 
																		{
																			if (MaxNeutronMass == ((UniversalConstants * )node->data)->MaxNeutronMass) 
																			{
																				warning(FailCreate[UNIVERSALCONSTANTS_TYPE]);
																				warning(FailCreateData);
																				return false;
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}	
										}
									}
								}
							}
						}
					}
				}	
			}
		}
	}
	return true;
}//end


bool 
UniversalConstants	::	Save(BFile * file) 
{
	if (!BuildConstantsSave(file)) 
	{
		return false;
	}
	BMessage msg;
	status_t success = msg.AddInt32("MinWidth", (int32)MinWidth);
	if (success == B_OK)
	{
		success = msg.AddInt32("MaxWidth", (int32)MaxWidth);
		if (success == B_OK)
		{
			success = msg.AddInt32("MinHeight", (int32)MinHeight);
			if (success == B_OK)
			{
				success = msg.AddInt32("MaxHeight", (int32)MaxHeight);
				if (success == B_OK)
				{
					success = msg.AddInt32("MinDepth", (int32)MinDepth);
if (success == B_OK)
{
	success = msg.AddInt32("MaxDepth", (int32)MaxDepth);
if (success == B_OK)
{
	success = msg.AddInt32("MinSofL", (int32)MinSofL);
if (success == B_OK)
{
	success = msg.AddInt32("MaxSofL", (int32)MaxSofL);
if (success == B_OK)
{
	success = msg.AddInt32("MinPropFuelUse", (int32)MinPropFuelUse);
if (success == B_OK)
{
	success = msg.AddInt32("MaxPropFuelUse", (int32)MaxPropFuelUse);
if (success == B_OK)
{
	success = msg.AddInt32("MinPropAccel", (int32)MinPropAccel);
if (success == B_OK)
{
	success = msg.AddInt32("MaxPropAccel", (int32)MaxPropAccel);
if (success == B_OK)
{
	success = msg.AddInt32("MinFTLFuelUse", (int32)MinFTLFuelUse);
if (success == B_OK)
{
	success = msg.AddInt32("MaxFTLFuelUse", (int32)MaxFTLFuelUse);
if (success == B_OK)
{
	success = msg.AddInt32("MinFTLAccel", (int32)MinFTLAccel);
if (success == B_OK)
{
	success = msg.AddInt32("MaxFTLAccel", (int32)MaxFTLAccel);
if (success == B_OK)
{
	success = msg.AddInt32("MinInstFuelUse", (int32)MinInstFuelUse);
if (success == B_OK)
{
	success = msg.AddInt32("MaxInstFuelUse", (int32)MaxInstFuelUse);
if (success == B_OK)
{
	success = msg.AddInt32("MinElectronMass", (int32)MinElectronMass);
if (success == B_OK)
{
	success = msg.AddInt32("MaxElectronMass", (int32)MaxElectronMass);
if (success == B_OK)
{
	success = msg.AddInt32("MinNeutronMass", (int32)MinNeutronMass);
if (success == B_OK)
{
	success = msg.AddInt32("MaxNeutronMass", (int32)MaxNeutronMass);
if (success == B_OK)
{
	success = msg.AddInt32("MinProtonMass", (int32)MinProtonMass);
if (success == B_OK)
{
	success = msg.AddInt32("MaxProtonMass", (int32)MaxProtonMass);
if (success == B_OK)
{
	success = msg.AddInt32("MinNumGalaxy", (int32)MinNumGalaxy);
if (success == B_OK)
{
	success = msg.AddInt32("MaxNumGalaxy", (int32)MaxNumGalaxy);
	if (success == B_OK)
	{
		msg.Flatten(file);
		return true;
	}
}}}}}}}}}}}}}}}}}}}}}}}}}
	warning(BMsgAddXFailUniversalConstantsSave);
	return false;
};//end


bool 
UniversalConstants	::	Load(BFile * file) 
{
	if (!BuildConstantsLoad(file)) 
	{
		return false;
	}
	BMessage msg;
	status_t success = msg.Unflatten(file);
	if (success == B_OK)
	{
		success = msg.FindInt32("MinWidth", (int32 *)&MinWidth);
		if (success == B_OK)
		{
success = msg.FindInt32("MaxWidth", (int32 *)&MaxWidth);
if (success == B_OK)
{
success = msg.FindInt32("MinHeight", (int32 *)&MinHeight);
if (success == B_OK)
{
success = msg.FindInt32("MaxHeight", (int32 *)&MaxHeight);
if (success == B_OK)
{
success = msg.FindInt32("MinDepth", (int32 *)&MinDepth);
if (success == B_OK)
{
success = msg.FindInt32("MaxDepth", (int32 *)&MaxDepth);
if (success == B_OK)
{
success = msg.FindInt32("MinSofL", (int32 *)&MinSofL);
if (success == B_OK)
{
success = msg.FindInt32("MaxSofL", (int32 *)&MaxSofL);
if (success == B_OK)
{
success = msg.FindInt32("MinPropFuelUse", (int32 *)&MinPropFuelUse);
if (success == B_OK)
{
success = msg.FindInt32("MaxPropFuelUse", (int32 *)&MaxPropFuelUse);
if (success == B_OK)
{
success = msg.FindInt32("MinPropAccel", (int32 *)&MinPropAccel);
if (success == B_OK)
{
success = msg.FindInt32("MaxPropAccel", (int32 *)&MaxPropAccel);
if (success == B_OK)
{
success = msg.FindInt32("MinFTLFuelUse", (int32 *)&MinFTLFuelUse);
if (success == B_OK)
{
success = msg.FindInt32("MaxFTLFuelUse", (int32 *)&MaxFTLFuelUse);
if (success == B_OK)
{
success = msg.FindInt32("MinFTLAccel", (int32 *)&MinFTLAccel);
if (success == B_OK)
{
success = msg.FindInt32("MaxFTLAccel", (int32 *)&MaxFTLAccel);
if (success == B_OK)
{
success = msg.FindInt32("MinInstFuelUse", (int32 *)&MinInstFuelUse);
if (success == B_OK)
{
success = msg.FindInt32("MaxInstFuelUse", (int32 *)&MaxInstFuelUse);
if (success == B_OK)
{
success = msg.FindInt32("MinElectronMass", (int32 *)&MinElectronMass);
if (success == B_OK)
{
success = msg.FindInt32("MaxElectronMass", (int32 *)&MaxElectronMass);
if (success == B_OK)
{
success = msg.FindInt32("MinNeutronMass", (int32 *)&MinNeutronMass);
if (success == B_OK)
{
success = msg.FindInt32("MaxNeutronMass", (int32 *)&MaxNeutronMass);
if (success == B_OK)
{
success = msg.FindInt32("MinProtonMass", (int32 *)&MinProtonMass);
if (success == B_OK)
{
success = msg.FindInt32("MaxProtonMass", (int32 *)&MaxProtonMass);
if (success == B_OK)
{
success = msg.FindInt32("MinNumGalaxy", (int32 *)&MinNumGalaxy);
if (success == B_OK)
{
success = msg.FindInt32("MaxNumGalaxy", (int32 *)&MaxNumGalaxy);
if (success == B_OK)
{
	return true;
}}}}}}}}}}}}}}}}}}}}}}}}}}
		warning(BMsgFindXFailUniversalConstantsLoad);
	}
	warning(BMsgFailUnflatten);
	return false;
};//end

bool
UniversalConstants	::	Copy(	UniversalConstants * fromItem)
{
	if (name && fromItem->name) {
		if (strcmp(name, fromItem->name)) {
			if (name) 
			{
				free(name);
			}
			name = (char *)malloc(strlen(fromItem->name) + 1);
			if (name) 
			{
				strcpy(name, fromItem->name);
			}
			else 
			{
				err = NO_NAME;
				warning(FailName);
				return false;
			}
		}
	}
	//debug must do object as well
	MinWidth = fromItem->MinWidth;
	MinHeight = fromItem->MinHeight;
	MinDepth = fromItem->MinDepth;
	MinSofL = fromItem->MinSofL;
	MinPropFuelUse = fromItem->MinPropFuelUse;
	MinFTLFuelUse = fromItem->MinFTLFuelUse;
	MinInstFuelUse = fromItem->MinInstFuelUse;
	MinElectronMass = fromItem->MinElectronMass;
	MinNeutronMass = fromItem->MinNeutronMass;
	MinProtonMass = fromItem->MinProtonMass;
	MinPropAccel = fromItem->MinPropAccel;
	MinFTLAccel = fromItem->MinFTLAccel;
	MinNumGalaxy = fromItem->MinNumGalaxy;
	MaxWidth = fromItem->MaxWidth;
	MaxHeight = fromItem->MaxHeight;
	MaxDepth = fromItem->MaxDepth;
	MaxSofL = fromItem->MaxSofL;
	MaxPropFuelUse = fromItem->MaxPropFuelUse;
	MaxFTLFuelUse = fromItem->MaxFTLFuelUse;
	MaxInstFuelUse = fromItem->MaxInstFuelUse;
	MaxElectronMass = fromItem->MaxElectronMass;
	MaxNeutronMass = fromItem->MaxNeutronMass;
	MaxProtonMass = fromItem->MaxProtonMass;
	MaxPropAccel = fromItem->MaxPropAccel;
	MaxFTLAccel = fromItem->MaxFTLAccel;
	MaxNumGalaxy = fromItem->MaxNumGalaxy;
	return true;
}//end


UniversalConstants	::	UniversalConstants(	UniversalConstants * fromItem, 
											MergeList * list) 
{
	err = NO_ERR;
	name = (char *)malloc(strlen(fromItem->name) + 1);
	if (name) {
		MergeNode * node = new MergeNode(this, MERGEDNOT);
		if (node) {
			strcpy(name, fromItem->name);
			MinWidth = fromItem->MinWidth;
			MaxWidth = fromItem->MaxWidth;
			MinHeight = fromItem->MinHeight;
			MaxHeight = fromItem->MaxHeight;
			MinDepth = fromItem->MinDepth;
			MaxDepth = fromItem->MaxDepth;
			MinSofL = fromItem->MinSofL;
			MaxSofL = fromItem->MaxSofL;
			MinPropFuelUse = fromItem->MinPropFuelUse;
			MaxPropFuelUse = fromItem->MaxPropFuelUse;
			MinPropAccel = fromItem->MinPropAccel;
			MaxPropAccel = fromItem->MaxPropAccel;
			MinFTLFuelUse = fromItem->MinFTLFuelUse;
			MaxFTLFuelUse = fromItem->MaxFTLFuelUse;
			MinFTLAccel = fromItem->MinFTLAccel;
			MaxFTLAccel = fromItem->MaxFTLAccel;
			MinInstFuelUse = fromItem->MinInstFuelUse;
			MaxInstFuelUse = fromItem->MaxInstFuelUse;
			MinElectronMass = fromItem->MinElectronMass;
			MaxElectronMass = fromItem->MaxElectronMass;
			MinNeutronMass = fromItem->MinNeutronMass;
			MaxNeutronMass = fromItem->MaxNeutronMass;
			MinProtonMass = fromItem->MinProtonMass;
			MaxProtonMass = fromItem->MaxProtonMass;
			MinNumGalaxy = fromItem->MinNumGalaxy;
			MaxNumGalaxy = fromItem->MaxNumGalaxy;
			if (list->AddItem(node)) {
				node->placedAt = list->list->IndexOf(list->list->LastItem());
				err = CREATED;
				return;
			}
			err = NO_ADDITEM;
		}
		err = NO_DATANODE;
	}
	err = NO_NAME;
}//end
