//shipWeapon.cpp

#include "constants.h"
#include "Xwarning.h"
#include "Xunique.h"
#include "dobj.h"
#include "def.h"
#include "error.h"
#include "mergeHow.h"
#include "mergeNode.h"
#include "mergeList.h"
#include "XdataNode.h"
#include "XdataList.h"
#include "dataNode.h"
#include "dataList.h"
#include "universalConstants.h"
#include "XuIntPtrNode.h"
#include "uIntPtrNode.h"
#include "ptrList.h"
#include "mPtrNode.h"
#include "Xdoable.h"
#include "doable.h"
#include "shipWeapon.h"

ShipWeapon	::	ShipWeapon() 
{
	err = NO_ERR;
	kind = 0;
	possibleOrders = 0;
	doable = new Doable();
	if (doable) 
	{
		buildable = new Doable();
		if (buildable) 
		{
			maintainable = new Doable();
			if (maintainable) 
			{
				defaultStrength = .5;
				return;
			}
			else err = NO_DOABLE;
		}
		else  err = NO_DOABLE;
	}
	else err = NO_DOABLE;
}//end


ShipWeapon	::	ShipWeapon(ShipWeapon * fromItem, const char * n) 
{
	err = NO_ERR;
	name = (char *)malloc(strlen(n) + 1);
	if (name) 
	{
		doable = new Doable();
		if (doable) 
		{
			buildable = new Doable();
			if (buildable) 
			{
				maintainable = new Doable();
				if (maintainable) 
				{
					DataNode * node = new DataNode(this);
					if (node) 
					{
						strcpy(name, n);
						doable->Copy(fromItem->doable);
						buildable->Copy(fromItem->buildable);
						maintainable->Copy(fromItem->maintainable);
						possibleOrders = fromItem->possibleOrders;
						mass = fromItem->mass;
						volume = fromItem->volume;
						vper = fromItem->vper;
						kind = fromItem->kind;
						defaultStrength = fromItem->defaultStrength;
										if (!Unique()) 
										{
							err = CREATEDNOTADDED;
							return;
						}
						if (dataListGlobal[SHIPWEAPON_TYPE]->AddItem(node)) 
						{
							shipWeaponCurrent = this;
							err = CREATED;
							return;
						}
						err = NO_ADDITEM;
					}
					err = NO_DATANODE;
				}
				err = NO_DOABLE;
			}
			err = NO_DOABLE;
		}
		err = NO_DOABLE;
	}
	err = NO_NAME;
}//end


ShipWeapon	::	ShipWeapon(ShipWeapon * fromItem, MergeList * list) 
{
	err = NO_ERR;
	name = (char *)malloc(strlen(fromItem->name) + 1);
	if (name) 
	{
		doable = new Doable();
		if (doable) 
		{
			buildable = new Doable();
			if (buildable) 
			{
				maintainable = new Doable();
				if (maintainable) 
				{
					MergeNode * node = new MergeNode(this, MERGEDNOT);
					if (node) 
					{
						strcpy(name, fromItem->name);
						doable->Copy(fromItem->doable);
						buildable->Copy(fromItem->buildable);
						maintainable->Copy(fromItem->maintainable);
						possibleOrders = fromItem->possibleOrders;
						mass = fromItem->mass;
						volume = fromItem->volume;
						vper = fromItem->vper;
						kind = fromItem->kind;
						defaultStrength = fromItem->defaultStrength;
						if (list->AddItem(node)) 
						{
							node->placedAt = list->list->IndexOf(list->list->LastItem());
							err = CREATED;
							return;
						}
						err = NO_ADDITEM;
					}
					err = NO_DATANODE;
				}
				err = NO_DOABLE;
			}
			err = NO_DOABLE;
		}
		err = NO_DOABLE;
	}
	err = NO_NAME;
}//end


ShipWeapon	::	~ShipWeapon() 
{
	if (maintainable) delete maintainable;
	if (buildable) delete buildable;
	if (doable) delete doable;
}//end


bool ShipWeapon	::	Unique() 
{
	err = NO_UNIQUE;
	DataNode * node;
	for (	int32 i = 0;
			#pragma warn_possunwant off
			node = (DataNode * )dataListGlobal[SHIPWEAPON_TYPE]->list->ItemAt(i);
			#pragma warn_possunwant reset
			i++) 
	{
		if (!strcmp(name, node->MyName(SHIPWEAPON_TYPE))) 
		{
			warning(FailCreate[SHIPWEAPON_TYPE]);
			warning(FailCreateName);
			return false;
		}
	}
	err = NO_ERR;
	return true;
}//end


bool ShipWeapon	::	Save(BFile * file) 
{
	if (!BuildConstantsSave(file)) return false;
	if (!SmallConstantsSave(file)) return false;
	if (!doable->DoableSave(file)) return false;
	if (!buildable->DoableSave(file)) return false;
	if (!maintainable->DoableSave(file)) return false;
	int32 len = sizeof(kind);
	if (!file->Write(&kind, len) == len) return false;
	len = sizeof(possibleOrders);
	if (file->Write(&possibleOrders, len) == len) return false;
	len = sizeof(defaultStrength);
	if (file->Write(&defaultStrength, len) == len) return true;
	return false;
}//end


bool ShipWeapon	::	Load(BFile * file) 
{
	if (!BuildConstantsLoad(file)) 
	{
		return false;
	}
	if (!SmallConstantsLoad(file)) 
	{
		return false;
	}
	if (!doable->DoableLoad(file)) 
	{
		return false;
	}
	if (!buildable->DoableLoad(file)) 
	{
		return false;
	}
	if (!maintainable->DoableLoad(file)) 
	{
		return false;
	}
	int32 len = sizeof(kind);
	if (file->Read(&kind, len) == len) 
	{
		return false;
	}
	len = sizeof(possibleOrders);
	if (file->Read(&possibleOrders, len) == len) 
	{
		return false;
	}
	len = sizeof(defaultStrength);
	if (file->Read(&defaultStrength, len) == len) 
	{
		return true;
	}
	return false;
}//end


bool 
ShipWeapon	::	Copy(	ShipWeapon * fromItem) 
{
	if (name && fromItem->name) 
	{
		if (strcmp(name, fromItem->name)) 
		{
			if (name) 
			{
				free(name);
			}
			name = (char *)malloc(strlen(fromItem->name) + 1);
			if (name) strcpy(name, fromItem->name);
			else 
			{
				err = NO_NAME;
				warning(FailName);
				return false;
			}
		}
	}
	if (!doable->Copy(fromItem->doable))
	{
		return false;
	}
	if (!maintainable->Copy(fromItem->maintainable))
	{
		return false;
	}
	if (!buildable->Copy(fromItem->buildable))
	{
		return false;
	}
	possibleOrders = fromItem->possibleOrders;
	mass = fromItem->mass;
	volume = fromItem->volume;
	vper = fromItem->vper;
	kind = fromItem->kind;
	defaultStrength = fromItem->defaultStrength;
	//debug must do object as well
	return true;
}//end
