//engine.cpp

#include "constants.h"
#include "Xwarning.h"
#include "Xunique.h"
#include "dobj.h"
#include "def.h"
#include "error.h"
#include "mergeHow.h"
#include "mergeNode.h"
#include "mergeList.h"
#include "XdataNode.h"
#include "XdataList.h"
#include "dataNode.h"
#include "dataList.h"
#include "universalConstants.h"
#include "XuIntPtrNode.h"
#include "uIntPtrNode.h"
#include "ptrList.h"
#include "mPtrNode.h"
#include "Xdoable.h"
#include "doable.h"
#include "engine.h"

Engine	::	Engine() 
{
	err = NO_ERR;
	kind = 0;
	possibleOrders = 0;
	doable = new Doable();
	if (doable) 
	{
		buildable = new Doable();
		if (buildable) 
		{
			maintainable = new Doable();
			if (maintainable) return;
			else err = NO_DOABLE;
		}
		else  err = NO_DOABLE;
	}
	else err = NO_DOABLE;
}//end


Engine	::	Engine(Engine * fromItem, const char * n) 
{
	err = NO_ERR;
	name = (char *)malloc(strlen(n) + 1);
	if (name) 
	{
		doable = new Doable();
		if (doable) 
		{
			buildable = new Doable();
			if (buildable) 
			{
				maintainable = new Doable();
				if (maintainable) 
				{
					DataNode * node = new DataNode(this);
					if (node) 
					{
						strcpy(name, n);
						doable->Copy(fromItem->doable);
						buildable->Copy(fromItem->buildable);
						maintainable->Copy(fromItem->maintainable);
						possibleOrders = fromItem->possibleOrders;
						mass = fromItem->mass;
						volume = fromItem->volume;
						vper = fromItem->vper;
						kind = fromItem->kind;
						if (!Unique()) 
						{
							err = CREATEDNOTADDED;
							return;
						}
						if (dataListGlobal[ENGINE_TYPE]->AddItem(node)) 
						{
							engineCurrent = this;
							err = CREATED;
							return;
						}
						err = NO_ADDITEM;
					}
					err = NO_DATANODE;
				}
				err = NO_DOABLE;
			}
			err = NO_DOABLE;
		}
		err = NO_DOABLE;
	}
	err = NO_NAME;
}//end


Engine	::	Engine(Engine * fromItem, MergeList * list) 
{
	err = NO_ERR;
	name = (char *)malloc(strlen(fromItem->name) + 1);
	if (name) 
	{
		doable = new Doable();
		if (doable) 
		{
			buildable = new Doable();
			if (buildable) 
			{
				maintainable = new Doable();
				if (maintainable) 
				{
					MergeNode * node = new MergeNode(this, MERGEDNOT);
					if (node) 
					{
						strcpy(name, fromItem->name);
						doable->Copy(fromItem->doable);
						buildable->Copy(fromItem->buildable);
						maintainable->Copy(fromItem->maintainable);
						possibleOrders = fromItem->possibleOrders;
						mass = fromItem->mass;
						volume = fromItem->volume;
						vper = fromItem->vper;
						kind = fromItem->kind;
						if (list->AddItem(node)) 
						{
							node->placedAt = list->list->IndexOf(list->list->LastItem());
							err = CREATED;
							return;
						}
						err = NO_ADDITEM;
					}
					err = NO_DATANODE;
				}
				err = NO_DOABLE;
			}
			err = NO_DOABLE;
		}
		err = NO_DOABLE;
	}
	err = NO_NAME;
}//end


Engine	::	~Engine() 
{
	if (maintainable) delete maintainable;
	if (buildable) delete buildable;
	if (doable) delete doable;
}//end


bool Engine	::	Unique() 
{
	err = NO_UNIQUE;
	DataNode * node;
	for (	int32 i = 0;
			#pragma warn_possunwant off
			node = (DataNode * )dataListGlobal[ENGINE_TYPE]->list->ItemAt(i);
			#pragma warn_possunwant reset
			i++) 
	{
		if (!strcmp(name, node->MyName(ENGINE_TYPE))) 
		{
			warning(FailCreate[ENGINE_TYPE]);
			return false;
			warning(FailCreateName);
		}
	}
	err = NO_ERR;
	return true;
}//end


bool Engine	::	Save(BFile * file) 
{
	if (!BuildConstantsSave(file)) return false;
	if (!SmallConstantsSave(file)) return false;
	if (!doable->DoableSave(file)) return false;
	if (!buildable->DoableSave(file)) return false;
	if (!maintainable->DoableSave(file)) return false;
	int32 len = sizeof(kind);
	if (!file->Write(&kind, len) == len) return false;
	len = sizeof(possibleOrders);
	if (file->Write(&possibleOrders, len) == len) return true;
	return false;
}//end


bool Engine	::	Load(BFile * file) 
{
	if (!BuildConstantsLoad(file)) 
	{
		return false;
	}
	if (!SmallConstantsLoad(file)) 
	{
		return false;
	}
	if (!doable->DoableLoad(file)) 
	{
		return false;
	}
	if (!buildable->DoableLoad(file)) 
	{
		return false;
	}
	if (!maintainable->DoableLoad(file)) 
	{
		return false;
	}
	int32 len = sizeof(kind);
	if (file->Read(&kind, len) == len) 
	{
		return false;
	}
	len = sizeof(possibleOrders);
	if (file->Read(&possibleOrders, len) == len) 
	{
		return true;
	}
	return false;
}//end


bool 
Engine	::	Copy(	Engine * fromItem) 
{
	if (name && fromItem->name) 
	{
		if (strcmp(name, fromItem->name)) 
		{
			if (name) 
			{
				free(name);
			}
			name = (char *)malloc(strlen(fromItem->name) + 1);
			if (name) strcpy(name, fromItem->name);
			else 
			{
				err = NO_NAME;
				warning(FailName);
				return false;
			}
		}
	}
	//debug must do object as well
	return true;
}//end
