//listViewWindow.cpp

#include "Dstar.h"
#include "DmenuMsg.h"
#include "constants.h"
#include "windowGuts.h"
#include "Xwarning.h"
#include "Xunique.h"
#include "dobj.h"
#include "def.h"
#include "error.h"
#include "mergeHow.h"
#include "mergeNode.h"
#include "mergeList.h"
#include "dataNode.h"
#include "dataList.h"
#include "universalConstants.h"
#include "XuIntPtrNode.h"
#include "uIntPtrNode.h"
#include "ptrList.h"
#include "mPtrNode.h"
#include "themAll.h"
#include "windowGuts.h"
#include "bottomLine.h"
#include "uInt32Gadget.h"
#include "stringGadget.h"
#include "myButton.h"
#include "designButtons.h"
#include "DlayoutMatrix.h"
#include "XlayoutMatrixItem.h"
#include "layoutMatrixItem.h"
#include "layoutMatrix.h"
#include "uInt32ReqWindow.h"
#include "XlistViewWindow.h"
#include "DlistViewWindow.h"
#include "listViewWindow.h"
#include "editUniversalConstantsWindow.h"
#include "editUniverseWindow.h"
//#include "editElementWindow.h"
//#include "editGalaxyWindow.h"
//#include "editCompoundWindow.h"
//#include "editMineWindow.h"
//#include "editFactoryWindow.h"
//#include "editEngineWindow.h"
//#include "editShipWindow.h"
//#include "editShipShieldWindow.h"
//#include "editShipWeaponWindow.h"
//#include "editPlanetWindow.h"
//#include "editPlanetShieldWindow.h"
//#include "editPlanetWeaponWindow.h"
//#include "editStarWindow.h"
//#include "editBlackholeWindow.h"
//#include "editWormholeWindow.h"
#include "editSpeciesWindow.h"
#include "preferences.h"
#include "myPreferences.h"
#include "myApp.h"
#include <string>
#include "myListView.h"
#include "Xverify.h"

ListViewWindow	::	ListViewWindow(	BRect paramBound,
									const char * paramWindowTitle,
									const char * paramScrollViewName,
									const char * paramNamePrefFrame, 
									BList * to, 
									DataList * of, 
									const char * fname, 
									WindowGuts * callingWindow,
									uint32 ui32paramSelectStyle) 
				: 	WindowGuts(	paramBound, 
								paramWindowTitle, 
								paramScrollViewName,
								paramNamePrefFrame),
					toList(to),
					blpBStringItemList(new BList()),
					ofDataList(of),
					fromName(fname),
					listView(NULL),
					caller(callingWindow),
					ui32SelectStyle(ui32paramSelectStyle),
					mpUInt32ReqWindow(NULL)
{
	SetFeel(B_MODAL_SUBSET_WINDOW_FEEL);
	SetFeel(B_FLOATING_SUBSET_WINDOW_FEEL);
	AddToSubset(caller);
	sem_id calc_sem;
	if ((calc_sem = create_sem(1, "calc_sem")) < B_NO_ERROR)
	{
		warning(FailCreateSemaphore);
		return;
	}
	acquire_sem(calc_sem);
	try 
	{
		LayoutMatrix *	pLayoutMatrix = new LayoutMatrix(BESTSIZE, 1, 1, this);//rows,columns
		listView = new MyListView(	lvwTitleStr[ofDataList->kind], 
									ofDataList,
									LISTVIEWSELECTONE,
									NULL,
									B_SINGLE_SELECTION_LIST,
									pLayoutMatrix);
		listView->SetTarget(this);
		auto_ptr<LayoutMatrixItem> apLayoutMatrixItem(new LayoutMatrixItem(	(void *)listView, 
																			pLayoutMatrix->itemsList,
																			KIND_MYLISTVIEW));
		
		release_sem(calc_sem);
		pLayoutMatrix->Calc(MATRIXHORIZONTALOFFSET, MATRIXVERTICALOFFSET, calc_sem);
	}
	catch (...)
	{
		warning(FailListViewWindow);
		throw;
	}
	try 
	{
		BMenuItem *	menuItem;
		BMenu * APPMenu = new BMenu(AppMenuLable);
		menuItem = new BMenuItem(	AboutMenuLable, 
									new BMessage(ABOUT_LISTVIEWWINDOW));
		APPMenu->AddItem(menuItem);
		menuItem = new BMenuItem(	PreferenceMenuLable, 
									new BMessage(PREFSMSG));
		APPMenu->AddItem(menuItem);
		menuItem = new BMenuItem(	CloseWindow, 
									new BMessage(B_QUIT_REQUESTED));
		APPMenu->AddItem(menuItem);
		menuItem = new BMenuItem(	QuitMenuLable, 
									new BMessage(QUIT_APP));
		APPMenu->AddItem(menuItem);
		pMenuBar->AddItem(APPMenu);
	}
	catch (...)
	{
		warning(FailListViewWindow);
		throw;
	}
}//end


ListViewWindow	::	~ListViewWindow() 
{
	if (blpBStringItemList)
	{
		uint32 numItems;
		#pragma warn_possunwant off
		if (!(numItems = blpBStringItemList->CountItems()))
		{
		#pragma warn_possunwant reset
			for (	uint32 i = 0;
					i < numItems;
					i++)
			{
				BStringItem * bsi = (BStringItem *)blpBStringItemList->ItemAt(i);
				blpBStringItemList->RemoveItem(bsi);
				delete bsi;
			}
		}
		delete blpBStringItemList;
	}
	if (listView) 
	{
		listView->RemoveSelf();
		delete listView;
	}
}//end


void 
ListViewWindow	::	MessageReceived(	BMessage *message) 
{
	err = NO_ERR;
	if (!listView) 
	{
		err = LISTVIEWNOFROM;
		warning(FailListViewNoFrom);
	}
	if (!ofDataList) 
	{
		err = LISTVIEWNOOF;
		warning(FailListViewNoOf);
	}
	if (err) 
	{
		return;
	}
	status_t msgStatus;
	BListView * onList;
	BListView * list;
	char alertMsg[512];
	alertMsg[0] = 0;
	switch (message->what) 
	{
		case ABOUT_LISTVIEWWINDOW:
			warning(AboutListViewWindow);
		break;
		case QUIT_APP:
			if (Verify(ReallyQuitApp))
			{
				myApp->PostMessage(B_QUIT_REQUESTED);
			}
		break;
		case PREFSMSG:
			myPrefs->OpenPreferencesPanel();
		break;
		case LISTVIEWSELECTZERO:
			msgStatus = message->FindPointer("source", &onList);
			if (msgStatus == B_NO_ERROR) 
			{
				int32 index;
				msgStatus = message->FindInt32("index", &index);
				if (msgStatus == B_NO_ERROR) 
				{
					const char * name = (char *)onList->ItemAt(index);
					const char * nodeName = NULL;
					DataNode * node;
					for (	int32 i = 0;
							#pragma warn_possunwant off
							node = (DataNode *)ofDataList->list->ItemAt(i);
							#pragma warn_possunwant reset
							i++) 
					{
						nodeName = node->MyName(ofDataList->kind);
						if (!strcmp(name, nodeName)) 
						{
							if (strcmp(name, fromName)) 
							{
								int32 listerType;
								msgStatus = message->FindInt32("listerType", &listerType);
								if (msgStatus == B_NO_ERROR) 
								{
									ssize_t size;
									void ** theLister;
									msgStatus = message->FindData("theData", B_POINTER_TYPE, &theLister, &size);
									if (msgStatus == B_NO_ERROR) 
									{
										const char * listerName;
										msgStatus = message->FindString("listerName", &listerName);
										if (msgStatus == B_NO_ERROR) 
										{
											char number[UINTSTRLEN];
											ssize_t ableSize;
											void ** vPtrList;
											msgStatus = message->FindData("theAblePtr", B_POINTER_TYPE, &vPtrList, &ableSize);
											if (msgStatus == B_NO_ERROR) 
											{
												PtrList * ptrList = (PtrList *)*vPtrList;
												strcpy(alertMsg, listerName);
												strcat(alertMsg, hasStr);
												SPRTF(number, "%u", ptrList->Has(nodeName));
												strcat(alertMsg, number);
												strcat(alertMsg, ofTheStr[ofDataList->kind]);
												strcat(alertMsg, nodeName);
											}
										}
										else 
										{
											err = NOMSGLISTERNAME;
										}
									}
									else 
									{
										err = NOMSGNODATA;
									}
								}
								else 
								{
									err = NOMSGLISTERTYPE;
								}
							}
						}
					}
				}
				else 
				{
					err = NOMSGINDEX;
				}
			}
			else 
			{
				err = NOMSGSOURCE;
			}
			if (err == NO_ERR) 
			{
				BAlert * alert = new BAlert(	NULL, 
												alertMsg, 
												fineStr, 
												NULL, 
												NULL, 
												B_WIDTH_FROM_WIDEST, 
												B_EMPTY_ALERT);
				if (alert) 
				{
					int32 result = alert->Go();
				}
				else 
				{
					warning(FailMemory);
				}
			}
		break;
		case LISTVIEWSELECTONE:
			msgStatus = message->FindPointer("source", &onList);
			if (msgStatus == B_NO_ERROR) 
			{
				int32 index;
				msgStatus = message->FindInt32("index", &index);
				if (msgStatus == B_NO_ERROR) 
				{
					const char * name = ((BStringItem *)onList->ItemAt(index))->Text();
					const char * nodeName = NULL;
					DataNode * node;
					for (	int32 i = 0;
							#pragma warn_possunwant off
							node = (DataNode *)ofDataList->list->ItemAt(i);
							#pragma warn_possunwant reset
							i++) 
					{
						switch (ofDataList->kind) 
						{
							case UNIVERSE_TYPE:
								nodeName = node->MyName(ofDataList->kind);
								if (!strcmp(name, nodeName)) 
								{
									if (strcmp(name, fromName)) 
									{
										universeNewCurrent = (Universe *)node->data;
										caller->PostMessage(	new BMessage(BLLISTGOT), 
																caller->PreferredHandler());
										Quit();
									}
									else 
									{
										node = NULL;
									}
								}
							break;
							case UNIVERSALCONSTANTS_TYPE:
								nodeName = node->MyName(ofDataList->kind);
								if (!strcmp(name, nodeName)) 
								{
									if (strcmp(name, fromName)) 
									{
										universalConstantsNewCurrent = (UniversalConstants *)node->data;
										caller->PostMessage(	new BMessage(BLLISTGOT), 
																caller->PreferredHandler());
										Quit();
									}
									else 
									{
										node = NULL;
									}
								}
							break;
							case SPECIES_TYPE:
								nodeName = node->MyName(ofDataList->kind);
								if (!strcmp(name, nodeName)) 
								{
									if (strcmp(name, fromName)) 
									{
										speciesNewCurrent = (Species *)node->data;
										caller->PostMessage(	new BMessage(BLLISTGOT), 
																caller->PreferredHandler());
										Quit();
									}
									else 
									{
										node = NULL;
									}
								}
							break;
							case GALAXY_TYPE:
								nodeName = node->MyName(ofDataList->kind);
								if (!strcmp(name, nodeName)) 
								{
									if (strcmp(name, fromName)) 
									{
										galaxyNewCurrent = (Galaxy *)node->data;
										caller->PostMessage(	new BMessage(BLLISTGOT), 
																caller->PreferredHandler());
										Quit();
									}
									else 
									{
										node = NULL;
									}
								}
							break;
							case WORMHOLE_TYPE:
								nodeName = node->MyName(ofDataList->kind);
								if (!strcmp(name, nodeName)) 
								{
									if (strcmp(name, fromName)) 
									{
										wormholeNewCurrent = (Wormhole *)node->data;
										caller->PostMessage(	new BMessage(BLLISTGOT), 
																caller->PreferredHandler());
										Quit();
									}
									else 
									{
										node = NULL;
									}
								}
							break;
							case BLACKHOLE_TYPE:
								nodeName = node->MyName(ofDataList->kind);
								if (!strcmp(name, nodeName)) 
								{
									if (strcmp(name, fromName)) 
									{
										blackholeNewCurrent = (Blackhole *)node->data;
										caller->PostMessage(	new BMessage(BLLISTGOT), 
																caller->PreferredHandler());
										Quit();
									}
									else 
									{
										node = NULL;
									}
								}
							break;
							case STAR_TYPE:
								nodeName = node->MyName(ofDataList->kind);
								if (!strcmp(name, nodeName)) 
								{
									if (strcmp(name, fromName)) 
									{
										starNewCurrent = (Star *)node->data;
										caller->PostMessage(	new BMessage(BLLISTGOT), 
																caller->PreferredHandler());
										Quit();
									}
									else 
									{
										node = NULL;
									}
								}
							break;
							case SHIP_TYPE:
								nodeName = node->MyName(ofDataList->kind);
								if (!strcmp(name, nodeName)) 
								{
									if (strcmp(name, fromName)) 
									{
										shipNewCurrent = (Ship *)node->data;
										caller->PostMessage(	new BMessage(BLLISTGOT), 
																caller->PreferredHandler());
										Quit();
									}
									else 
									{
										node = NULL;
									}
								}
							break;
							case ENGINE_TYPE:
								nodeName = node->MyName(ofDataList->kind);
								if (!strcmp(name, nodeName)) 
								{
									if (strcmp(name, fromName)) 
									{
										engineNewCurrent = (Engine *)node->data;
										caller->PostMessage(	new BMessage(BLLISTGOT), 
																caller->PreferredHandler());
										Quit();
									}
									else 
									{
										node = NULL;
									}
								}
							break;
							case SHIPWEAPON_TYPE:
								nodeName = node->MyName(ofDataList->kind);
								if (!strcmp(name, nodeName)) 
								{
									if (strcmp(name, fromName)) 
									{
										shipWeaponNewCurrent = (ShipWeapon *)node->data;
										caller->PostMessage(	new BMessage(BLLISTGOT), 
																caller->PreferredHandler());
										Quit();
									}
									else 
									{
										node = NULL;
									}
								}
							break;
							case SHIPSHIELD_TYPE:
								nodeName = node->MyName(ofDataList->kind);
								if (!strcmp(name, nodeName)) 
								{
									if (strcmp(name, fromName)) 
									{
										shipShieldNewCurrent = (ShipShield *)node->data;
										caller->PostMessage(	new BMessage(BLLISTGOT), 
																caller->PreferredHandler());
										Quit();
									}
									else 
									{
										node = NULL;
									}
								}
							break;
							case PLANET_TYPE:
								nodeName = node->MyName(ofDataList->kind);
								if (!strcmp(name, nodeName)) 
								{
									if (strcmp(name, fromName)) 
									{
										planetNewCurrent = (Planet *)node->data;
										caller->PostMessage(	new BMessage(BLLISTGOT), 
																caller->PreferredHandler());
										Quit();
									}
									else 
									{
										node = NULL;
									}
								}
							break;
							case PLANETWEAPON_TYPE:
								nodeName = node->MyName(ofDataList->kind);
								if (!strcmp(name, nodeName)) 
								{
									if (strcmp(name, fromName)) 
									{
										planetWeaponNewCurrent = (PlanetWeapon *)node->data;
										caller->PostMessage(	new BMessage(BLLISTGOT), 
																caller->PreferredHandler());
										Quit();
									}
									else 
									{
										node = NULL;
									}
								}
							break;
							case PLANETSHIELD_TYPE:
								nodeName = node->MyName(ofDataList->kind);
								if (!strcmp(name, nodeName)) 
								{
									if (strcmp(name, fromName)) 
									{
										planetShieldNewCurrent = (PlanetShield *)node->data;
										caller->PostMessage(	new BMessage(BLLISTGOT), 
																caller->PreferredHandler());
										Quit();
									}
									else 
									{
										node = NULL;
									}
								}
							break;
							case FACTORY_TYPE:
								nodeName = node->MyName(ofDataList->kind);
								if (!strcmp(name, nodeName)) 
								{
									if (strcmp(name, fromName)) 
									{
										factoryNewCurrent = (Factory *)node->data;
										caller->PostMessage(	new BMessage(BLLISTGOT), 
																caller->PreferredHandler());
										Quit();
									}
									else 
									{
										node = NULL;
									}
								}
							break;
							case MINE_TYPE:
								nodeName = node->MyName(ofDataList->kind);
								if (!strcmp(name, nodeName)) 
								{
									if (strcmp(name, fromName)) 
									{
										mineNewCurrent = (Mine *)node->data;
										caller->PostMessage(	new BMessage(BLLISTGOT), 
																caller->PreferredHandler());
										Quit();
									}
									else 
									{
										node = NULL;
									}
								}
							break;
							case COMPOUND_TYPE:
								nodeName = node->MyName(ofDataList->kind);
								if (!strcmp(name, nodeName)) 
								{
									if (strcmp(name, fromName)) 
									{
										compoundNewCurrent = (Compound *)node->data;
										caller->PostMessage(	new BMessage(BLLISTGOT), 
																caller->PreferredHandler());
										Quit();
									}
									else 
									{
										node = NULL;
									}
								}
							break;
							case ELEMENT_TYPE:
								nodeName = node->MyName(ofDataList->kind);
								if (!strcmp(name, nodeName)) 
								{
									if (strcmp(name, fromName)) 
									{
										elementNewCurrent = (Element *)node->data;
										caller->PostMessage(	new BMessage(BLLISTGOT), 
																caller->PreferredHandler());
										Quit();
									}
									else 
									{
										node = NULL;
									}
								}
							break;
							default:
								nodeName = NULL;
								node = NULL;
							break;
						}
					}
				}
				else 
				{
					err = NOMSGINDEX;
				}
			}
			else 
			{	err = NOMSGSOURCE;
			}
		break;
		case LISTVIEWSELECTMULTI:
			bool found = false;
			if (!toList) 
			{
				err = LISTVIEWNOTO;
				warning(FailListViewNoTo);
				return;
			}
			msgStatus = message->FindPointer("source", &list);
			if (msgStatus == B_NO_ERROR) 
			{
				int32 index;
				msgStatus = message->FindInt32("index", &index);
				if (msgStatus == B_NO_ERROR) 
				{
					int32 selectedBy;
					msgStatus = message->FindInt32("selectedBy", &selectedBy);
					if (msgStatus == B_NO_ERROR) 
					{
						int32 selectedFrom;
						msgStatus = message->FindInt32("selectedFrom", &selectedFrom);
						if (msgStatus == B_NO_ERROR) 
						{
							const char * name = ((BStringItem *)list->ItemAt(index))->Text();
							const char * nodeName = NULL;
							DataNode * node;
							void * holdNode = NULL;
							int32 len = ofDataList->list->CountItems();
							for (	int32 i = 0;
									i < len;
									i++) 
							{
								node = (DataNode *)ofDataList->list->ItemAt(i);
								nodeName = node->MyName(ofDataList->kind);
								if (!strcmp(name, nodeName)) 
								{
									holdNode = node;
									i = len;
								}
							}
							if (holdNode) 
							{
								UIntPtrNode * cpn;
								len = toList->CountItems();
								for (	int32 i = 0;
										i < len;
										i++) 
								{
									cpn = (UIntPtrNode *)(toList->ItemAt(i));
									if (!strcmp(name, cpn->MyName(ofDataList->kind))) 
									{
										found = true;
										HowMany(cpn, name, selectedBy, selectedFrom, fromName);
										i = len;
									}
								}
								if (!found) 
								{
									UIntPtrNode * newp = new UIntPtrNode(((DataNode *)holdNode)->data, 0);
									if (newp) 
									{
										HowMany(newp, name, selectedBy, selectedFrom, fromName);
										if (!err) 
										{
											toList->AddItem(newp);
										}
									}
									else 
									{
										err = NOCPTRNODE;
									}
								}
							}
						}
						else 
						{
							err = NOMSGSELECTFROM;
						}
					}
					else 
					{
						err = NOMSGSELECTBY;
					}
				}
				else 
				{
					err = NOMSGINDEX;
				}
			}
			else 
			{
				err = NOMSGSOURCE;
			}
		break;
		default:
			WindowGuts::MessageReceived(message);
		break;
	}
}//end


void 
ListViewWindow	::	HowMany(	UIntPtrNode * gimme, 
								const char * parameName, 
								int32 to, 
								int32 from, 
								const char * fname) 
{
	err = NO_ERR;
	try
	{
		string label = howManyStr;
		label += howManyType[from];
		label += parameName;
		label += howMany4Str;
		label += fname;
		label += howManyType[to];
		BRect holdRect;
		myPrefs->GetPreferredUInt32ReqWindowRect(&holdRect);
		UInt32ReqWindow * pIQW = new UInt32ReqWindow(	holdRect,
														UInt32ReqWindowTitle,
														"UInt32ReqWindowView",
														"UInt32ReqWindowFrame",
														gimme,
														label.c_str(),
														this);
		pIQW->Initialize();
	}
	catch (...) 
	{
		warning(FailUInt32ReqWindow);
		throw;
	}
}//end


bool 
ListViewWindow	::	QuitRequested(	void) 
{
	BRect frame = Frame();
	myPrefs->SetPreferredListViewWindowRect(frame);
	if (mpUInt32ReqWindow)
	{
		mpUInt32ReqWindow->PostMessage(B_QUIT_REQUESTED);
	}
	return(WindowGuts::QuitRequested());
}//end
