//getFromList.cpp

#include "XwarnStr.h"
#include "XgutWindowStr.h"
#include "XselectListStr.h"
#include "windowGuts.h"
#include "error.h"
#include "warning.h"
#include "getFromList.h"
#include "ptrList.h"
#include "dataList.h"
#include "dataNode.h"
#include "hasIntReqWindow.h"
#include "listViewWindow.h"
#include "intGadget.h"
#include "bottomLine.h"
#include "myButton.h"
#include "bottomButtons.h"
#include "stringGadget.h"
#include "unique.h"
#include "textItem.h"
#include "myStringDrawer.h"
#include "layoutMatrixItem.h"
#include "layoutMatrix.h"
#include "constants.h"
#include "universalConstants.h"
#include "editUniversalConstantsWindow.h"
#include "myPreferences.h"

void 
GetFromList(	void * fromWindow, 
				DataList * dataList, 
				const char * scgName) 
{
	err = NO_ERR;
	if (!((BWindow *)fromWindow)->LockLooper())
	{
		return;
	}
	try
	{
		ListViewWindow *lvw = new ListViewWindow(	lvwRect, 
													lvWindowTitleStr[dataList->kind], 
													/*toList*/NULL, 
													dataList, 
													scgName, 
													fromWindow,
													LISTVIEWSELECTONE);
		try
		{
			lvw->listView = new BListView(	listRect, 
											lvwTitleStr[dataList->kind], 
											B_SINGLE_SELECTION_LIST, 
											B_FOLLOW_LEFT | B_FOLLOW_TOP, 
											B_WILL_DRAW | B_NAVIGABLE | B_FRAME_EVENTS);
			for (	int32 i = 0;
					#pragma warn_possunwant off
					node = (DataNode *)dataList->list->ItemAt(i);
					#pragma warn_possunwant reset
					i++) 
			{
				try
				{
					BStringItem * bsi = new BStringItem(node->MyName(dataList->kind));
					lvw->listView->AddItem(bsi);
					bsi->SetEnabled(true);
				}
				catch (...)
				{
					warning(failMemory);
					throw;
				}
			}
			lvw->listView->SetSelectionMessage(new BMessage(LISTVIEWSELECTONE));
			lvw->AddChild(lvw->listView);
			lvw->listView->SetTarget(lvw);
			lvw->listView->SetFont(myPrefs->GetPreferredFont());
			rgb_color viewColor;
			myPrefs->GetPreferredMyListViewViewColor(&viewColor);
			lvw->listView->SetViewColor(viewColor);
			myPrefs->GetPreferredMyListViewHighColor(&viewColor);
			lvw->listView->SetHighColor(viewColor);
			myPrefs->GetPreferredMyListViewLowColor(&viewColor);
			lvw->listView->SetLowColor(viewColor);
			lvw->Show();
		}
		catch (...) 
		{
			if (lvw)
			{
				delete lvw;
			}
			((BWindow *)fromWindow)->UnlockLooper();
		}
	}
	catch (...)
	{
		((BWindow *)fromWindow)->UnlockLooper();
		warning(failMemory);
		throw;
	}
}//end