//prefPanelWindow.cpp

#include "DmenuMsg.h"
#include "windowGuts.h"
#include <memory>
#include "XlayoutMatrixItem.h"
#include "DlayoutMatrix.h"
#include "layoutMatrixItem.h"
#include "layoutMatrix.h"
#include "myButton.h"
#include "textItem.h"
#include "myStringDrawer.h"
#include "fontPrefWindow.h"
#include "specificColorWindow.h"
#include "myCheckBox.h"
#include "DcolorControlMessages.h"
#include "basicColorWindow.h"
#include "DnumSpecificWindows.h"
#include "XprefPanelWindow.h"
#include "prefPanelWindow.h"
#include "Xwarning.h"
#include "preferences.h"
#include "myroColour.h"
#include "myPreferences.h"
#include "myApp.h"
#include "titleWindow.h"
#include "Xverify.h"

#define PREFPANEL_COLOR_BASIC 'Pcb '
#define PREFPANEL_COLOR_BUTTON 'Pcbb'
#define PREFPANEL_COLOR_RADIOVIEW 'Pcrv'
#define PREFPANEL_COLOR_STRINGDRAWER 'Pcsp'
#define PREFPANEL_COLOR_CHECKBOX 'Pccb'
#define PREFPANEL_COLOR_PICTURE 'Pcp '
#define PREFPANEL_COLOR_COLORCONTROL 'Pccc'
#define PREFPANEL_COLOR_STATUSBAR 'Pcsb'
#define PREFPANEL_COLOR_INTGADG 'Pcig'
#define PREFPANEL_COLOR_STRINGGADG 'Pcsg'
#define PREFPANEL_COLOR_COLORWELL 'Pccw'
#define PREFPANEL_COLOR_TEXTVIEW 'Pctv'
#define PREFPANEL_COLOR_LISTVIEW 'Pclv'
#define PREFPANEL_FONTS 'Pfnt'
#define PREFPANEL_COLOR_FLOATGADG 'Pcfg'

uint32 buttonMessages[NUMPREFPANELS] =
	{
		PREFPANEL_COLOR_BASIC,
		PREFPANEL_COLOR_BUTTON,
		PREFPANEL_COLOR_PICTURE,
		PREFPANEL_COLOR_RADIOVIEW,
		PREFPANEL_COLOR_CHECKBOX,
		PREFPANEL_COLOR_STATUSBAR,
		PREFPANEL_COLOR_COLORCONTROL,
		PREFPANEL_COLOR_TEXTVIEW,
		PREFPANEL_COLOR_INTGADG,
		PREFPANEL_COLOR_STRINGGADG,
		PREFPANEL_COLOR_COLORWELL,
		PREFPANEL_COLOR_STRINGDRAWER,
		PREFPANEL_COLOR_LISTVIEW,
		PREFPANEL_COLOR_FLOATGADG
	};
const char * buttonNames[] =
	{
		"underlying",
		"button",
		"picture Button",
		"radiobuttons",
		"checkBox",
		"statusBar",
		"colorControl",
		"textview",
		"integerGadg",
		"stringGadget",
		"roColourColorWell",
		"stringDraw",
		"listview",
		"floatGadget",
	};

//ctor
PrefPanelWindow	::	PrefPanelWindow(	BRect	paramBound,
										const char * paramWindowTitle,
										const char * paramScrollViewName,
										const char * paramNamePrefFrame)
				: 
				WindowGuts(	paramBound, 
							paramWindowTitle, 
							paramScrollViewName,
							paramNamePrefFrame),
				mpFontPrefWindow(NULL)
{
	for (	uint32 i = 0;
			i < NUMPREFPANELS;
			i++)
	{
		mpPrefWindows[i] = NULL;
	}
	sem_id calc_sem;
	if ((calc_sem = create_sem(1, "calc_sem")) < B_NO_ERROR)
	{
		warning(FailCreateSemaphore);
		return;
	}
	acquire_sem(calc_sem);
	try 
	{
		for (	uint32 i = 0;
				i < NUMPREFPANELS;
				i++)
		{
			mpPrefWindows[i] = NULL;
		}
//		BWindow bw(	BRect(0, 0, 32, 32), 
//					NoShowWindow, 
//					B_DOCUMENT_WINDOW, 
//					/*B_WILL_ACCEPT_FIRST_CLICK*/0);
//////////////////////////////////////////////////////////////////////////////////////////////
		LayoutMatrix *	pholdTitleLayoutMatrix = new LayoutMatrix(BESTSIZE, 3, 1, this);//rows,columns
/////////////////////////////////////////////////////////////////////////////////////////////
		BFont * pBFont = new BFont(myPrefs->GetPreferredFont());
		float fontSize = pBFont->Size();
		fontSize *= 3;
		if (fontSize > 200)
		{
			fontSize = 200;
		}
		pBFont->SetSize(fontSize);
		pBFont->SetShear(122);
		MyStringDrawer * pMyStringDrawer = new MyStringDrawer(	"prefPanelMyStringDrawer", 
																		PrefPanelWindowHeading1, 
																		B_FOLLOW_NONE, 
																		B_WILL_DRAW,
																		pBFont,
																		pholdTitleLayoutMatrix);
		auto_ptr<LayoutMatrixItem> apMyStringDrawerLayoutMatrixItem(new LayoutMatrixItem(	(void *)pMyStringDrawer, 
																							pholdTitleLayoutMatrix->itemsList,
																							KIND_STRINGDRAWER));
//////////////////////////////////////////////////
		MyButton * pholdFontMyButton = new MyButton(	"FontButton", 
														PrefPanelFontButtonLable, 
														PREFPANEL_FONTS,
														B_FOLLOW_NONE, 
														B_WILL_DRAW,
														pholdTitleLayoutMatrix);
		auto_ptr<LayoutMatrixItem> apFontMyButtonLayoutMatrixItem(new LayoutMatrixItem(	(void *)pholdFontMyButton, 
																						pholdTitleLayoutMatrix->itemsList,
																						KIND_MYBUTTON));
////////////////////////////////////////////////
		BFont * pS2BFont = new BFont(myPrefs->GetPreferredFont());
		float fontS2Size = pS2BFont->Size();
		fontS2Size *= 2;
		if (fontS2Size > 200)
		{
			fontS2Size = 200;
		}
		pS2BFont->SetSize(fontS2Size);
		MyStringDrawer * pColorMyStringDrawer = new MyStringDrawer(	"prefPanelColorMyStringDrawer", 
																	PrefPanelWindowHeading2, 
																	B_FOLLOW_NONE, 
																	B_WILL_DRAW,
																	pS2BFont,
																	pholdTitleLayoutMatrix);
		auto_ptr<LayoutMatrixItem> apColorMyStringDrawerLayoutMatrixItem(new LayoutMatrixItem(	(void *)pColorMyStringDrawer, 
																								pholdTitleLayoutMatrix->itemsList,
																								KIND_STRINGDRAWER));
//////////////////////////////////////////////////////////////////////////////////////////////
		LayoutMatrix *	pholdCheckLayoutMatrix = new LayoutMatrix(SAMESIZE, 1, 2, this);//rows,columns
/////////////////////////////////////////////////////////////////////////////////////////////
		mpDisplayColorControlCheckBox = new MyCheckBox(	"displayCC", 
														DisplayBColorControls,
														myPrefs->bUseColorControl,
														DISPLAY_CC,
														B_FOLLOW_NONE, 
														B_WILL_DRAW,
														pholdCheckLayoutMatrix);
		LayoutMatrixItem * displayCCLMI = new LayoutMatrixItem(	(void *)mpDisplayColorControlCheckBox, 
																pholdCheckLayoutMatrix->itemsList,
																KIND_MYCHECKBOX);
//////////////////////////////////////////////////////////////////////////////////////
		mpDisplayColorWellCheckBox = new MyCheckBox(	"displayCW", 
														DisplayroColourWells, 
														myPrefs->bUseColorWell,
														DISPLAY_CW,
														B_FOLLOW_NONE, 
														B_WILL_DRAW,
														pholdCheckLayoutMatrix);
		LayoutMatrixItem * displayCWLMI = new LayoutMatrixItem(	(void *)mpDisplayColorWellCheckBox, 
																pholdCheckLayoutMatrix->itemsList,
																KIND_MYCHECKBOX);
//////////////////////////////////////////////////////////////////////////////////////////////
		LayoutMatrix *	pholdPrefPanelLayoutMatrix = new LayoutMatrix(SAMESIZE, 4, 3, this);//rows,columns
/////////////////////////////////////////////////////////////////////////////////////////////
		{
			LayoutMatrixItem * layoutMatrixItem[NUMPREFPANELS - 2];
			for (	uint32 iButton = 0;
					iButton < (NUMPREFPANELS - 2);
					iButton++)
			{
				MyButton * button = new MyButton(	buttonNames[iButton], 
													buttonLabels[iButton], 
													buttonMessages[iButton], 
													B_FOLLOW_NONE, 
													B_WILL_DRAW,
													pholdPrefPanelLayoutMatrix);
				layoutMatrixItem[iButton] = new LayoutMatrixItem(	(void *)button, 
																	pholdPrefPanelLayoutMatrix->itemsList,
																	KIND_MYBUTTON);
			}
		}
////////////////////////////////////////////////////////////////////////
		LayoutMatrix *	pholdListViewLayoutMatrix = new LayoutMatrix(SAMESIZE, 1, 2, this);//rows,columns
/////////////////////////////////////////////////////////////////////////////////////////////
		{
			MyButton * fgButton = new MyButton(	buttonNames[PP_COLOR_FLOATGADG], 
												buttonLabels[PP_COLOR_FLOATGADG], 
												buttonMessages[PP_COLOR_FLOATGADG], 
												B_FOLLOW_NONE, 
												B_WILL_DRAW,
												pholdListViewLayoutMatrix);
			LayoutMatrixItem * fgLMI = new LayoutMatrixItem(	(void *)fgButton, 
																pholdListViewLayoutMatrix->itemsList,
																KIND_MYBUTTON);
			MyButton * lvButton = new MyButton(	buttonNames[PP_COLOR_LISTVIEW], 
												buttonLabels[PP_COLOR_LISTVIEW], 
												buttonMessages[PP_COLOR_LISTVIEW], 
												B_FOLLOW_NONE, 
												B_WILL_DRAW,
												pholdListViewLayoutMatrix);
			LayoutMatrixItem * lvLMI = new LayoutMatrixItem(	(void *)lvButton, 
																pholdListViewLayoutMatrix->itemsList,
																KIND_MYBUTTON);
		}
////////////////////////////////////////////////////////
		release_sem(calc_sem);
		pholdTitleLayoutMatrix->Calc(MATRIXHORIZONTALOFFSET, MATRIXVERTICALOFFSET, calc_sem);
		pholdCheckLayoutMatrix->Calc(MATRIXHORIZONTALOFFSET, pholdTitleLayoutMatrix->bottom, calc_sem);
		pholdPrefPanelLayoutMatrix->Calc(MATRIXHORIZONTALOFFSET, pholdCheckLayoutMatrix->bottom, calc_sem);
		pholdListViewLayoutMatrix->Calc(MATRIXHORIZONTALOFFSET, pholdPrefPanelLayoutMatrix->bottom, calc_sem);	
	}
	catch (...)
	{
		warning(CaughtPrefPanelWindowCTOR);
		release_sem(calc_sem);
		throw;
	}
	try 
	{
		BMenuItem *	menuItem;
		BMenu * APPMenu = new BMenu(AppMenuLable);
		menuItem = new BMenuItem(	AboutMenuLable, 
									new BMessage(ABOUT_PREFPANELWINDOW));
		APPMenu->AddItem(menuItem);
		menuItem = new BMenuItem(	CloseWindow, 
									new BMessage(B_QUIT_REQUESTED));
		APPMenu->AddItem(menuItem);
		menuItem = new BMenuItem(	QuitMenuLable, 
									new BMessage(QUIT_APP));
		APPMenu->AddItem(menuItem);
		pMenuBar->AddItem(APPMenu);
	}
	catch(...) 
	{
		throw;
	}
}//end


//dtor
PrefPanelWindow	::	~PrefPanelWindow() 
{
	myPrefs->pPrefPanelWindow = NULL;
	for (	uint32 i = 0;
			i < NUMPREFPANELS;
			i++)
	{
		if (mpPrefWindows[i])
		{
			mpPrefWindows[i]->PostMessage(B_QUIT_REQUESTED);
		}
	}
	if (mpFontPrefWindow)
	{
		mpFontPrefWindow->PostMessage(B_QUIT_REQUESTED);
	}
	if (myPrefs->bPrefChangesMade)
	{
		myApp->pTitleWindow->PostMessage(B_QUIT_REQUESTED);
	}
}//end


void
PrefPanelWindow	::	MessageReceived(	BMessage * pparamMessage) 
{
	switch(pparamMessage->what) 
	{
		case PREFPANEL_COLOR_BASIC://debug might re-enroll this case by simply adding a demo item to it
			OpenBasicColorPanel();//makes all windows equal and greatly simplifies things--see version 2 <smile>
		break;
		case PREFPANEL_FONTS:
			OpenFontPanel();
		break;
		case PREFPANEL_COLOR_BUTTON:
			OpenSpecificColorPanel(SPECIFIC_COLOR_BUTTON);
		break;
		case PREFPANEL_COLOR_RADIOVIEW:
			OpenSpecificColorPanel(SPECIFIC_COLOR_RADIOVIEW);
		break;
		case PREFPANEL_COLOR_STRINGDRAWER:
			OpenSpecificColorPanel(SPECIFIC_COLOR_STRINGDRAWER);
		break;
		case PREFPANEL_COLOR_CHECKBOX:
			OpenSpecificColorPanel(SPECIFIC_COLOR_CHECKBOX);
		break;
		case PREFPANEL_COLOR_PICTURE:
			OpenSpecificColorPanel(SPECIFIC_COLOR_PICTURE);
		break;
		case PREFPANEL_COLOR_COLORCONTROL:
			OpenSpecificColorPanel(SPECIFIC_COLOR_COLORCONTROL);
		break;
		case PREFPANEL_COLOR_STATUSBAR:
			OpenSpecificColorPanel(SPECIFIC_COLOR_STATUSBAR);
		break;
		case PREFPANEL_COLOR_INTGADG:
			OpenSpecificColorPanel(SPECIFIC_COLOR_INTGADG);
		break;
		case PREFPANEL_COLOR_FLOATGADG:
			OpenSpecificColorPanel(SPECIFIC_COLOR_FLOATGADG);
		break;
		case PREFPANEL_COLOR_STRINGGADG:
			OpenSpecificColorPanel(SPECIFIC_COLOR_STRINGGADG);
		break;
		case PREFPANEL_COLOR_COLORWELL:
			OpenSpecificColorPanel(SPECIFIC_COLOR_COLORWELL);
		break;
		case PREFPANEL_COLOR_TEXTVIEW:
			OpenSpecificColorPanel(SPECIFIC_COLOR_TEXTVIEW);
		break;
		case PREFPANEL_COLOR_LISTVIEW:
			OpenSpecificColorPanel(SPECIFIC_COLOR_LISTVIEW);
		break;
		case ABOUT_PREFPANELWINDOW:	
			warning(AboutPrefPanelWindow);
		break;
		case QUIT_APP:
			if (Verify(ReallyQuitApp))
			{
				myApp->PostMessage(B_QUIT_REQUESTED);
			}
		break;
		case DISPLAY_CC:
			myPrefs->bUseColorControl = mpDisplayColorControlCheckBox->Value();
		break;
		case DISPLAY_CW:
			myPrefs->bUseColorWell = mpDisplayColorWellCheckBox->Value();
		break;
		default:
			WindowGuts::MessageReceived(pparamMessage);
		break;
	}
}//end


bool
PrefPanelWindow	::	QuitRequested(	void) 
{
	BRect frame = Frame();
	myPrefs->SetPreferredPrefPanelWindowRect(frame);
	myPrefs->bUseColorWell = mpDisplayColorWellCheckBox->Value();
	myPrefs->bUseColorControl = mpDisplayColorControlCheckBox->Value();
	return(WindowGuts::QuitRequested());
}//end


void
PrefPanelWindow	::	OpenFontPanel(void)
{
	if (mpFontPrefWindow)
	{
		mpFontPrefWindow->Activate(true);
	}
	else
	{
		try 
		{
			BRect holdRect;
			myPrefs->GetPreferredFontPrefWindowRect(&holdRect);
			mpFontPrefWindow = new FontPrefWindow(	holdRect,
													FontPrefWindowTitle,
													"fontPrefWindow",
													"FontPrefFrame");
			mpFontPrefWindow->Initialize();
		}
		catch (...) 
		{
			warning(CaughtFontPrefWindowCTOR);
			throw;
		}
	}
}//end


void
PrefPanelWindow	::	OpenBasicColorPanel(void)
{
	if (mpPrefWindows[PP_BASIC])
	{
		mpPrefWindows[PP_BASIC]->Activate(true);
	}
	else
	{
		try 
		{
			BRect holdRect;
			myPrefs->GetPreferredBasicColorWindowRect(&holdRect);
			mpPrefWindows[PP_BASIC] = new BasicColorWindow(	holdRect,
															BasicColorWindowTitle,
															"basicColorWindow",
															"FontPrefFrame");
			mpPrefWindows[PP_BASIC]->Initialize();
		}
		catch (...) 
		{
			warning(NoBasicColorWindow);
			throw;
		}
	}
}//end


void
PrefPanelWindow	::	OpenSpecificColorPanel(uint32 whichOne)
{
	if (mpPrefWindows[whichOne + 1])//whichOne references an array with button at zero
	{			//mpPrefWindows[] is an array with basic at zero and button at one
		mpPrefWindows[whichOne + 1]->Activate(true);//debug dump plus one in ver .2 <smile>
	}
	else
	{
		try 
		{
			BRect holdRect;
			switch (whichOne)
			{
				case SPECIFIC_COLOR_BUTTON:
					myPrefs->GetPreferredSpecificColorButtonWindowRect(&holdRect);
				break;
				case SPECIFIC_COLOR_PICTURE:
					myPrefs->GetPreferredSpecificColorPictureButtonWindowRect(&holdRect);
				break;
				case SPECIFIC_COLOR_RADIOVIEW:
					myPrefs->GetPreferredSpecificColorRadioButtonWindowRect(&holdRect);
				break;
				case SPECIFIC_COLOR_CHECKBOX:
					myPrefs->GetPreferredSpecificColorCheckBoxWindowRect(&holdRect);
				break;
				case SPECIFIC_COLOR_STATUSBAR:
					myPrefs->GetPreferredSpecificColorStatusBarWindowRect(&holdRect);
				break;
				case SPECIFIC_COLOR_COLORCONTROL:
					myPrefs->GetPreferredSpecificColorColorControlWindowRect(&holdRect);
				break;
				case SPECIFIC_COLOR_TEXTVIEW:
					myPrefs->GetPreferredSpecificColorTextViewWindowRect(&holdRect);
				break;
				case SPECIFIC_COLOR_LISTVIEW:
					myPrefs->GetPreferredSpecificColorListViewWindowRect(&holdRect);
				break;
				case SPECIFIC_COLOR_INTGADG:
					myPrefs->GetPreferredSpecificColorUInt32GadgetWindowRect(&holdRect);
				break;
				case SPECIFIC_COLOR_FLOATGADG:
					myPrefs->GetPreferredSpecificColorFloatGadgetWindowRect(&holdRect);
				break;
				case SPECIFIC_COLOR_STRINGGADG:
					myPrefs->GetPreferredSpecificColorStringGadgetWindowRect(&holdRect);
				break;
				case SPECIFIC_COLOR_COLORWELL:
					myPrefs->GetPreferredSpecificColorColorWellWindowRect(&holdRect);
				break;
				case SPECIFIC_COLOR_STRINGDRAWER:
					myPrefs->GetPreferredSpecificColorStringDrawerWindowRect(&holdRect);
				break;
			}
			mpPrefWindows[whichOne] = new SpecificColorWindow(	holdRect,
																whichOne);
			mpPrefWindows[whichOne]->Initialize();
		}
		catch (...) 
		{
			warning(NoSpecColorWindow);
			throw;
		}
	}
}//end
