//scrolling pref window

#include "DmenuMsg.h"
#include "textItem.h"
#include "XlayoutMatrixItem.h"
#include "DlayoutMatrix.h"
#include "layoutMatrixItem.h"
#include "layoutMatrix.h"
#include "myStringDrawer.h"
#include "Xwarning.h"
#include "preferences.h"
#include "myroColour.h"
#include "myPreferences.h"
#include "myApp.h"
#include "windowGuts.h"
#include "myCheckBox.h"
#include "prefPanelWindow.h"
#include "fontPrefWindow.h"
#include "fontDisplayWindow.h"
#include "XfontDisplayWindow.h"
#include <memory>
#include "Xverify.h"

//ctor
FontDisplayWindow	::	FontDisplayWindow(	BRect paramBound,
											const char * paramWindow,
											const char * paramScrollViewName,
											const char * paramNamePrefFrame,
											const char * paramPutString)
			: 
				WindowGuts(	paramBound, 
							paramWindow, 
							paramScrollViewName,
							paramNamePrefFrame),
				mcpPutString(paramPutString)
{
	sem_id calc_sem;
	if ((calc_sem = create_sem(1, "calc_sem")) < B_NO_ERROR)
	{
		warning(FailCreateSemaphore);
		return;
	}
	acquire_sem(calc_sem);
	try 
	{
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		LayoutMatrix *	pholdStringDrawerLayoutMatrix = new LayoutMatrix(BESTSIZE, 1, 1, this);//rows,columns
/////////////////////////////////////////////////////////////////////////////////////////////
		MyStringDrawer * pMyStringDrawer = new MyStringDrawer(	"displayFontMyStringDrawer", 
																	mcpPutString, 
																	B_FOLLOW_NONE, 
																	B_WILL_DRAW,
																	NULL,
																	pholdStringDrawerLayoutMatrix);
		auto_ptr<LayoutMatrixItem> apMyStringDrawerLayoutMatrixItem(new LayoutMatrixItem(	(void *)pMyStringDrawer, 
																							pholdStringDrawerLayoutMatrix->itemsList,
																							KIND_STRINGDRAWER));
///////////////////////////////////////////////////////////////////////////////////////////////////////
		release_sem(calc_sem);
		pholdStringDrawerLayoutMatrix->Calc(	MATRIXHORIZONTALOFFSET, 
												MATRIXVERTICALOFFSET, 
												calc_sem);
	}
	catch (...)
	{
		release_sem(calc_sem);
		throw;
	}
	try 
	{
		BMenuItem *	menuItem;
		BMenu * appMenu = new BMenu(AppMenuLable);
		menuItem = new BMenuItem(	AboutMenuLable, 
									new BMessage(ABOUT_FONTDISPLAYWINDOW));
		appMenu->AddItem(menuItem);
		menuItem = new BMenuItem(	CloseWindow, 
									new BMessage(B_QUIT_REQUESTED));
		appMenu->AddItem(menuItem);
		menuItem = new BMenuItem(	QuitMenuLable, 
									new BMessage(QUIT_APP));
		appMenu->AddItem(menuItem);
		pMenuBar->AddItem(appMenu);
	}
	catch(...) 
	{
		throw;
	}
}//end


//dtor
FontDisplayWindow	::	~FontDisplayWindow() 
{
	if (myPrefs->pPrefPanelWindow)
	{
		if (myPrefs->pPrefPanelWindow->mpFontPrefWindow)
		{
	
			((FontPrefWindow *)(myPrefs->pPrefPanelWindow->mpFontPrefWindow))->mpFontDisplayWindow = NULL;
		}
	}
}//end


void
FontDisplayWindow	::	MessageReceived(	BMessage * pparamMessage) 
{
	switch(pparamMessage->what) 
	{
		
		case ABOUT_FONTDISPLAYWINDOW:	
		{
			warning(AboutFontDisplayWindow);
		break;
		}
		case QUIT_APP:
			if (Verify(ReallyQuitApp))
			{
				myApp->PostMessage(B_QUIT_REQUESTED);
			}
		break;
		default:
			WindowGuts::MessageReceived(pparamMessage);
		break;
	}
}//end


bool
FontDisplayWindow	::	QuitRequested() 
{
	BRect frame = Frame();
	myPrefs->SetPreferredFontDisplayWindowRect(frame);
	return(WindowGuts::QuitRequested());
}//end
