//myStringDrawer.cpp

#include "layoutMatrixItem.h"
#include "preferences.h"
#include "myroColour.h"
#include "myPreferences.h"
#include "myApp.h"
#include "windowGuts.h"
#include "layoutMatrix.h"
#include "textItem.h"
#include "XmyStringDrawer.h"
#include "myStringDrawer.h"
#include "layoutMatrix.h"


MyStringDrawer	::	~MyStringDrawer() 
{
	delete textItem;
	delete font;
};//end


//ctor
MyStringDrawer	::	MyStringDrawer(	const char * paramName, 
									const char * paramText,
									uint32 	ui32ResizeFlags,
									uint32 	ui32Flags,
									BFont * pparamFont,
									LayoutMatrix * lpparamLayoutMatrix) 
				: 
					BStringView(	BRect(0, 0, 32, 32),
									paramName, 
									paramText,
									ui32ResizeFlags,
									ui32Flags),
					textItem(	new TextItem(	paramText,
												NULL))
{
	lpparamLayoutMatrix->AddToChildren((void *)this);
	if (pparamFont)
	{
		font = pparamFont;
	}
	else
	{
		font = new BFont(myPrefs->GetPreferredFont());
	}
	SetFont(font);
}//end


void 
MyStringDrawer	::	AttachedToWindow() 
{
	BView::AttachedToWindow();
	rgb_color tempRgbColor;
	myPrefs->GetPreferredMyStringDrawerHighColor(&tempRgbColor);
	SetHighColor(tempRgbColor);
	myPrefs->GetPreferredMyStringDrawerLowColor(&tempRgbColor);
	SetLowColor(tempRgbColor);
	myPrefs->GetPreferredMyStringDrawerViewColor(&tempRgbColor);
	SetViewColor(tempRgbColor);
}//end


void
MyStringDrawer	::	MyGetPreferredSize(	float * fpparamWidth,
										float * fpparamHeight)
{
	BRect	br(0, 0, 32, 32);
	BView	bv(br, NoShowView, B_FOLLOW_NONE, NULL);
	bv.SetFont(font);
	font_height	fontHeight;
	bv.GetFontHeight(&fontHeight);
	descender = fontHeight.descent + fontHeight.leading;
	*fpparamHeight = fontHeight.ascent + descender;
	*fpparamWidth = bv.StringWidth(((BStringView *)this)->Text());
	float shear = font->Shear();
	//shear will always be between 45 and 135
	if (shear < 90)
	{
		SetAlignment(B_ALIGN_RIGHT);
	}
	else if (shear > 90)
	{
		SetAlignment(B_ALIGN_LEFT);
	}
}//end


BFont *
MyStringDrawer	::	GetFont(	void) const
{
	return font;
}//end


TextItem *
MyStringDrawer	::	GetTextItem(	void) const
{
	return textItem;
}//end
