//myStatusBar

#include "layoutMatrixItem.h"
#include "preferences.h"
#include "myroColour.h"
#include "myPreferences.h"
#include "myApp.h"
#include "XmyStatusBar.h"
#include "myStatusBar.h"
#include "layoutMatrix.h"

MyStatusBar	::	~MyStatusBar() 
{
	//left blank
};//end


//ctor
MyStatusBar	::	MyStatusBar(	BRect paramFrame,
								const char * paramName,
								const char * paramLabel,
								const char * paramTrailingLabel,
								float fparamMaxValue,
								float fparamValue,
								LayoutMatrix * lpparamLayoutMatrix) 
				: 
					BStatusBar(	paramFrame,
								paramName,
								paramLabel,
								paramTrailingLabel),
					fValue(fparamValue)
{
	SetMaxValue(fparamMaxValue);
	lpparamLayoutMatrix->AddToChildren((void *)this);
}//end


void
MyStatusBar	::	MyGetPreferredSize(	float * fpparamWidth,
									float * fpparamHeight)
{
	BRect	br(0, 0, 32, 32);
	BView	bv(br, NoShowView, B_FOLLOW_NONE, NULL);
	bv.SetFont(myPrefs->GetPreferredFont());
	font_height	fontHeight;
	bv.GetFontHeight(&fontHeight);
	float totalFontHeight = fontHeight.ascent + fontHeight.descent + fontHeight.leading;
	float barHeight = myPrefs->GetPreferredBarHeight();
	SetBarHeight(barHeight);
	float padWidth = 2 * bv.StringWidth("M");//needs some padding
	float textWidth = bv.StringWidth(Text());
	float trailingTextWidth = bv.StringWidth(TrailingText());
	float labelWidth = bv.StringWidth(Label());
	float trailingLabelWidth = bv.StringWidth(TrailingLabel());
	float totalWidth = textWidth + trailingTextWidth + labelWidth + trailingLabelWidth + padWidth;
	*fpparamWidth = totalWidth;
	*fpparamHeight = totalFontHeight + barHeight;//may need some padding??
}//end


void 
MyStatusBar	::	AttachedToWindow() 
{
	BView::AttachedToWindow();
	rgb_color tempRgbColor;
	myPrefs->GetPreferredMyStatusBarHighColor(&tempRgbColor);
	SetHighColor(tempRgbColor);
	myPrefs->GetPreferredMyStatusBarLowColor(&tempRgbColor);
	SetLowColor(tempRgbColor);
	myPrefs->GetPreferredMyStatusBarViewColor(&tempRgbColor);
	SetViewColor(tempRgbColor);
	Update(fValue);
}//end