//basicColorWindow.cpp

#include "DmenuMsg.h"
#include "XprefPanelWindow.h"
#include "windowGuts.h"
#include "Xs2f.h"
#include "XlayoutMatrixItem.h"
#include "DlayoutMatrix.h"
#include "layoutMatrixItem.h"
#include "layoutMatrix.h"
#include "textItem.h"
#include "myStringDrawer.h"
#include "preferences.h"
#include "myCheckBox.h"
#include "myColorControl.h"
#include "XcolorWell.h"
#include "colorWell.h"
#include "prefPanelWindow.h"
#include "myPreferences.h"
#include "DcolorControlMessages.h"
#include "XbasicColorWindow.h"
#include "basicColorWindow.h"
#include "Xwarning.h"
#include "preferences.h"
#include "myroColour.h"
#include "myPreferences.h"
#include "myApp.h"
#include <memory>
#include <string>
#include "titleWindow.h"
#include "Xverify.h"

//ctor
BasicColorWindow	::	BasicColorWindow(	BRect	paramBound,
									const char * paramWindowTitle,
									const char * paramScrollViewName,
									const char * paramNamePrefFrame)
				: 
				WindowGuts(	paramBound, 
							paramWindowTitle, 
							paramScrollViewName,
							paramNamePrefFrame),
				pmViewColorControl(NULL),
				pmHighColorControl(NULL),
				pmLowColorControl(NULL),
				pmViewColorWell(NULL),
				pmHighColorWell(NULL),
				pmLowColorWell(NULL)
{
	sem_id calc_sem;
	if ((calc_sem = create_sem(1, "calc_sem")) < B_NO_ERROR)
	{
		warning(FailCreateSemaphore);
		return;
	}
	acquire_sem(calc_sem);
	try 
	{
		LayoutMatrix * pholdTitleLayoutMatrix = new LayoutMatrix(BESTSIZE, 1, 1, this);//rows,columns
/////////////////////////////////////////////////////////////////////////////////////////////
		BFont * pBFont = new BFont(myPrefs->GetPreferredFont());
		float fontSize = pBFont->Size();
		fontSize *= 3;
		if (fontSize > 200)
		{
			fontSize = 200;
		}
		pBFont->SetSize(fontSize);
		pBFont->SetShear(122);
		//will need offset for demo--use a seperate matrix and get it's bottom
		MyStringDrawer * pMyStringDrawer = new MyStringDrawer(	"basicColorHeading", 
																BasicColorWindowHeading1, 
																B_FOLLOW_NONE, 
																B_WILL_DRAW,
																pBFont,
																pholdTitleLayoutMatrix);
		auto_ptr<LayoutMatrixItem> apMyStringDrawerLMI(new LayoutMatrixItem(	(void *)pMyStringDrawer, 
																				pholdTitleLayoutMatrix->itemsList,
																				KIND_STRINGDRAWER));
/////////////////////////////
		if (!myPrefs->bUseColorControl && !myPrefs->bUseColorWell)
		{
			warning(noCCenabled);
		}
		LayoutMatrix * pholdViewCCLayoutMatrix = NULL;
		LayoutMatrix * pholdHighCCLayoutMatrix = NULL;
		LayoutMatrix * pholdLowCCLayoutMatrix = NULL;
		MyStringDrawer * pMyStringDrawerAXX = NULL;
		LayoutMatrixItem * pMyStringDrawerAXXLMI = NULL;
		LayoutMatrixItem * pColorControlAXXLMI = NULL;
		MyStringDrawer * pMyStringDrawerBXX = NULL;
		LayoutMatrixItem * pMyStringDrawerBXXLMI = NULL;
		LayoutMatrixItem * pColorControlBXXLMI = NULL;
		MyStringDrawer * pMyStringDrawerCXX = NULL;
		LayoutMatrixItem * pMyStringDrawerCXXLMI = NULL;
		LayoutMatrixItem * pColorControlCXXLMI = NULL;
		rgb_color color;//re-use for every setvalue
		if (myPrefs->bUseColorControl)
		{
			pholdViewCCLayoutMatrix = new LayoutMatrix(BESTSIZE, 2, 1, this);//rows,columns
	/////////////////////////////////////////////////////////////////////////////////////
			pMyStringDrawerAXX = new MyStringDrawer(	"MyStringDrawerAXX", 
														ColorWindowHeading2, 
														B_FOLLOW_NONE, 
														B_WILL_DRAW,
														NULL,
														pholdViewCCLayoutMatrix);
			pMyStringDrawerAXXLMI = new LayoutMatrixItem(	(void *)pMyStringDrawerAXX, 
															pholdViewCCLayoutMatrix->itemsList,
															KIND_STRINGDRAWER);
	////////////////////////////////////////////////////////////////////
			pmViewColorControl = new MyColorControl(	BPoint(1, 1), 
														B_CELLS_8x32,//lots of other options! Make a pref??
														1,
														"ColorControlAXX", 
														COLORCONTROL_VIEW, 
														true,
														this,
														pholdViewCCLayoutMatrix);
			myPrefs->GetPreferredViewColor(&color);
			pmViewColorControl->SetValue(color);
			pColorControlAXXLMI = new LayoutMatrixItem(	(void *)pmViewColorControl, 
														pholdViewCCLayoutMatrix->itemsList,
														KIND_MYCOLORCONTROL);
	/////////////////////
			pholdHighCCLayoutMatrix = new LayoutMatrix(BESTSIZE, 2, 1, this);//rows,columns
	////////////////////////////////
			pMyStringDrawerBXX = new MyStringDrawer(	"MyStringDrawerBXX", 
														ColorWindowHeading3, 
														B_FOLLOW_NONE, 
														B_WILL_DRAW,
														NULL,
														pholdHighCCLayoutMatrix);
			pMyStringDrawerBXXLMI = new LayoutMatrixItem(	(void *)pMyStringDrawerBXX, 
															pholdHighCCLayoutMatrix->itemsList,
															KIND_STRINGDRAWER);
	/////////////////////////////////////////////
			pmHighColorControl = new MyColorControl(	BPoint(1, 1), 
														B_CELLS_8x32,
														1,
														"HighColorControlBXX", 
														COLORCONTROL_HIGH, 
														true,
														this,
														pholdHighCCLayoutMatrix);
			myPrefs->GetPreferredHighColor(&color);
			pmHighColorControl->SetValue(color);
			pColorControlBXXLMI = new LayoutMatrixItem(	(void *)pmHighColorControl, 
														pholdHighCCLayoutMatrix->itemsList,
														KIND_MYCOLORCONTROL);
	//////////////////////////////////////////////////////////////
			pholdLowCCLayoutMatrix = new LayoutMatrix(BESTSIZE, 2, 1, this);//rows,columns
	///////////////////////////////////////////////////
			pMyStringDrawerCXX = new MyStringDrawer(	"MyStringDrawerCXX", 
																		ColorWindowHeading4, 
																		B_FOLLOW_NONE, 
																		B_WILL_DRAW,
																		NULL,
																		pholdLowCCLayoutMatrix);
			pMyStringDrawerCXXLMI = new LayoutMatrixItem(	(void *)pMyStringDrawerCXX, 
															pholdLowCCLayoutMatrix->itemsList,
															KIND_STRINGDRAWER);
	///////////////////////////////////////////////////////////////////
			pmLowColorControl = new MyColorControl(	BPoint(1, 1), 
													B_CELLS_8x32,
													1,
													"LowColorControlCXX", 
													COLORCONTROL_LOW, 
													true,
													this,
													pholdLowCCLayoutMatrix);
			myPrefs->GetPreferredLowColor(&color);
			pmLowColorControl->SetValue(color);
			pColorControlCXXLMI = new LayoutMatrixItem(	(void *)pmLowColorControl, 
														pholdLowCCLayoutMatrix->itemsList,
														KIND_MYCOLORCONTROL);
		}
////////////////////////
		LayoutMatrix * pholdColorWellLayoutMatrix = NULL;
		TextItem * pholdMainViewColorWellText = NULL;
		LayoutMatrixItem * pMainViewLMI = NULL;
		TextItem * pholdMainHighColorWellText = NULL;
		LayoutMatrixItem * pMainHighLMI = NULL;
		TextItem * pholdMainLowColorWellText = NULL;
		LayoutMatrixItem * pMainLowLMI = NULL;
		if (myPrefs->bUseColorWell)
		{
			pholdColorWellLayoutMatrix = new LayoutMatrix(BESTSIZE, 3, 1, this);//rows,columns
	//////////////
			pholdMainViewColorWellText = new TextItem(	ColorWindowHeading5,
														pholdColorWellLayoutMatrix);
			pmViewColorWell = new ColorWell(	"ColorWellViewColorPref", 
												B_FOLLOW_NONE, 
												B_WILL_DRAW,
												VIEW_COLOR,
												pholdMainViewColorWellText,
												pholdColorWellLayoutMatrix);
			pMainViewLMI = new LayoutMatrixItem(	(void *)pmViewColorWell, 
													pholdColorWellLayoutMatrix->itemsList,
													KIND_COLORWELLGADG);
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			pholdMainHighColorWellText = new TextItem(	ColorWindowHeading6,
														pholdColorWellLayoutMatrix);
			pmHighColorWell = new ColorWell(	"ColorWellHighColorPref", 
												B_FOLLOW_NONE, 
												B_WILL_DRAW,
												HIGH_COLOR,
												pholdMainHighColorWellText,
												pholdColorWellLayoutMatrix);
			pMainHighLMI = new LayoutMatrixItem(	(void *)pmHighColorWell, 
													pholdColorWellLayoutMatrix->itemsList,
													KIND_COLORWELLGADG);
	////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			pholdMainLowColorWellText = new TextItem(	ColorWindowHeading7,
														pholdColorWellLayoutMatrix);
			pmLowColorWell = new ColorWell(	"ColorWellLowColorPref", 
											B_FOLLOW_NONE, 
											B_WILL_DRAW,
											LOW_COLOR,
											pholdMainLowColorWellText,
											pholdColorWellLayoutMatrix);
			pMainLowLMI = new LayoutMatrixItem(	(void *)pmLowColorWell, 
												pholdColorWellLayoutMatrix->itemsList,
												KIND_COLORWELLGADG);
		}
//////////////
		release_sem(calc_sem);
		pholdTitleLayoutMatrix->Calc(MATRIXHORIZONTALOFFSET, MATRIXVERTICALOFFSET, calc_sem);
		float bottom = pholdTitleLayoutMatrix->bottom;
		if (myPrefs->bUseColorControl)
		{
			pholdViewCCLayoutMatrix->Calc(MATRIXHORIZONTALOFFSET, bottom, calc_sem);
			pholdHighCCLayoutMatrix->Calc(pholdViewCCLayoutMatrix->right, bottom, calc_sem);
			pholdLowCCLayoutMatrix->Calc(pholdHighCCLayoutMatrix->right, bottom, calc_sem);
			bottom = pholdLowCCLayoutMatrix->bottom;
			delete pMyStringDrawerAXXLMI;
			delete pColorControlAXXLMI;
			delete pMyStringDrawerBXXLMI;
			delete pColorControlBXXLMI;
			delete pMyStringDrawerCXXLMI;
			delete pColorControlCXXLMI;
		}
		if (myPrefs->bUseColorWell)
		{
			pholdColorWellLayoutMatrix->Calc(MATRIXHORIZONTALOFFSET, bottom, calc_sem);
			delete pMainViewLMI;
			delete pMainHighLMI;
			delete pMainLowLMI;
		}
	}
	catch (...)
	{
		warning(CaughtBasicColorWindowCTOR);
		release_sem(calc_sem);
		throw;
	}
	try 
	{
		BMenuItem *	menuItem;
		BMenu *		APPMenu = new BMenu(AppMenuLable);
		menuItem = new BMenuItem(	AboutMenuLable, 
									new BMessage(ABOUT_BASICCOLORWINDOW));
		APPMenu->AddItem(menuItem);
		menuItem = new BMenuItem(	CloseWindow, 
									new BMessage(B_QUIT_REQUESTED));
		APPMenu->AddItem(menuItem);
		menuItem = new BMenuItem(	QuitMenuLable, 
									new BMessage(QUIT_APP));
		APPMenu->AddItem(menuItem);
		pMenuBar->AddItem(APPMenu);
	}
	catch(...) 
	{
		throw;
	}
}//end


//dtor
BasicColorWindow	::	~BasicColorWindow() 
{
	if (myPrefs->pPrefPanelWindow)//can get a race if not checked
	{
		myPrefs->pPrefPanelWindow->mpPrefWindows[PP_BASIC] = NULL;
	}
	if (myPrefs->bPrefChangesMade)
	{
		myApp->pTitleWindow->PostMessage(B_QUIT_REQUESTED);
	}
}//end


bool
BasicColorWindow	::	QuitRequested(	void) 
{
	BRect frame = Frame();
	myPrefs->SetPreferredBasicColorWindowRect(frame);
	if (pmViewColorControl)//if you got one you got 'em all
	{
		rgb_color color(pmViewColorControl->ValueAsColor());
		myPrefs->SetPreferredViewColor(&color);
		color = pmHighColorControl->ValueAsColor();
		myPrefs->SetPreferredHighColor(&color);
		color = pmLowColorControl->ValueAsColor();
		myPrefs->SetPreferredLowColor(&color);
	}
	return(WindowGuts::QuitRequested());
}//end


void
BasicColorWindow	::	ResetDemo(	void)
{
	myPrefs->bPrefChangesMade = true;
}//end


void
BasicColorWindow	::	MessageReceived(	BMessage * pparamMessage) 
{
	switch(pparamMessage->what) 
	{
		case ABOUT_BASICCOLORWINDOW:
		{
			string warn = AboutBasicColorWindowMsg1;
			warn += AboutBasicColorWindowMsg2;
			warning(warn.c_str());
		break;
		}
		case QUIT_APP:
			if (Verify(ReallyQuitApp))
			{
				myApp->PostMessage(B_QUIT_REQUESTED);
			}
		break;
		case COLORCONTROL_VIEW:
		case COLORCONTROL_HIGH:
		case COLORCONTROL_LOW:
			ResetDemo();
		break;
		case roColourDROPPEDMESSAGE: 
		{
    		rgb_color * pRGBColor;
    		rgb_color color;  		
    		int32 numRGBBytes = sizeof(struct rgb_color);
	        if (	pparamMessage->FindData(	"RGBColor",
		       									B_RGB_COLOR_TYPE, 
												(void**)&pRGBColor, 
												&numRGBBytes ) 
					== B_OK)
	        {
	           	color = *pRGBColor;
	            if (pparamMessage->WasDropped()) 
	            {
					int32 colorToChange;
					if (	pparamMessage->FindInt32(	"ColorToChange",
														&colorToChange)
							 == B_OK)
					{
						switch(colorToChange)
						{
							case VIEW_COLOR:
								myPrefs->SetPreferredViewColor(&color);
								pmViewColorControl->SetValue(color);
							break;
							case HIGH_COLOR:
								myPrefs->SetPreferredHighColor(&color);
								pmHighColorControl->SetValue(color);
							break;
							case LOW_COLOR:
								myPrefs->SetPreferredLowColor(&color);
								pmLowColorControl->SetValue(color);
							break;
							case NO_COLOR:
								warning(DemoRoNo);
							break;
							default:
								warning(RoBadMsg);
								throw;
							break;
						}
						ResetDemo();
					}
				}
			}
		break;
		}
		default:
			WindowGuts::MessageReceived(pparamMessage);
		break;
	}
}//end
