//EditUniverse function of OpeningWindow soi0.1

#include <memory>
#include "windowGuts.h"
#include "titleWindow.h"
#include "bottomLine.h"
#include "buttonInfo.h"
#include "designButtons.h"

void OpeningWindow::EditUniverse() {

float biggestX = 635;
float biggestY = 475;
BRect editWindowRect(40,20, biggestX,biggestY);
try {
	editUniverseWindow = new EditUniverseWindow(editWindowRect, editThe[UNIVERSE_TYPE]);
}
catch (...) {
	warning(failEditWindow);
	return;
}
editUniverseWindow->Lock();

const char * theDesignButtonLabel;

BRect nameRect(10,0, 580,18);
char * prelimName;
if (dataListGlobal[UNIVERSE_TYPE]->list->CountItems()) prelimName = universeCurrent->name;
else prelimName = NULL;
try {
	auto_ptr<BMessage> msg(new BMessage(SOI_NAMEUNIVERSE));
	editUniverseWindow->nameStrGadget = new StringGadget(nameRect, nameGadgetStr, nameOf[UNIVERSE_TYPE], prelimName, msg.get(), B_FOLLOW_LEFT | B_FOLLOW_TOP, B_WILL_DRAW | B_NAVIGABLE);
	msg.release();
}
catch (...) {
	warning(failStringGadget);
	editUniverseWindow->Unlock();
	editUniverseWindow->Show();
	return;
}
editUniverseWindow->nameStrGadget->SetAlignment(B_ALIGN_RIGHT, B_ALIGN_LEFT);
editUniverseWindow->nameStrGadget->SetDivider(180.0);
editUniverseWindow->nameStrGadget->makeFocus = true;
editUniverseWindow->AddChild(editUniverseWindow->nameStrGadget);

float xExtent = 0;
float yExtent = 0;
ButtonInfo aBut((BWindow *)editUniverseWindow, &editUniverseWindow->buttons[DFLT_UNIVERSALCONSTANTS], editUniverseWindow->PreferredHandler(), "", defaultThe[UNIVERSALCONSTANTS_TYPE], SOI_EDITUNIVERSEDFLTCONSTANTS, true);
if (dataListGlobal[UNIVERSALCONSTANTS_TYPE]->list->CountItems()) theDesignButtonLabel = editThe[UNIVERSALCONSTANTS_TYPE];
else theDesignButtonLabel = designThe[UNIVERSALCONSTANTS_TYPE];
ButtonInfo bBut((BWindow *)editUniverseWindow, &editUniverseWindow->buttons[DSN_UNIVERSALCONSTANTS], editUniverseWindow->PreferredHandler(), "", theDesignButtonLabel, SOI_EDITUNIVERSEEDITCONSTANTS, true);
ButtonInfo cBut((BWindow *)editUniverseWindow, &editUniverseWindow->buttons[LOAD_UNIVERSALCONSTANTS], editUniverseWindow->PreferredHandler(), "", loadThe[UNIVERSALCONSTANTS_TYPE], SOI_EDITUNIVERSELOADCONSTANTS, true);

ButtonInfo dBut((BWindow *)editUniverseWindow, &editUniverseWindow->buttons[DFLT_SPECIES], editUniverseWindow->PreferredHandler(), "", defaultThe[SPECIES_TYPE], SOI_EDITUNIVERSEDFLTSPECIES, true);
if (dataListGlobal[SPECIES_TYPE]->list->CountItems()) theDesignButtonLabel = editThe[SPECIES_TYPE];
else theDesignButtonLabel = designThe[SPECIES_TYPE];
ButtonInfo eBut((BWindow *)editUniverseWindow, &editUniverseWindow->buttons[DSN_SPECIES], editUniverseWindow->PreferredHandler(), "", theDesignButtonLabel, SOI_EDITUNIVERSEEDITSPECIES, true);
ButtonInfo fBut((BWindow *)editUniverseWindow, &editUniverseWindow->buttons[LOAD_SPECIES], editUniverseWindow->PreferredHandler(), "", loadThe[SPECIES_TYPE], SOI_EDITUNIVERSELOADSPECIES, true);

ButtonInfo gBut((BWindow *)editUniverseWindow, &editUniverseWindow->buttons[DFLT_ELEMENT], editUniverseWindow->PreferredHandler(), "", defaultThe[ELEMENT_TYPE], SOI_EDITUNIVERSEDFLTELEMENT, true);
if (dataListGlobal[ELEMENT_TYPE]->list->CountItems()) theDesignButtonLabel = editThe[ELEMENT_TYPE];
else theDesignButtonLabel = designThe[ELEMENT_TYPE];
ButtonInfo hBut((BWindow *)editUniverseWindow, &editUniverseWindow->buttons[DSN_ELEMENT], editUniverseWindow->PreferredHandler(), "", theDesignButtonLabel, SOI_EDITUNIVERSEEDITELEMENT, true);
ButtonInfo iBut((BWindow *)editUniverseWindow, &editUniverseWindow->buttons[LOAD_ELEMENT], editUniverseWindow->PreferredHandler(), "", loadThe[ELEMENT_TYPE], SOI_EDITUNIVERSELOADELEMENT, true);

ButtonInfo jBut((BWindow *)editUniverseWindow, &editUniverseWindow->buttons[DFLT_COMPOUND], editUniverseWindow->PreferredHandler(), "", defaultThe[COMPOUND_TYPE], SOI_EDITUNIVERSEDFLTCOMPOUND, true);
if (dataListGlobal[COMPOUND_TYPE]->list->CountItems()) theDesignButtonLabel = editThe[COMPOUND_TYPE];
else theDesignButtonLabel = designThe[COMPOUND_TYPE];
ButtonInfo kBut((BWindow *)editUniverseWindow, &editUniverseWindow->buttons[DSN_COMPOUND], editUniverseWindow->PreferredHandler(), "", theDesignButtonLabel, SOI_EDITUNIVERSEEDITCOMPOUND, true);
ButtonInfo lBut((BWindow *)editUniverseWindow, &editUniverseWindow->buttons[LOAD_COMPOUND], editUniverseWindow->PreferredHandler(), "", loadThe[COMPOUND_TYPE], SOI_EDITUNIVERSELOADCOMPOUND, true);

ButtonInfo * someUCButtons[12];
someUCButtons[0] = &aBut;
someUCButtons[1] = &bBut;
someUCButtons[2] = &cBut;
someUCButtons[3] = &dBut;
someUCButtons[4] = &eBut;
someUCButtons[5] = &fBut;
someUCButtons[6] = &gBut;
someUCButtons[7] = &hBut;
someUCButtons[8] = &iBut;
someUCButtons[9] = &jBut;
someUCButtons[10] = &kBut;
someUCButtons[11] = &lBut;

if (!MakeButtonRC(10, 20, 3, 4, someUCButtons, &xExtent, &yExtent)) {
	editUniverseWindow->Unlock();
	editUniverseWindow->Show();
	return;
}
if ((xExtent > biggestX) || (yExtent > biggestY)) {
//debug resize window
beep();
}

if (dataListGlobal[MINE_TYPE]->list->CountItems()) theDesignButtonLabel = editThe[MINE_TYPE];
else theDesignButtonLabel = designThe[MINE_TYPE];
ButtonInfo aABut((BWindow *)editUniverseWindow, &editUniverseWindow->buttons[DSN_MINE], editUniverseWindow->PreferredHandler(), "", theDesignButtonLabel, SOI_EDITUNIVERSEEDITMINE, true);

if (dataListGlobal[FACTORY_TYPE]->list->CountItems()) theDesignButtonLabel = editThe[FACTORY_TYPE];
else theDesignButtonLabel = designThe[FACTORY_TYPE];
ButtonInfo bABut((BWindow *)editUniverseWindow, &editUniverseWindow->buttons[DSN_FACTORY], editUniverseWindow->PreferredHandler(), "", theDesignButtonLabel, SOI_EDITUNIVERSEEDITFACTORY, true);

if (dataListGlobal[ENGINE_TYPE]->list->CountItems()) theDesignButtonLabel = editThe[ENGINE_TYPE];
else theDesignButtonLabel = designThe[ENGINE_TYPE];
ButtonInfo cABut((BWindow *)editUniverseWindow, &editUniverseWindow->buttons[DSN_ENGINE], editUniverseWindow->PreferredHandler(), "", theDesignButtonLabel, SOI_EDITUNIVERSEEDITENGINE, true);

if (dataListGlobal[SHIPWEAPON_TYPE]->list->CountItems()) theDesignButtonLabel = editThe[SHIPWEAPON_TYPE];
else theDesignButtonLabel = designThe[SHIPWEAPON_TYPE];
ButtonInfo dABut((BWindow *)editUniverseWindow, &editUniverseWindow->buttons[DSN_SHIPWEAPON], editUniverseWindow->PreferredHandler(), "", theDesignButtonLabel, SOI_EDITUNIVERSEEDITSHIPWEAPON, true);

if (dataListGlobal[SSHIELD_TYPE]->list->CountItems()) theDesignButtonLabel = editThe[SSHIELD_TYPE];
else theDesignButtonLabel = designThe[SSHIELD_TYPE];
ButtonInfo eABut((BWindow *)editUniverseWindow, &editUniverseWindow->buttons[DSN_SSHIELD], editUniverseWindow->PreferredHandler(), "", theDesignButtonLabel, SOI_EDITUNIVERSEEDITSSHIELD, true);

if (dataListGlobal[SHIP_TYPE]->list->CountItems()) theDesignButtonLabel = editThe[SHIP_TYPE];
else theDesignButtonLabel = designThe[SHIP_TYPE];
ButtonInfo fABut((BWindow *)editUniverseWindow, &editUniverseWindow->buttons[DSN_SHIP], editUniverseWindow->PreferredHandler(), "", theDesignButtonLabel, SOI_EDITUNIVERSEEDITSHIP, true);

if (dataListGlobal[PLANETWEAPON_TYPE]->list->CountItems()) theDesignButtonLabel = editThe[PLANETWEAPON_TYPE];
else theDesignButtonLabel = designThe[PLANETWEAPON_TYPE];
ButtonInfo gABut((BWindow *)editUniverseWindow, &editUniverseWindow->buttons[DSN_PLANETWEAPON], editUniverseWindow->PreferredHandler(), "", theDesignButtonLabel, SOI_EDITUNIVERSEEDITPLANETWEAPON, true);

if (dataListGlobal[PLANETSHIELD_TYPE]->list->CountItems()) theDesignButtonLabel = editThe[PLANETSHIELD_TYPE];
else theDesignButtonLabel = designThe[PLANETSHIELD_TYPE];
ButtonInfo hABut((BWindow *)editUniverseWindow, &editUniverseWindow->buttons[DSN_PLANETSHIELD], editUniverseWindow->PreferredHandler(), "", theDesignButtonLabel, SOI_EDITUNIVERSEEDITPLANETSHIELD, true);

if (dataListGlobal[PLANET_TYPE]->list->CountItems()) theDesignButtonLabel = editThe[PLANET_TYPE];
else theDesignButtonLabel = designThe[PLANET_TYPE];
ButtonInfo iABut((BWindow *)editUniverseWindow, &editUniverseWindow->buttons[DSN_PLANET], editUniverseWindow->PreferredHandler(), "", theDesignButtonLabel, SOI_EDITUNIVERSEEDITPLANET, true);

if (dataListGlobal[STAR_TYPE]->list->CountItems()) theDesignButtonLabel = editThe[STAR_TYPE];
else theDesignButtonLabel = designThe[STAR_TYPE];
ButtonInfo jABut((BWindow *)editUniverseWindow, &editUniverseWindow->buttons[DSN_STAR], editUniverseWindow->PreferredHandler(), "", theDesignButtonLabel, SOI_EDITUNIVERSEEDITSTAR, true);

if (dataListGlobal[WORMHOLE_TYPE]->list->CountItems()) theDesignButtonLabel = editThe[WORMHOLE_TYPE];
else theDesignButtonLabel = designThe[WORMHOLE_TYPE];
ButtonInfo kABut((BWindow *)editUniverseWindow, &editUniverseWindow->buttons[DSN_WORMHOLE], editUniverseWindow->PreferredHandler(), "", theDesignButtonLabel, SOI_EDITUNIVERSEEDITWHOLE, true);

if (dataListGlobal[BLACKHOLE_TYPE]->list->CountItems()) theDesignButtonLabel = editThe[BLACKHOLE_TYPE];
else theDesignButtonLabel = designThe[BLACKHOLE_TYPE];
ButtonInfo lABut((BWindow *)editUniverseWindow, &editUniverseWindow->buttons[DSN_BLACKHOLE], editUniverseWindow->PreferredHandler(), "", theDesignButtonLabel, SOI_EDITUNIVERSEEDITGALAXY, true);

if (dataListGlobal[GALAXY_TYPE]->list->CountItems()) theDesignButtonLabel = editThe[GALAXY_TYPE];
else theDesignButtonLabel = designThe[GALAXY_TYPE];
ButtonInfo mABut((BWindow *)editUniverseWindow, &editUniverseWindow->buttons[DSN_GALAXY], editUniverseWindow->PreferredHandler(), "", theDesignButtonLabel, SOI_EDITUNIVERSEEDITGALAXY, true);

ButtonInfo * moreUCButtons[13];
moreUCButtons[0] = &aABut;
moreUCButtons[1] = &bABut;
moreUCButtons[2] = &cABut;
moreUCButtons[3] = &dABut;
moreUCButtons[4] = &eABut;
moreUCButtons[5] = &fABut;
moreUCButtons[6] = &gABut;
moreUCButtons[7] = &hABut;
moreUCButtons[8] = &iABut;
moreUCButtons[9] = &jABut;
moreUCButtons[10] = &kABut;
moreUCButtons[11] = &lABut;
moreUCButtons[12] = &mABut;
if (!MakeButtonCol(10, 115, 13, moreUCButtons, &xExtent, &yExtent)) {
	editUniverseWindow->Unlock();
	editUniverseWindow->Show();
	return;
}
if ((xExtent > biggestX) || (yExtent > biggestY)) {
//debug resize window
beep();
}
bool save = false;
if (dataListGlobal[UNIVERSE_TYPE]->list->CountItems()) save = true;
editUniverseWindow->bottom = 428;
BottomLine(UNIVERSE_TYPE, editUniverseWindow, editUniverseWindow->bottom, editUniverseWindow->bb, SOI_BLADD, save);
editUniverseWindow->thisDNPtr = dataListGlobal[UNIVERSE_TYPE]->NextPrevItems((void *)universeCurrent, &editUniverseWindow->nextDNPtr, &editUniverseWindow->prevDNPtr, editUniverseWindow->bb);

editUniverseWindow->Unlock();
editUniverseWindow->Show();
}//end