//editSpeciesWindow.cpp

#include "Xui32RandBetween.h"
#include "DmenuMsg.h"
#include "Dstar.h"
#include "Xthings.h"
#include "windowGuts.h"
#include <memory>
#include <string>
#include "XlayoutMatrixItem.h"
#include "DlayoutMatrix.h"
#include "layoutMatrixItem.h"
#include "layoutMatrix.h"
#include "myButton.h"
#include "myCheckBox.h"
#include "textItem.h"
#include "myStringDrawer.h"
#include "myPopUpMenu.h"
#include "myPictureButton.h"
#include "myColorControl.h"
#include "myStatusBar.h"
#include "myRadioView.h"
#include "myTextView.h"
#include "stringGadget.h"
#include "bottomLine.h"
#include "bottomButtons.h"
#include "designButtons.h"
#include "constants.h"
#include "DlistViewWindow.h"
#include "listViewWindow.h"
#include "XeditSpeciesWindow.h"
#include "editSpeciesWindow.h"
#include "Xwarning.h"
#include "preferences.h"
#include "myPreferences.h"
#include "myroColour.h"
#include "myApp.h"
#include "getFromList.h"
#include "dataNode.h"
#include "dataList.h"
#include "species.h"
#include "Xunique.h"
#include "error.h"
#include "XfileHeaders.h"
#include "Xverify.h"
#include "titleWindow.h"
#include "truncateString.h"

//ctor
EditSpeciesWindow	::	EditSpeciesWindow(	BRect paramBound,
											const char * paramWindowTitle,
											const char * paramScrollViewName,
											const char * paramNamePrefFrame)
			: 
				WindowGuts(	paramBound, 
							paramWindowTitle, 
							paramScrollViewName,
							paramNamePrefFrame),
				saveSpeciesPanel(NULL), 
				saveSpeciesMessenger(NULL), 
				loadSpeciesPanel(NULL), 
				loadSpeciesMessenger(NULL),
				pBottomButtons(new BottomButtons),
				mpNameStrGadget(NULL),
				mpPUMMinOriginStarClass(NULL),
				mpPUMMinOriginPlanetCharacteristic(NULL),
				mpPUMMinMinHabitableStarClass(NULL),
				mpPUMMinMinHabitablePlanetCharacteristic(NULL),
				mpPUMMinMaxHabitableStarClass(NULL),
				mpPUMMinMaxHabitablePlanetCharacteristic(NULL),
				mpPUMMaxOriginStarClass(NULL),
				mpPUMMaxOriginPlanetCharacteristic(NULL),
				mpPUMMaxMinHabitableStarClass(NULL),
				mpPUMMaxMinHabitablePlanetCharacteristic(NULL),
				mpPUMMaxMaxHabitableStarClass(NULL),
				mpPUMMaxMaxHabitablePlanetCharacteristic(NULL),
				mpUInt32GadgetMinOriginOrbit(NULL),
				mpUInt32GadgetMaxOriginOrbit(NULL),
				mpUInt32GadgetMinMinHabitableOrbit(NULL),
				mpUInt32GadgetMinMaxHabitableOrbit(NULL),
				mpUInt32GadgetMaxMinHabitableOrbit(NULL),
				mpUInt32GadgetMaxMaxHabitableOrbit(NULL),
				mpTViewDescription(NULL)
{
	myApp->pEditSpeciesWindow = this;
	sem_id calc_sem;
	if ((calc_sem = create_sem(1, "calc_sem")) < B_NO_ERROR)
	{
		warning(FailCreateSemaphore);
		return;
	}
	acquire_sem(calc_sem);
	try 
	{
		LayoutMatrix *	pNameLayoutMatrix = new LayoutMatrix(BESTSIZE, 1, 1, this);//rows,columns
/////////////////////////////////////////////////////////////////////////////////////////////
		char * prelimName;
		uint32 prelimMinOriginStarClass;
		uint32 prelimMinOriginPlanetCharacteristic;
		uint32 prelimMinOriginOrbit;
		uint32 prelimMinMinHabitableStarClass;
		uint32 prelimMinMinHabitablePlanetCharacteristic;
		uint32 prelimMinMinHabitableOrbit;
		uint32 prelimMinMaxHabitableStarClass;
		uint32 prelimMinMaxHabitablePlanetCharacteristic;
		uint32 prelimMinMaxHabitableOrbit;
		uint32 prelimMaxOriginStarClass;
		uint32 prelimMaxOriginPlanetCharacteristic;
		uint32 prelimMaxOriginOrbit;
		uint32 prelimMaxMinHabitableStarClass;
		uint32 prelimMaxMinHabitablePlanetCharacteristic;
		uint32 prelimMaxMinHabitableOrbit;
		uint32 prelimMaxMaxHabitableStarClass;
		uint32 prelimMaxMaxHabitablePlanetCharacteristic;
		uint32 prelimMaxMaxHabitableOrbit;
		if (speciesCurrent) 
		{
			prelimName = speciesCurrent->name;
			prelimMinOriginStarClass = speciesCurrent->MinOriginStarClass;
			prelimMinOriginPlanetCharacteristic = speciesCurrent->MinOriginPlanetCharacteristic;
			prelimMinOriginOrbit = speciesCurrent->MinOriginOrbit;
			prelimMinMinHabitableStarClass = speciesCurrent->MinMinHabitableStarClass;
			prelimMinMinHabitablePlanetCharacteristic = speciesCurrent->MinMinHabitablePlanetCharacteristic;
			prelimMinMinHabitableOrbit = speciesCurrent->MinMinHabitableOrbit;
			prelimMinMaxHabitableStarClass = speciesCurrent->MinMaxHabitableStarClass;
			prelimMinMaxHabitablePlanetCharacteristic = speciesCurrent->MinMaxHabitablePlanetCharacteristic;
			prelimMinMaxHabitableOrbit = speciesCurrent->MinMaxHabitableOrbit;
			prelimMaxOriginStarClass = speciesCurrent->MaxOriginStarClass;
			prelimMaxOriginPlanetCharacteristic = speciesCurrent->MaxOriginPlanetCharacteristic;
			prelimMaxOriginOrbit = speciesCurrent->MaxOriginOrbit;
			prelimMaxMinHabitableStarClass = speciesCurrent->MaxMinHabitableStarClass;
			prelimMaxMinHabitablePlanetCharacteristic = speciesCurrent->MaxMinHabitablePlanetCharacteristic;
			prelimMaxMinHabitableOrbit = speciesCurrent->MaxMinHabitableOrbit;
			prelimMaxMaxHabitableStarClass = speciesCurrent->MaxMaxHabitableStarClass;
			prelimMaxMaxHabitablePlanetCharacteristic = speciesCurrent->MaxMaxHabitablePlanetCharacteristic;
			prelimMaxMaxHabitableOrbit = speciesCurrent->MaxMaxHabitableOrbit;
		}
		else 
		{
			prelimName = NULL;
			prelimMinOriginStarClass = ui32RandBetween(0, (NUMSTARCLASSES - 1));
			prelimMinOriginPlanetCharacteristic = ui32RandBetween(0, (NUMSTARCLASSES - 1));
			prelimMinOriginOrbit = ui32RandBetween(0, (NUMSTARCLASSES - 1));
			prelimMinMinHabitableStarClass = ui32RandBetween(0, (NUMSTARCLASSES - 1));
			prelimMinMinHabitablePlanetCharacteristic = ui32RandBetween(0, (NUMSTARCLASSES - 1));
			prelimMinMinHabitableOrbit = ui32RandBetween(0, (NUMSTARCLASSES - 1));
			prelimMinMaxHabitableStarClass = ui32RandBetween(0, (NUMSTARCLASSES - 1));
			prelimMinMaxHabitablePlanetCharacteristic = ui32RandBetween(0, (NUMSTARCLASSES - 1));
			prelimMinMaxHabitableOrbit = ui32RandBetween(0, (NUMSTARCLASSES - 1));
			prelimMaxOriginStarClass = ui32RandBetween(0, (NUMSTARCLASSES - 1));
			prelimMaxOriginPlanetCharacteristic = ui32RandBetween(0, (NUMSTARCLASSES - 1));
			prelimMaxOriginOrbit = ui32RandBetween(0, (NUMSTARCLASSES - 1));
			prelimMaxMinHabitableStarClass = ui32RandBetween(0, (NUMSTARCLASSES - 1));
			prelimMaxMinHabitablePlanetCharacteristic = ui32RandBetween(0, (NUMSTARCLASSES - 1));
			prelimMaxMinHabitableOrbit = ui32RandBetween(0, (NUMSTARCLASSES - 1));
			prelimMaxMaxHabitableStarClass = ui32RandBetween(0, (NUMSTARCLASSES - 1));
			prelimMaxMaxHabitablePlanetCharacteristic = ui32RandBetween(0, (NUMSTARCLASSES - 1));
			prelimMaxMaxHabitableOrbit = ui32RandBetween(0, (NUMSTARCLASSES - 1));
		}
		mpNameStrGadget = new StringGadget(	"stringGadgetName", 
											NameSpeciesStrGadgetLable, 
											prelimName, 
											NAMESPECIESMSG, 
											B_FOLLOW_NONE, 
											B_WILL_DRAW | B_NAVIGABLE,
											0,
											pNameLayoutMatrix,
											true);
		auto_ptr<LayoutMatrixItem> apNameLayoutMatrixItem(new LayoutMatrixItem(	(void *)mpNameStrGadget, 
																				pNameLayoutMatrix->itemsList,
																				KIND_STRINGGADG));
																				
////////////////////////////////////////////
		LayoutMatrix *	pPUMLayoutMatrix = new LayoutMatrix(BESTSIZE, 1, 1, this);//rows,columns
//////////////////////////////////
	BList * pumBList = new BList();
	PopUpMenuData  * pumData[NUMSTARCLASSES];
	for (	uint32 i = 0;
			i < NUMSTARCLASSES;
			i++)
	{
		pumData[i] = new PopUpMenuData(starClassStr[i], pumBList);
	}
	TextItem * pMinOriginStarClassText = new TextItem(	MinOriginStarClassText,
														pPUMLayoutMatrix);
	MyPopUpMenu * pumMinOriginStarClass = new MyPopUpMenu(	"MinOriginStarClassPUM", 
															starClassStr[prelimMinOriginStarClass],
															pumBList, 
															true,
															pMinOriginStarClassText,
															pPUMLayoutMatrix);
	if (!pumMinOriginStarClass->Initialize()) 
	{
		warning(FailPUMInitEditWindow);
	}
	auto_ptr<LayoutMatrixItem> apPUM1LayoutMatrixItem(new LayoutMatrixItem(	(void *)pumMinOriginStarClass, 
																			pPUMLayoutMatrix->itemsList,
																			KIND_MYPOPUPMENU));
////////////////////////////////////////////////////////////
		uint32 picKind = SPECIESPICKIND;
#include "bottomLine.source"
////////////////////////////////////////////////////
		thisDNPtr = dataListGlobal[SPECIES_TYPE]->NextPrevItems(	(void *)speciesCurrent, 
																			&nextDNPtr, 
																			&prevDNPtr, 
																			pBottomButtons);
		if (!prevDNPtr)
		{
			pBottomButtons->prev->SetEnabled(false);
		}
		if (!nextDNPtr)
		{
			pBottomButtons->next->SetEnabled(false);
		}
		if (!prevDNPtr && !nextDNPtr)
		{
			pBottomButtons->list->SetEnabled(false);
		}
		if (!dataListGlobal[SPECIES_TYPE]->list->CountItems()) 
		{
			pBottomButtons->remove->SetEnabled(false);
		}
/////////////////////////////////////////////////////////////////////////
		release_sem(calc_sem);
		pNameLayoutMatrix->Calc(MATRIXHORIZONTALOFFSET, MATRIXVERTICALOFFSET, calc_sem);
		pPUMLayoutMatrix->Calc(MATRIXHORIZONTALOFFSET, pNameLayoutMatrix->bottom, calc_sem);
		
		pBottomLineLayoutMatrix->Calc(MATRIXHORIZONTALOFFSET, pPUMLayoutMatrix->bottom, calc_sem);
	}
	catch (...)
	{
		warning(CaughtEditSpeciesWindowCTOR);
		release_sem(calc_sem);
		throw;
	}
	try 
	{
		BMenuItem *	menuItem;
		BMenu * APPMenu = new BMenu(AppMenuLable);
		menuItem = new BMenuItem(	AboutMenuLable, 
									new BMessage(ABOUT_EDITSPECIESWINDOW));
		APPMenu->AddItem(menuItem);
		menuItem = new BMenuItem(	PreferenceMenuLable, 
									new BMessage(PREFSMSG));
		APPMenu->AddItem(menuItem);
		menuItem = new BMenuItem(	QuitMenuLable, 
									new BMessage(QUIT_APP));
		APPMenu->AddItem(menuItem);
		pMenuBar->AddItem(APPMenu);
		BMenu * fileMenu = new BMenu(FileMenuLable);
		menuItem = new BMenuItem(	LoadPreviousLable, 
									new BMessage(BLLOAD));
		fileMenu->AddItem(menuItem);
		menuItem = new BMenuItem(	SaveLable, 
									new BMessage(BLSAVE));
		fileMenu->AddItem(menuItem);
		pMenuBar->AddItem(fileMenu);
	}
	catch(...) 
	{
		throw;
	}
}//end


//dtor
EditSpeciesWindow	::	~EditSpeciesWindow() 
{
	delete saveSpeciesPanel;
	delete saveSpeciesMessenger;
	delete loadSpeciesPanel;
	delete loadSpeciesMessenger;
	if (pBottomButtons)
	{
		delete pBottomButtons;
	}
	myApp->pEditSpeciesWindow = NULL;
}//end


void
EditSpeciesWindow	::	MessageReceived(	BMessage * pparamMessage) 
{
	bool validate = strcmp(mpNameStrGadget->Text(), "");
	switch(pparamMessage->what) 
	{
		case ABOUT_EDITSPECIESWINDOW:	
		{
			warning(AboutEditSpeciesWindowMsg);
		break;
		}
		case BEGUIPUM:
			warning("debug star class menu");
		break;
		case QUIT_APP:
		{
			if (Verify(ReallyQuitApp))
			{
				myApp->PostMessage(B_QUIT_REQUESTED);
			}
		break;
		}
		case BLSAVE:
			if (validate)
			{
				if (!saveSpeciesPanel) 
				{
					try 
					{
						saveSpeciesMessenger = new BMessenger(this);
					}
					catch (...) 
					{
						warning(FailMemory);
						saveSpeciesMessenger = NULL;
						return;
					}
					try 
					{
						saveSpeciesPanel = new BFilePanel(	B_SAVE_PANEL, 
															saveSpeciesMessenger, 
															NULL, 
															B_FILE_NODE, 
															false, 
															new BMessage(SAVEFROMPANEL), 
															NULL, 
															false, 
															true);
						saveSpeciesPanel->Show();
					}
					catch (...) 
					{
						warning(FailMemory);
						saveSpeciesPanel = NULL;
						return;
					}
				}
				else 
				{
					saveSpeciesPanel->Show();
				}
			}
			else
			{
				warning(NeedNameToKeep);
			}
		break;
		case BLLOAD:
		{
			if (!loadSpeciesPanel) 
			{
				try 
				{
					loadSpeciesMessenger = new BMessenger(this);
				}
				catch (...) 
				{
					warning(FailMemory);
					loadSpeciesMessenger = NULL;
					return;
				}
				try 
				{
					loadSpeciesPanel = new BFilePanel(	B_OPEN_PANEL, 
														loadSpeciesMessenger, 
														NULL, 
														B_FILE_NODE, 
														false, 
														new BMessage(LOADSPECIESFROMPANEL), 
														NULL, 
														false, 
														true);
					BWindow * panelWindow = loadSpeciesPanel->Window();
					panelWindow->SetTitle(OpenSpecies);
					loadSpeciesPanel->Show();
				}
				catch (...) 
				{
					warning(FailMemory);
					loadSpeciesPanel = NULL;
					return;
				}
			}
			else 
			{
				loadSpeciesPanel->Show();
			}
		break;
		}
		case LOADSPECIESFROMPANEL:	
		{
			entry_ref ref;
			int32 numSpecies;
			if (pparamMessage->FindRef("refs", &ref) >= B_OK) 
			{
				BFile file(&ref, B_READ_ONLY);
				status_t fileStatus;
				if ((fileStatus = file.InitCheck()) == B_NO_ERROR) 
				{
					if (!StripFileHeaderPre(&file)) 
					{
						warning(noLoad);
						return;
					}
					if (!StripFileHeader(	SPECIES_TYPE, 
											&file, 
											&numSpecies)) 
					{
						warning(noLoad);
						return;
					}
					if (!(species->Load(&file))) 
					{
						warning(noLoad);
					}
					else 
					{
						speciesCurrent = species;
						mpNameStrGadget->SetText(speciesCurrent->name);
						thisDNPtr = dataListGlobal[SPECIES_TYPE]->NextPrevItems(	(void *)speciesCurrent, 
																						&nextDNPtr, 
																						&prevDNPtr, 
																						pBottomButtons);
					}
				}
				else 
				{
					warning(FailFileInitCheck);
				}
			}
			else 
			{
				warning(FailFileFindRef);
			}
		break;
		}
		case PREFSMSG:
		{
			myPrefs->OpenPreferencesPanel();
		break;
		}
		case BLREMOVE:
			dataListGlobal[SPECIES_TYPE]->Remove();
			Quit();
		break;
		case BLLIST:
			try 
			{
				BRect holdRect;
				myPrefs->GetPreferredListViewWindowRect(&holdRect);
				mpListViewWindow = new ListViewWindow(	holdRect,
														lvwts[SPECIES_TYPE],
														"ListViewView",
														"ListViewWindowFrame",
														NULL,
														dataListGlobal[SPECIES_TYPE], 
														mpNameStrGadget->Text(),
														this,
														LISTVIEWSELECTONE);
				if (err == NO_ERR)
				{
					mpListViewWindow->Initialize();
					pBottomButtons->list->SetEnabled(false);
				}
			}
			catch (...) 
			{
				warning(FailListViewWindow);
				myApp->PostMessage(B_QUIT_REQUESTED);
				throw;
			}
		break;
		case BLLISTGOT:
			if (validate) 
			{
				if (UniqueName(dataListGlobal[SPECIES_TYPE], mpNameStrGadget->Text()))
				{
					validate = false;
					if (ValidateSpecies())
					{
						if (AddSpecies()) 
						{
							validate = true;
						}
					}
				}
				else
				{
					if (strcmp(mpNameStrGadget->Text(), speciesCurrent->name))
					{
						validate = false;
						if (ValidateSpecies())
						{
							if (UpdateSpecies()) 
							{
								validate = true;
							}
						}
					}
				}
			}
			else
			{
				validate = true;
			}
			if (validate)
			{
				speciesCurrent = speciesNewCurrent;
				mpNameStrGadget->SetText(speciesCurrent->name);
				thisDNPtr = dataListGlobal[SPECIES_TYPE]->NextPrevItems(	(void *)speciesCurrent, 
																			&nextDNPtr, 
																			&prevDNPtr, 
																			pBottomButtons);
			}
			pBottomButtons->list->SetEnabled(true);
		break;
		case BLPREVIOUS:
		{
			if (validate) 
			{
				if (UniqueName(dataListGlobal[SPECIES_TYPE], mpNameStrGadget->Text()))
				{
					validate = false;
					if (ValidateSpecies())
					{
						if (AddSpecies()) 
						{
							validate = true;
						}
					}
				}
				else
				{
					if (strcmp(mpNameStrGadget->Text(), speciesCurrent->name))
					{
						validate = false;
						if (ValidateSpecies())
						{
							if (UpdateSpecies()) 
							{
								validate = true;
							}
						}
					}
				}
			}
			else
			{
				validate = true;
			}
			if (validate)
			{
				Species * prevSpecies = (Species *)((DataNode *)prevDNPtr)->data;
				speciesCurrent = prevSpecies;
				mpNameStrGadget->SetText(speciesCurrent->name);
				thisDNPtr = dataListGlobal[SPECIES_TYPE]->NextPrevItems(	(void *)speciesCurrent, 
																			&nextDNPtr, 
																			&prevDNPtr, 
																			pBottomButtons);
				if (dataListGlobal[SPECIES_TYPE]->list->CountItems() > 1) 
				{
					pBottomButtons->list->SetEnabled(true);
				}
				else
				{
					pBottomButtons->list->SetEnabled(false);
				}
			}
		break;
		}
		case BLDONE:
			if (validate) 
			{
				if (UniqueName(dataListGlobal[SPECIES_TYPE], mpNameStrGadget->Text()))
				{
					validate = false;
					if (ValidateSpecies())
					{
						if (AddSpecies()) 
						{
							validate = true;
						}
					}
				}
				else
				{
					if (strcmp(mpNameStrGadget->Text(), speciesCurrent->name))
					{
						validate = false;
						warning(WrongName);
						mpNameStrGadget->SetText(speciesCurrent->name);
					}
					else
					{
						validate = false;
						if (ValidateSpecies())
						{
							if (UpdateSpecies())
							{
								validate = true;
							}
						}
					}
				}
				if (validate)
				{
					pBottomButtons->save->SetEnabled(true);
					if (myApp->pTitleWindow->LockLooper())
					{
						myApp->pTitleWindow->pSaveButton->SetEnabled(true);
						myApp->pTitleWindow->pRealButton->SetEnabled(true);
						myApp->pTitleWindow->UnlockLooper();
					}
					else
					{
						warning(FailLockLooper);
					}
					Quit();
				}
			}
			else
			{
				Quit();
			}
		break;
		case BLNEW:
			if (validate) 
			{
				if (UniqueName(dataListGlobal[SPECIES_TYPE], mpNameStrGadget->Text()))
				{
					if (ValidateSpecies())
					{
						if (AddSpecies()) 
						{
							pBottomButtons->save->SetEnabled(true);
							if (myApp->pTitleWindow->LockLooper())
							{
								myApp->pTitleWindow->pSaveButton->SetEnabled(true);
								myApp->pTitleWindow->pRealButton->SetEnabled(true);
								myApp->pTitleWindow->UnlockLooper();
							}
							else
							{
								warning(FailLockLooper);
							}
							mpNameStrGadget->SetText("");
							mpNameStrGadget->MakeFocus();
							pBottomButtons->prev->SetEnabled(true);
							if (dataListGlobal[SPECIES_TYPE]->list->CountItems() > 1) 
							{
								pBottomButtons->list->SetEnabled(true);
							}
							else
							{
								pBottomButtons->list->SetEnabled(false);
							}
						}
					}
				}
				else
				{
					if (UpdateSpecies())
					{
						mpNameStrGadget->SetText("");
						mpNameStrGadget->MakeFocus();
						pBottomButtons->prev->SetEnabled(false);
						pBottomButtons->next->SetEnabled(false);
					}
				}
			}
		break;
		case BLADD:
			if (validate) 
			{
				if (UniqueName(dataListGlobal[SPECIES_TYPE], mpNameStrGadget->Text()))
				{
					if (ValidateSpecies())
					{
						if (AddSpecies()) 
						{
							pBottomButtons->save->SetEnabled(true);
							if (myApp->pTitleWindow->LockLooper())
							{
								myApp->pTitleWindow->pSaveButton->SetEnabled(true);
								myApp->pTitleWindow->pRealButton->SetEnabled(true);
								myApp->pTitleWindow->UnlockLooper();
							}
							else
							{
								warning(FailLockLooper);
							}
							mpNameStrGadget->SetText("");
							mpNameStrGadget->MakeFocus();
							pBottomButtons->prev->SetEnabled(false);
							pBottomButtons->gnu->SetEnabled(false);
							if (dataListGlobal[SPECIES_TYPE]->list->CountItems() > 1) 
							{
								pBottomButtons->list->SetEnabled(true);
							}
							else
							{
								pBottomButtons->list->SetEnabled(false);
							}
						}
					}
				}
				else
				{
					warning(FailNameUnique[SPECIES_TYPE]);
				}
			}
			else 
			{
				warning(everythingNamed);
			}
		break;
		case BLPICTURE:
			warning("debug no pictures yet\n");
		break;
		case BLNEXT:
		{
			if (validate) 
			{
				if (UniqueName(dataListGlobal[SPECIES_TYPE], mpNameStrGadget->Text()))
				{
					validate = false;
					if (ValidateSpecies())
					{
						if (AddSpecies()) 
						{
							validate = true;
						}
					}
				}
				else
				{
					if (strcmp(mpNameStrGadget->Text(), speciesCurrent->name))
					{
						validate = false;
						if (ValidateSpecies())
						{
							if (UpdateSpecies()) 
							{
								validate = true;
							}
						}
					}
				}
			}
			else
			{
				validate = true;
			}
			if (validate)
			{
				Species * nextSpecies = (Species *)((DataNode *)nextDNPtr)->data;
				speciesCurrent = nextSpecies;
				mpNameStrGadget->SetText(speciesCurrent->name);
				thisDNPtr = dataListGlobal[SPECIES_TYPE]->NextPrevItems(	(void *)speciesCurrent, 
																			&nextDNPtr, 
																			&prevDNPtr, 
																			pBottomButtons);
				if (dataListGlobal[SPECIES_TYPE]->list->CountItems() > 1) 
				{
					pBottomButtons->list->SetEnabled(true);
				}
				else
				{
					pBottomButtons->list->SetEnabled(false);
				}
			}
		break;
		}
		default:
			WindowGuts::MessageReceived(pparamMessage);
		break;
	}
}//end


bool
EditSpeciesWindow	::	QuitRequested(	void) 
{
	BRect frame = Frame();
	myApp->SetPreferredEditSpeciesWindowRect(frame);
	if (strcmp(mpNameStrGadget->Text(), "")) 
	{
		if (speciesCurrent) 
		{
			if (ValidateSpecies()) 
			{
				if (UpdateSpecies()) 
				{
					return(WindowGuts::QuitRequested());
				}
				else 
				{
					return false;
				}
			}
			else 
			{
				return false;
			}
		}
	}
	return(WindowGuts::QuitRequested());
}//end


bool 
EditSpeciesWindow	::	ValidateSpecies(	void) 
{
	return UniqueName(dataListGlobal[SPECIES_TYPE], mpNameStrGadget->Text());
}//end


bool 
EditSpeciesWindow	::	AddSpecies(	void) 
{
	Species * thang;
	try
	{
		thang = new Species(	species, 
								(char *)mpNameStrGadget->Text());
	}
	catch (...)
	{
		warning(FailMemory);
		return false;
	}
	if (err != CREATED)
	{
		delete thang;
		return false;
	}
	return true;
}//end


bool 
EditSpeciesWindow	::	UpdateSpecies(	void) 
{
	if (speciesCurrent) 
	{
		if (!speciesCurrent->Copy(species))
		{
			return false;
		}
		return true;
	}
	return false;
}//end
