//functions of EditSpeciesWindow soi0.1

#include "windowGuts.h"
#include "editSpeciesWindow.h"
#include "getFromList.h"
#include "saveLoadUniverse.h"
#include "titleWindow.h"
#include "designButtons.h"

void EditSpeciesWindow::SaveRequested(const char * fileName) 
{

SaveSpeciess(fileName);
}//end


EditSpeciesWindow::EditSpeciesWindow(BRect area, const char *title) : BWindow(area, title, B_TITLED_WINDOW, B_NOT_RESIZABLE|B_NOT_ZOOMABLE) 
{

nameStrGadget = NULL;
editSpeciesWindow = this;
bb = new BottomButtons;
if (bb) 
{
	if (editUniverseWindow) 
	{
		editUniverseWindow->Lock();
		editUniverseWindow->buttons[DSN_SPECIES]->SetEnabled(false);
		editUniverseWindow->Unlock();
	}
}
else err = CREATEDNOTADDED;
if (!speciesCurrent) if (dataListGlobal[SPECIES_TYPE]->list->CountItems()) speciesCurrent = (Species *)((DataNode *)dataListGlobal[SPECIES_TYPE]->list->ItemAt(0))->data;
}//end


EditSpeciesWindow::~EditSpeciesWindow() 
{

if (nameStrGadget) delete nameStrGadget;
if (bb) 
{
	if (editUniverseWindow) 
	{
		editUniverseWindow->Lock();
		editUniverseWindow->buttons[DSN_SPECIES]->SetEnabled(true);
		editUniverseWindow->Unlock();
	}
	delete bb;
}
editSpeciesWindow = NULL;
}//end


void EditSpeciesWindow::AddSpecies(void) 
{

Species * s = new Species(species, editSpeciesWindow->nameStrGadget->Text(), dataListGlobal[SPECIES_TYPE]);
if (s) 
{
	if (err != CREATED) 
	{
		delete s;
		return;
	}
}
else err = NO_SPECIES;
}//end


void EditSpeciesWindow::MessageReceived(BMessage *message) 
{

bool validate = true;
if (!strcmp(editSpeciesWindow->nameStrGadget->Text(), "")) validate = false;

switch (message->what) 
{
	case SOI_NAME:
	
	break;
	case SOI_BLREMOVE:
		dataListGlobal[SPECIES_TYPE]->Remove();
		Quit();
	break;
	case SOI_BLLIST:
		((void *)editSpeciesWindow, dataListGlobal[SPECIES_TYPE], editSpeciesWindow->nameStrGadget->Text());
	break;
	case SOI_BLLISTGOT:
		if (validate) ValidateSpecies();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdateSpecies();
			speciesCurrent = speciesNewCurrent;
			editSpeciesWindow->nameStrGadget->SetText(speciesCurrent->name);
			thisDNPtr = dataListGlobal[SPECIES_TYPE]->NextPrevItems((void *)speciesCurrent, &nextDNPtr, &prevDNPtr, bb);
			if (!bb->gnu) 
			{
				BRect gnuRect(154,bottom, 189,34);
				bb->gnu = new BButton(gnuRect, "", newStr, new BMessage(SOI_BLGNU));
				if (!bb->gnu) 
				{
					warning(failMemory);
					return;
				}
				AddChild(bb->gnu);
				bb->gnu->SetTarget(this);
				bb->add->SetLabel(removeStr);
				bb->add->SetMessage(new BMessage(SOI_BLREMOVE));
			}
		}
	break;
	case SOI_BLPREV:
		Species * prevSpecies = (Species *)((DataNode *)prevDNPtr)->data;
		if (validate) ValidateSpecies();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdateSpecies();
			speciesCurrent = prevSpecies;
			editSpeciesWindow->nameStrGadget->SetText(speciesCurrent->name);
			thisDNPtr = dataListGlobal[SPECIES_TYPE]->NextPrevItems((void *)speciesCurrent, &nextDNPtr, &prevDNPtr, bb);
		}
	break;
	case SOI_BLDONE:
		if (!validate) 
		{
			Quit();
		}
		if (!strcmp(removeStr, bb->add->Label())) 
		{
			ValidateSpecies();
			if (err == NO_ERR) 
			{
				UpdateSpecies();
			}
		}
		if (err == NO_ERR) 
		{
			Quit();
		}
	break;
	case SOI_BLGNU:
		if (validate) ValidateSpecies();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdateSpecies();
			speciesCurrent = NULL;
			RemoveChild(bb->gnu);
			delete bb->gnu;
			bb->gnu = NULL;
			bb->add->SetLabel(addStr);
			bb->add->SetMessage(new BMessage(SOI_BLADD));
			editSpeciesWindow->nameStrGadget->SetText("");
			editSpeciesWindow->nameStrGadget->MakeFocus();
		}
	break;
	case SOI_BLADD:
		if (validate) ValidateSpecies();
		else {
			err = NO_NAME;
			warning(everythingNamed);
		}//for add don't update
		if (err == NO_ERR) 
		{
			AddSpecies();
			if (err) 
			{
				if (err != CREATEDNOTADDED) 
				{
					Quit();
				}
			}
			else {
				if (editUniverseWindow) 
				{
					editUniverseWindow->Lock();
					editUniverseWindow->buttons[DSN_SPECIES]->SetLabel(editThe[SPECIES_TYPE]);
					editUniverseWindow->bb->save->SetEnabled(true);
					editUniverseWindow->Unlock();
				}
				editSpeciesWindow->nameStrGadget->SetText("");
				editSpeciesWindow->nameStrGadget->MakeFocus();
				bb->save->SetEnabled(true);
				if (openingWindow) 
				{
					openingWindow->Lock();
					openingWindow->universeButton->SetLabel(editThe[UNIVERSE_TYPE]);
					openingWindow->createUniverseButton->SetEnabled(true);
					openingWindow->realUniverseButton->SetEnabled(true);
					openingWindow->Unlock();
				}
			}
		}
	break;
	case SOI_BLSAVE:
		if (validate) ValidateSpecies();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdateSpecies();
			//RunSavePanel("universe", saveThe[UNIVERSE_TYPE], saveStr, cancelStr);
		}
	break;
	case SOI_BLPIC:
	
	break;
	case SOI_LOADUNIVERSEFROMPANEL:
		LoadSpeciess("universe");//debug
		Quit();
	break;
	case SOI_BLLOAD:
		BMessage * bm = new BMessage(SOI_LOADUNIVERSEFROMPANEL);
		if (bm) break;//debug break;//debug be_app->RunFilePanel(loadThe[UNIVERSE_TYPE], loadStr, cancelStr, false, bm);
		else warning(failMemory);
	break;
	case SOI_BLNEXT:
		Species * nextSpecies = (Species *)((DataNode *)nextDNPtr)->data;
		if (validate) ValidateSpecies();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdateSpecies();
			speciesCurrent = nextSpecies;
			editSpeciesWindow->nameStrGadget->SetText(speciesCurrent->name);
			thisDNPtr = dataListGlobal[SPECIES_TYPE]->NextPrevItems((void *)speciesCurrent, &nextDNPtr, &prevDNPtr, bb);
		}
	break;
	default:
		BWindow::MessageReceived(message);
	break;
}
}//end


bool EditSpeciesWindow::QuitRequested(void) 
{

if (strcmp(editSpeciesWindow->nameStrGadget->Text(), "")) 
{
	if (speciesCurrent) 
	{
		ValidateSpecies();
		if (err == NO_ERR) 
		{
			UpdateSpecies();
			if (err == NO_ERR) 
			{
				Quit();
				return(BWindow::QuitRequested());
			}
			else return false;
		}
		else return false;
	}
}
Quit();
return(BWindow::QuitRequested());
}//end


void EditSpeciesWindow::ValidateSpecies(void) 
{

UniqueName(dataListGlobal[SPECIES_TYPE], editSpeciesWindow->nameStrGadget->Text());
if (NO_UNIQUE == err) 
{
	warning(failNameUnique[SPECIES_TYPE]);
	return;
}
if (species->name) 
{
	if (strcmp(species->name, editSpeciesWindow->nameStrGadget->Text())) 
	{
		free(species->name);
		species->name = (char *)malloc(strlen(editSpeciesWindow->nameStrGadget->Text()) + 1);
		if (species->name) strcpy(species->name, editSpeciesWindow->nameStrGadget->Text());
		else {
			err = NO_NAME;
			warning(failName);
		}
	}
}
//debug must do object as well
}//end


void EditSpeciesWindow::UpdateSpecies(void) 
{

err = NO_ERR;
if (speciesCurrent) 
{
	if (strcmp(speciesCurrent->name, editSpeciesWindow->nameStrGadget->Text())) 
	{
		if (speciesCurrent->name) free(speciesCurrent->name);
		speciesCurrent->name = (char *)malloc(strlen(editSpeciesWindow->nameStrGadget->Text()) + 1);
		if (speciesCurrent->name) strcpy(speciesCurrent->name, editSpeciesWindow->nameStrGadget->Text());
		else {
			err = NO_NAME;
			warning(failName);
		}
	}
	//debug must do object as well
}
}//end


void EditSpeciesWindow::SaveSpeciess(const char * fileName) 
{

SaveUniverse(fileName);
}//end


void EditSpeciesWindow::LoadSpeciess(const char * fileName) 
{

LoadUniverse(fileName);
}//end
