//functions of EditShipWeaponWindow soi0.1

#include "windowGuts.h"
#include "editShipWeaponWindow.h"
#include "def.h"
#include "s2f.h"
#include "showSomeThings.h"
#include "getSomeThings.h"
#include "getFromList.h"
#include "saveLoadUniverse.h"
#include "titleWindow.h"
#include "designButtons.h"

void EditShipWeaponWindow::SaveRequested(const char * fileName) 
{

SaveShipWeapons(fileName);
}//end


EditShipWeaponWindow::EditShipWeaponWindow(BRect area, const char *title) : BWindow(area, title, B_TITLED_WINDOW, B_NOT_RESIZABLE|B_NOT_ZOOMABLE) 
{

err = NO_ERR;
orderButton = NULL;
kindButton = NULL;
defaultStrengthGadget = NULL;
bb = new BottomButtons;
if (bb) 
{
	if (editUniverseWindow) 
	{
		editUniverseWindow->Lock();
		editUniverseWindow->buttons[DSN_SHIPWEAPON]->SetEnabled(false);
		editUniverseWindow->Unlock();
	}
	db = new DoableButtons();
	if (db) 
	{
		maint = new DoableButtons();
		if (maint) 
		{
			scg = new SmallConstantsGadgets();
			if (scg) 
			{
				bld = new DoableButtons();
				if (!bld) err = CREATEDNOTADDED;
			}
			else err = CREATEDNOTADDED;
		}
		else err = CREATEDNOTADDED;
	}
	else err = CREATEDNOTADDED;
}
else err = CREATEDNOTADDED;
editShipWeaponWindow = this;
if (!shipWeaponCurrent) if (dataListGlobal[SHIPWEAPON_TYPE]->list->CountItems()) shipWeaponCurrent = (ShipWeapon *)((DataNode *)dataListGlobal[SHIPWEAPON_TYPE]->list->ItemAt(0))->data;
}//end


EditShipWeaponWindow::~EditShipWeaponWindow() 
{

if (bb) 
{
	if (editUniverseWindow) 
	{
		editUniverseWindow->Lock();
		editUniverseWindow->buttons[DSN_SHIPWEAPON]->SetEnabled(true);
		editUniverseWindow->Unlock();
	}
	delete bb;
}
if (defaultStrengthGadget) 
{
	defaultStrengthGadget->RemoveSelf();
	delete defaultStrengthGadget;
}
if (bld) delete bld;
if (db) delete db;
if (maint) delete maint;
if (scg) delete scg;
if (orderButton) 
{
	orderButton->RemoveSelf();
	delete orderButton;
}
if (kindButton) 
{
	kindButton->RemoveSelf();
	delete kindButton;
}
editShipWeaponWindow = NULL;
}//end


void EditShipWeaponWindow::AddShipWeapon(void) 
{

ShipWeapon * item = new ShipWeapon(shipWeapon, scg->nameStrGadget->Text(), dataListGlobal[SHIPWEAPON_TYPE]);
if (item) 
{
	if (err != CREATED) 
	{
		delete item;
		return;
	}
}
else err = NO_SHIPWEAPON;
}//end


void EditShipWeaponWindow::MessageReceived(BMessage *message) 
{

bool validate = true;
int32 shipWeaponSize = sizeof shipWeaponCurrent;
if (!strcmp(scg->nameStrGadget->Text(), "")) validate = false;

switch (message->what) 
{
	case SOI_NAME:
	case SOI_VOLUME:
	case SOI_VPER:
	
	break;
	case SOI_MAINTAINABLEBUTTONLABEL:
		if (maint->showing) 
		{
			maint->label->SetLabel(selectMaintValue);
			maint->showing = false;
		}
		else {
			maint->label->SetLabel(showMaintValue);
			maint->showing = true;
		}
		maint->ResetMsg(message->what);
	break;
	case SOI_BUILDABLEBUTTONLABEL:
		if (bld->showing) 
		{
			bld->label->SetLabel(selectProdValue);
			bld->showing = false;
		}
		else {
			bld->label->SetLabel(showProdValue);
			bld->showing = true;
		}
		bld->ResetMsg(message->what);
	break;
	case SOI_DOABLEBUTTONLABEL:
		if (db->showing) 
		{
			db->label->SetLabel(selectConsumeValue);
			db->showing = false;
		}
		else {
			db->label->SetLabel(showConsumeValue);
			db->showing = true;
		}
		db->ResetMsg(message->what);
	break;
	case SOI_GETPOSSORDERS:
	
	break;
	case SOI_BUILDABLEBUTTONPRIMALELEMENTS:
		GetSomeThings(shipWeapon->buildable->elementPrimal->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[ELEMENT_TYPE], SHIPWEAPON_TYPE);
	break;
	case SOI_BUILDABLEBUTTONPRIMALCOMPOUNDS:
		GetSomeThings(shipWeapon->buildable->compoundPrimal->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[COMPOUND_TYPE], SHIPWEAPON_TYPE);
	break;
	case SOI_BUILDABLEBUTTONELEMENTS:
		GetSomeThings(shipWeapon->buildable->elementManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[ELEMENT_TYPE], SHIPWEAPON_TYPE);
	break;
	case SOI_BUILDABLEBUTTONCOMPOUNDS:
		GetSomeThings(shipWeapon->buildable->compoundManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[COMPOUND_TYPE], SHIPWEAPON_TYPE);
	break;
	case SOI_BUILDABLEBUTTONMINES:
		GetSomeThings(shipWeapon->buildable->mineManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[MINE_TYPE], SHIPWEAPON_TYPE);
	break;
	case SOI_BUILDABLEBUTTONFACTORYS:
		GetSomeThings(shipWeapon->buildable->factoryManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[FACTORY_TYPE], SHIPWEAPON_TYPE);
	break;
	case SOI_BUILDABLEBUTTONENGINES:
		GetSomeThings(shipWeapon->buildable->engineManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[ENGINE_TYPE], SHIPWEAPON_TYPE);
	break;
	case SOI_BUILDABLEBUTTONSHIPS:
		GetSomeThings(shipWeapon->buildable->shipManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[SHIP_TYPE], SHIPWEAPON_TYPE);
	break;
	case SOI_BUILDABLEBUTTONSSHIELDS:
		GetSomeThings(shipWeapon->buildable->shipShieldManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[SSHIELD_TYPE], SHIPWEAPON_TYPE);
	break;
	case SOI_BUILDABLEBUTTONSHIPWEAPONS:
		GetSomeThings(shipWeapon->buildable->shipWeaponManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[SHIPWEAPON_TYPE], SHIPWEAPON_TYPE);
	break;
	case SOI_BUILDABLEBUTTONPLANETSHIELDS:
		GetSomeThings(shipWeapon->buildable->planetShieldManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[PLANETSHIELD_TYPE], SHIPWEAPON_TYPE);
	break;
	case SOI_BUILDABLEBUTTONPLANETWEAPONS:
		GetSomeThings(shipWeapon->buildable->planetWeaponManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[PLANETWEAPON_TYPE], SHIPWEAPON_TYPE);
	break;
	case SOI_DOABLEBUTTONPRIMALELEMENTS:
		GetSomeThings(shipWeapon->doable->elementPrimal->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[ELEMENT_TYPE], SHIPWEAPON_TYPE);
	break;
	case SOI_DOABLEBUTTONPRIMALCOMPOUNDS:
		GetSomeThings(shipWeapon->doable->compoundPrimal->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[COMPOUND_TYPE], SHIPWEAPON_TYPE);
	break;
	case SOI_DOABLEBUTTONELEMENTS:
		GetSomeThings(shipWeapon->doable->elementManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[ELEMENT_TYPE], SHIPWEAPON_TYPE);
	break;
	case SOI_DOABLEBUTTONCOMPOUNDS:
		GetSomeThings(shipWeapon->doable->compoundManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[COMPOUND_TYPE], SHIPWEAPON_TYPE);
	break;
	case SOI_DOABLEBUTTONMINES:
		GetSomeThings(shipWeapon->doable->mineManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[MINE_TYPE], SHIPWEAPON_TYPE);
	break;
	case SOI_DOABLEBUTTONFACTORYS:
		GetSomeThings(shipWeapon->doable->factoryManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[FACTORY_TYPE], SHIPWEAPON_TYPE);
	break;
	case SOI_DOABLEBUTTONENGINES:
		GetSomeThings(shipWeapon->doable->engineManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[ENGINE_TYPE], SHIPWEAPON_TYPE);
	break;
	case SOI_DOABLEBUTTONSHIPS:
		GetSomeThings(shipWeapon->doable->shipManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[SHIP_TYPE], SHIPWEAPON_TYPE);
	break;
	case SOI_DOABLEBUTTONSSHIELDS:
		GetSomeThings(shipWeapon->doable->shipShieldManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[SSHIELD_TYPE], SHIPWEAPON_TYPE);
	break;
	case SOI_DOABLEBUTTONSHIPWEAPONS:
		GetSomeThings(shipWeapon->doable->shipWeaponManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[SHIPWEAPON_TYPE], SHIPWEAPON_TYPE);
	break;
	case SOI_DOABLEBUTTONPLANETSHIELDS:
		GetSomeThings(shipWeapon->doable->planetShieldManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[PLANETSHIELD_TYPE], SHIPWEAPON_TYPE);
	break;
	case SOI_DOABLEBUTTONPLANETWEAPONS:
		GetSomeThings(shipWeapon->doable->planetWeaponManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[PLANETWEAPON_TYPE], SHIPWEAPON_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONPRIMALELEMENTS:
		GetSomeThings(shipWeapon->maintainable->elementPrimal->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[ELEMENT_TYPE], SHIPWEAPON_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONPRIMALCOMPOUNDS:
		GetSomeThings(shipWeapon->maintainable->compoundPrimal->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[COMPOUND_TYPE], SHIPWEAPON_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONELEMENTS:
		GetSomeThings(shipWeapon->maintainable->elementManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[ELEMENT_TYPE], SHIPWEAPON_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONCOMPOUNDS:
		GetSomeThings(shipWeapon->maintainable->compoundManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[COMPOUND_TYPE], SHIPWEAPON_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONMINES:
		GetSomeThings(shipWeapon->maintainable->mineManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[MINE_TYPE], SHIPWEAPON_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONFACTORYS:
		GetSomeThings(shipWeapon->maintainable->factoryManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[FACTORY_TYPE], SHIPWEAPON_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONENGINES:
		GetSomeThings(shipWeapon->maintainable->engineManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[ENGINE_TYPE], SHIPWEAPON_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONSHIPS:
		GetSomeThings(shipWeapon->maintainable->shipManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[SHIP_TYPE], SHIPWEAPON_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONSSHIELDS:
		GetSomeThings(shipWeapon->maintainable->shipShieldManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[SSHIELD_TYPE], SHIPWEAPON_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONSHIPWEAPONS:
		GetSomeThings(shipWeapon->maintainable->shipWeaponManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[SHIPWEAPON_TYPE], SHIPWEAPON_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONPLANETSHIELDS:
		GetSomeThings(shipWeapon->maintainable->planetShieldManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[PLANETSHIELD_TYPE], SHIPWEAPON_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONPLANETWEAPONS:
		GetSomeThings(shipWeapon->maintainable->planetWeaponManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[PLANETWEAPON_TYPE], SHIPWEAPON_TYPE);
	break;
	case SOI_SHOWBUILDPRIMALELEMENTS:
		ShowSomeThings((const void *)&shipWeapon, shipWeaponSize, shipWeaponCurrent->name, SHIPWEAPON_TYPE, shipWeapon->buildable->elementPrimal, scg->nameStrGadget->Text(), editShipWeaponWindow, dataListGlobal[ELEMENT_TYPE]);
	break;
	case SOI_SHOWBUILDPRIMALCOMPOUNDS:
		ShowSomeThings((const void *)&shipWeapon, shipWeaponSize, shipWeaponCurrent->name, SHIPWEAPON_TYPE, shipWeapon->buildable->compoundPrimal, scg->nameStrGadget->Text(), editShipWeaponWindow, dataListGlobal[COMPOUND_TYPE]);
	break;
	case SOI_SHOWBUILDELEMENTS:
		ShowSomeThings((const void *)&shipWeapon, shipWeaponSize, shipWeaponCurrent->name, SHIPWEAPON_TYPE, shipWeapon->buildable->elementManufactured, scg->nameStrGadget->Text(), editShipWeaponWindow, dataListGlobal[ELEMENT_TYPE]);
	break;
	case SOI_SHOWBUILDCOMPOUNDS:
		ShowSomeThings((const void *)&shipWeapon, shipWeaponSize, shipWeaponCurrent->name, SHIPWEAPON_TYPE, shipWeapon->buildable->compoundManufactured, scg->nameStrGadget->Text(), editShipWeaponWindow, dataListGlobal[COMPOUND_TYPE]);
	break;
	case SOI_SHOWBUILDMINES:
		ShowSomeThings((const void *)&shipWeapon, shipWeaponSize, shipWeaponCurrent->name, SHIPWEAPON_TYPE, shipWeapon->buildable->mineManufactured, scg->nameStrGadget->Text(), editShipWeaponWindow, dataListGlobal[MINE_TYPE]);
	break;
	case SOI_SHOWBUILDFACTORYS:
		ShowSomeThings((const void *)&shipWeapon, shipWeaponSize, shipWeaponCurrent->name, SHIPWEAPON_TYPE, shipWeapon->buildable->factoryManufactured, scg->nameStrGadget->Text(), editShipWeaponWindow, dataListGlobal[FACTORY_TYPE]);
	break;
	case SOI_SHOWBUILDENGINES:
		ShowSomeThings((const void *)&shipWeapon, shipWeaponSize, shipWeaponCurrent->name, SHIPWEAPON_TYPE, shipWeapon->buildable->engineManufactured, scg->nameStrGadget->Text(), editShipWeaponWindow, dataListGlobal[ENGINE_TYPE]);
	break;
	case SOI_SHOWBUILDSHIPS:
		ShowSomeThings((const void *)&shipWeapon, shipWeaponSize, shipWeaponCurrent->name, SHIPWEAPON_TYPE, shipWeapon->buildable->shipManufactured, scg->nameStrGadget->Text(), editShipWeaponWindow, dataListGlobal[SHIP_TYPE]);
	break;
	case SOI_SHOWBUILDSSHIELDS:
		ShowSomeThings((const void *)&shipWeapon, shipWeaponSize, shipWeaponCurrent->name, SHIPWEAPON_TYPE, shipWeapon->buildable->shipShieldManufactured, scg->nameStrGadget->Text(), editShipWeaponWindow, dataListGlobal[SSHIELD_TYPE]);
	break;
	case SOI_SHOWBUILDSHIPWEAPONS:
		ShowSomeThings((const void *)&shipWeapon, shipWeaponSize, shipWeaponCurrent->name, SHIPWEAPON_TYPE, shipWeapon->buildable->shipWeaponManufactured, scg->nameStrGadget->Text(), editShipWeaponWindow, dataListGlobal[SHIPWEAPON_TYPE]);
	break;
	case SOI_SHOWBUILDPLANETSHIELDS:
		ShowSomeThings((const void *)&shipWeapon, shipWeaponSize, shipWeaponCurrent->name, SHIPWEAPON_TYPE, shipWeapon->buildable->planetShieldManufactured, scg->nameStrGadget->Text(), editShipWeaponWindow, dataListGlobal[PLANETSHIELD_TYPE]);
	break;
	case SOI_SHOWBUILDPLANETWEAPONS:
		ShowSomeThings((const void *)&shipWeapon, shipWeaponSize, shipWeaponCurrent->name, SHIPWEAPON_TYPE, shipWeapon->buildable->planetWeaponManufactured, scg->nameStrGadget->Text(), editShipWeaponWindow, dataListGlobal[PLANETWEAPON_TYPE]);
	break;
	case SOI_SHOWDOPRIMALELEMENTS:
		ShowSomeThings((const void *)&shipWeapon, shipWeaponSize, shipWeaponCurrent->name, SHIPWEAPON_TYPE, shipWeapon->doable->elementPrimal, scg->nameStrGadget->Text(), editShipWeaponWindow, dataListGlobal[ELEMENT_TYPE]);
	break;
	case SOI_SHOWDOPRIMALCOMPOUNDS:
		ShowSomeThings((const void *)&shipWeapon, shipWeaponSize, shipWeaponCurrent->name, SHIPWEAPON_TYPE, shipWeapon->doable->compoundPrimal, scg->nameStrGadget->Text(), editShipWeaponWindow, dataListGlobal[COMPOUND_TYPE]);
	break;
	case SOI_SHOWDOELEMENTS:
		ShowSomeThings((const void *)&shipWeapon, shipWeaponSize, shipWeaponCurrent->name, SHIPWEAPON_TYPE, shipWeapon->doable->elementManufactured, scg->nameStrGadget->Text(), editShipWeaponWindow, dataListGlobal[ELEMENT_TYPE]);
	break;
	case SOI_SHOWDOCOMPOUNDS:
		ShowSomeThings((const void *)&shipWeapon, shipWeaponSize, shipWeaponCurrent->name, SHIPWEAPON_TYPE, shipWeapon->doable->compoundManufactured, scg->nameStrGadget->Text(), editShipWeaponWindow, dataListGlobal[COMPOUND_TYPE]);
	break;
	case SOI_SHOWDOMINES:
		ShowSomeThings((const void *)&shipWeapon, shipWeaponSize, shipWeaponCurrent->name, SHIPWEAPON_TYPE, shipWeapon->doable->mineManufactured, scg->nameStrGadget->Text(), editShipWeaponWindow, dataListGlobal[MINE_TYPE]);
	break;
	case SOI_SHOWDOFACTORYS:
		ShowSomeThings((const void *)&shipWeapon, shipWeaponSize, shipWeaponCurrent->name, SHIPWEAPON_TYPE, shipWeapon->doable->factoryManufactured, scg->nameStrGadget->Text(), editShipWeaponWindow, dataListGlobal[FACTORY_TYPE]);
	break;
	case SOI_SHOWDOENGINES:
		ShowSomeThings((const void *)&shipWeapon, shipWeaponSize, shipWeaponCurrent->name, SHIPWEAPON_TYPE, shipWeapon->doable->engineManufactured, scg->nameStrGadget->Text(), editShipWeaponWindow, dataListGlobal[ENGINE_TYPE]);
	break;
	case SOI_SHOWDOSHIPS:
		ShowSomeThings((const void *)&shipWeapon, shipWeaponSize, shipWeaponCurrent->name, SHIPWEAPON_TYPE, shipWeapon->doable->shipManufactured, scg->nameStrGadget->Text(), editShipWeaponWindow, dataListGlobal[SHIP_TYPE]);
	break;
	case SOI_SHOWDOSSHIELDS:
		ShowSomeThings((const void *)&shipWeapon, shipWeaponSize, shipWeaponCurrent->name, SHIPWEAPON_TYPE, shipWeapon->doable->shipShieldManufactured, scg->nameStrGadget->Text(), editShipWeaponWindow, dataListGlobal[SSHIELD_TYPE]);
	break;
	case SOI_SHOWDOSHIPWEAPONS:
		ShowSomeThings((const void *)&shipWeapon, shipWeaponSize, shipWeaponCurrent->name, SHIPWEAPON_TYPE, shipWeapon->doable->shipWeaponManufactured, scg->nameStrGadget->Text(), editShipWeaponWindow, dataListGlobal[SHIPWEAPON_TYPE]);
	break;
	case SOI_SHOWDOPLANETSHIELDS:
		ShowSomeThings((const void *)&shipWeapon, shipWeaponSize, shipWeaponCurrent->name, SHIPWEAPON_TYPE, shipWeapon->doable->planetShieldManufactured, scg->nameStrGadget->Text(), editShipWeaponWindow, dataListGlobal[PLANETSHIELD_TYPE]);
	break;
	case SOI_SHOWDOPLANETWEAPONS:
		ShowSomeThings((const void *)&shipWeapon, shipWeaponSize, shipWeaponCurrent->name, SHIPWEAPON_TYPE, shipWeapon->doable->planetWeaponManufactured, scg->nameStrGadget->Text(), editShipWeaponWindow, dataListGlobal[PLANETWEAPON_TYPE]);
	break;
	case SOI_SHOWMAINTPRIMALELEMENTS:
		ShowSomeThings((const void *)&shipWeapon, shipWeaponSize, shipWeaponCurrent->name, SHIPWEAPON_TYPE, shipWeapon->maintainable->elementPrimal, scg->nameStrGadget->Text(), editShipWeaponWindow, dataListGlobal[ELEMENT_TYPE]);
	break;
	case SOI_SHOWMAINTPRIMALCOMPOUNDS:
		ShowSomeThings((const void *)&shipWeapon, shipWeaponSize, shipWeaponCurrent->name, SHIPWEAPON_TYPE, shipWeapon->maintainable->compoundPrimal, scg->nameStrGadget->Text(), editShipWeaponWindow, dataListGlobal[COMPOUND_TYPE]);
	break;
	case SOI_SHOWMAINTELEMENTS:
		ShowSomeThings((const void *)&shipWeapon, shipWeaponSize, shipWeaponCurrent->name, SHIPWEAPON_TYPE, shipWeapon->maintainable->elementManufactured, scg->nameStrGadget->Text(), editShipWeaponWindow, dataListGlobal[ELEMENT_TYPE]);
	break;
	case SOI_SHOWMAINTCOMPOUNDS:
		ShowSomeThings((const void *)&shipWeapon, shipWeaponSize, shipWeaponCurrent->name, SHIPWEAPON_TYPE, shipWeapon->maintainable->compoundManufactured, scg->nameStrGadget->Text(), editShipWeaponWindow, dataListGlobal[COMPOUND_TYPE]);
	break;
	case SOI_SHOWMAINTMINES:
		ShowSomeThings((const void *)&shipWeapon, shipWeaponSize, shipWeaponCurrent->name, SHIPWEAPON_TYPE, shipWeapon->maintainable->mineManufactured, scg->nameStrGadget->Text(), editShipWeaponWindow, dataListGlobal[MINE_TYPE]);
	break;
	case SOI_SHOWMAINTFACTORYS:
		ShowSomeThings((const void *)&shipWeapon, shipWeaponSize, shipWeaponCurrent->name, SHIPWEAPON_TYPE, shipWeapon->maintainable->factoryManufactured, scg->nameStrGadget->Text(), editShipWeaponWindow, dataListGlobal[FACTORY_TYPE]);
	break;
	case SOI_SHOWMAINTENGINES:
		ShowSomeThings((const void *)&shipWeapon, shipWeaponSize, shipWeaponCurrent->name, SHIPWEAPON_TYPE, shipWeapon->maintainable->engineManufactured, scg->nameStrGadget->Text(), editShipWeaponWindow, dataListGlobal[ENGINE_TYPE]);
	break;
	case SOI_SHOWMAINTSHIPS:
		ShowSomeThings((const void *)&shipWeapon, shipWeaponSize, shipWeaponCurrent->name, SHIPWEAPON_TYPE, shipWeapon->maintainable->shipManufactured, scg->nameStrGadget->Text(), editShipWeaponWindow, dataListGlobal[SHIP_TYPE]);
	break;
	case SOI_SHOWMAINTSSHIELDS:
		ShowSomeThings((const void *)&shipWeapon, shipWeaponSize, shipWeaponCurrent->name, SHIPWEAPON_TYPE, shipWeapon->maintainable->shipShieldManufactured, scg->nameStrGadget->Text(), editShipWeaponWindow, dataListGlobal[SSHIELD_TYPE]);
	break;
	case SOI_SHOWMAINTSHIPWEAPONS:
		ShowSomeThings((const void *)&shipWeapon, shipWeaponSize, shipWeaponCurrent->name, SHIPWEAPON_TYPE, shipWeapon->maintainable->shipWeaponManufactured, scg->nameStrGadget->Text(), editShipWeaponWindow, dataListGlobal[SHIPWEAPON_TYPE]);
	break;
	case SOI_SHOWMAINTPLANETSHIELDS:
		ShowSomeThings((const void *)&shipWeapon, shipWeaponSize, shipWeaponCurrent->name, SHIPWEAPON_TYPE, shipWeapon->maintainable->planetShieldManufactured, scg->nameStrGadget->Text(), editShipWeaponWindow, dataListGlobal[PLANETSHIELD_TYPE]);
	break;
	case SOI_SHOWMAINTPLANETWEAPONS:
		ShowSomeThings((const void *)&shipWeapon, shipWeaponSize, shipWeaponCurrent->name, SHIPWEAPON_TYPE, shipWeapon->maintainable->planetWeaponManufactured, scg->nameStrGadget->Text(), editShipWeaponWindow, dataListGlobal[PLANETWEAPON_TYPE]);
	break;
	case SOI_BLREMOVE:
		dataListGlobal[SHIPWEAPON_TYPE]->Remove();
		Quit();
	break;
	case SOI_BLLIST:
		GetFromList((void *)editShipWeaponWindow, dataListGlobal[SHIPWEAPON_TYPE], scg->nameStrGadget->Text());
	break;
	case SOI_BLLISTGOT:
		if (validate) ValidateShipWeapon();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdateShipWeapon();
			shipWeaponCurrent = shipWeaponNewCurrent;
			shipWeapon->Copy(shipWeaponCurrent);
			scg->nameStrGadget->SetText(shipWeaponCurrent->name);
			thisDNPtr = dataListGlobal[SHIPWEAPON_TYPE]->NextPrevItems((void *)shipWeaponCurrent, &nextDNPtr, &prevDNPtr, bb);
			if (!bb->gnu) 
			{
				BRect gnuRect(154,bottom, 189,34);
				bb->gnu = new BButton(gnuRect, "", newStr, new BMessage(SOI_BLGNU));
				AddChild(bb->gnu);
				bb->gnu->SetTarget(this);
				bb->add->SetLabel(removeStr);
				bb->add->SetMessage(new BMessage(SOI_BLREMOVE));
			}
		}
	break;
	case SOI_BLPREV:
		ShipWeapon * prevShipWeapon = (ShipWeapon *)((DataNode *)prevDNPtr)->data;
		if (validate) ValidateShipWeapon();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdateShipWeapon();
			shipWeaponCurrent = prevShipWeapon;
			shipWeapon->Copy(shipWeaponCurrent);
			scg->nameStrGadget->SetText(shipWeaponCurrent->name);
			thisDNPtr = dataListGlobal[SHIPWEAPON_TYPE]->NextPrevItems((void *)shipWeaponCurrent, &nextDNPtr, &prevDNPtr, bb);
		}
	break;
	case SOI_BLDONE:
		if (!validate) 
		{
			Quit();
		}
		if (!strcmp(removeStr, bb->add->Label())) 
		{
			ValidateShipWeapon();
			if (err == NO_ERR) 
			{
				UpdateShipWeapon();
			}
		}
		if (err == NO_ERR) 
		{
			Quit();
		}
	break;
	case SOI_BLGNU:
		if (validate) ValidateShipWeapon();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdateShipWeapon();
			shipWeaponCurrent = NULL;
			RemoveChild(bb->gnu);
			delete bb->gnu;
			bb->gnu = NULL;
			bb->add->SetLabel(addStr);
			bb->add->SetMessage(new BMessage(SOI_BLADD));
			scg->nameStrGadget->SetText("");
			scg->nameStrGadget->MakeFocus();
		}
	break;
	case SOI_BLADD:
		if (validate) ValidateShipWeapon();
		else {
			err = NO_NAME;
			warning(everythingNamed);
		}//for add don't update
		if (err == NO_ERR) 
		{
			AddShipWeapon();
			if (err) 
			{
				if (err != CREATEDNOTADDED) 
				{
					Quit();
				}
			}
			else {
				if (editUniverseWindow) 
				{
					editUniverseWindow->Lock();
					editUniverseWindow->buttons[DSN_SHIPWEAPON]->SetLabel(editThe[SHIPWEAPON_TYPE]);
					editUniverseWindow->bb->save->SetEnabled(true);
					editUniverseWindow->Unlock();
				}
				scg->nameStrGadget->SetText("");
				scg->nameStrGadget->MakeFocus();
				bb->save->SetEnabled(true);
				if (openingWindow) 
				{
					openingWindow->Lock();
					openingWindow->universeButton->SetLabel(editThe[UNIVERSE_TYPE]);
					openingWindow->createUniverseButton->SetEnabled(true);
					openingWindow->realUniverseButton->SetEnabled(true);
					openingWindow->Unlock();
				}
				shipWeapon->maintainable->EmptyList();
				shipWeapon->buildable->EmptyList();
				shipWeapon->doable->EmptyList();
			}
		}
	break;
	case SOI_BLSAVE:
		if (validate) ValidateShipWeapon();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdateShipWeapon();
			//RunSavePanel("universe", saveThe[UNIVERSE_TYPE], saveStr, cancelStr);
		}
	break;
	case SOI_BLPIC:
	
	break;
	case SOI_LOADUNIVERSEFROMPANEL:
		LoadShipWeapons("universe");//debug
		Quit();
	break;
	case SOI_BLLOAD:
		BMessage * bm = new BMessage(SOI_LOADUNIVERSEFROMPANEL);
		if (bm) break;//debug break;//debug be_app->RunFilePanel(loadThe[UNIVERSE_TYPE], loadStr, cancelStr, false, bm);
		else warning(failMemory);
	break;
	case SOI_BLNEXT:
		ShipWeapon * nextShipWeapon = (ShipWeapon *)((DataNode *)nextDNPtr)->data;
		if (validate) ValidateShipWeapon();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdateShipWeapon();
			shipWeaponCurrent = nextShipWeapon;
			shipWeapon->Copy(shipWeaponCurrent);
			scg->nameStrGadget->SetText(shipWeaponCurrent->name);
			thisDNPtr = dataListGlobal[SHIPWEAPON_TYPE]->NextPrevItems((void *)shipWeaponCurrent, &nextDNPtr, &prevDNPtr, bb);
		}
	break;
	default:
		BWindow::MessageReceived(message);
	break;
}
}//end

bool EditShipWeaponWindow::QuitRequested(void) 
{

if (strcmp(scg->nameStrGadget->Text(), "")) 
{
	if (shipWeaponCurrent) 
	{
		ValidateShipWeapon();
		if (err == NO_ERR) 
		{
			UpdateShipWeapon();
			if (err == NO_ERR) 
			{
				Quit();
				return(BWindow::QuitRequested());
			}
			else return false;
		}
		else return false;
	}
}
Quit();
return(BWindow::QuitRequested());
}//end


void EditShipWeaponWindow::ValidateShipWeapon(void) 
{

UniqueName(dataListGlobal[SHIPWEAPON_TYPE], scg->nameStrGadget->Text());
if (NO_UNIQUE == err) 
{
	warning(failNameUnique[SHIPWEAPON_TYPE]);
	return;
}
uint32 v, vp;

v = s2uint32(scg->vIntGadget->Text());
if (S2UIERR == err) 
{
	warning(SCGVolumeErr);
	return;
}
vp = s2uint32(scg->vperIntGadget->Text());
if (S2UIERR == err) 
{
	warning(SCGVolumePerErr);
	return;
}
shipWeapon->volume = v;
shipWeapon->vper = vp;
}//end


void EditShipWeaponWindow::UpdateShipWeapon(void) 
{

err = NO_ERR;
shipWeapon->mass = 0;
UIntPtrNode * node;
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)shipWeapon->buildable->elementPrimal->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	shipWeapon->mass += ((Element *)(node->data))->mass;
	shipWeapon->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)shipWeapon->buildable->compoundPrimal->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	shipWeapon->mass += ((Compound *)(node->data))->mass;
	shipWeapon->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)shipWeapon->buildable->elementManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	shipWeapon->mass += ((Element *)(node->data))->mass;
	shipWeapon->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)shipWeapon->buildable->compoundManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	shipWeapon->mass += ((Compound *)(node->data))->mass;
	shipWeapon->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)shipWeapon->buildable->shipWeaponManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	shipWeapon->mass += ((ShipWeapon *)(node->data))->mass;
	shipWeapon->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)shipWeapon->buildable->factoryManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	shipWeapon->mass += ((Factory *)(node->data))->mass;
	shipWeapon->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)shipWeapon->buildable->engineManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	shipWeapon->mass += ((Engine *)(node->data))->mass;
	shipWeapon->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)shipWeapon->buildable->shipManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	shipWeapon->mass += ((Ship *)(node->data))->mass;
	shipWeapon->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)shipWeapon->buildable->shipShieldManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	shipWeapon->mass += ((ShipShield *)(node->data))->mass;
	shipWeapon->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)shipWeapon->buildable->shipWeaponManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	shipWeapon->mass += ((ShipWeapon *)(node->data))->mass;
	shipWeapon->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)shipWeapon->buildable->planetShieldManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	shipWeapon->mass += ((PlanetShield *)(node->data))->mass;
	shipWeapon->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)shipWeapon->buildable->planetWeaponManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	shipWeapon->mass += ((PlanetWeapon *)(node->data))->mass;
	shipWeapon->mass *= node->number;
}
if (shipWeaponCurrent) shipWeaponCurrent->Copy(shipWeapon);
}//end


void EditShipWeaponWindow::SaveShipWeapons(const char * fileName) 
{

SaveUniverse(fileName);
}//end


void EditShipWeaponWindow::LoadShipWeapons(const char * fileName) 
{

LoadUniverse(fileName);
}//end
