//functions of EditMineWindow soi0.1

#include "windowGuts.h"
#include "editMineWindow.h"
#include "def.h"
#include "showSomeThings.h"
#include "getSomeThings.h"
#include "getFromList.h"
#include "saveLoadUniverse.h"
#include "titleWindow.h"
#include "designButtons.h"

void EditMineWindow::SaveRequested(const char * fileName) 
{

SaveMines(fileName);
}//end


EditMineWindow::EditMineWindow(BRect area, const char *title) : BWindow(area, title, B_TITLED_WINDOW, B_NOT_RESIZABLE|B_NOT_ZOOMABLE) 
{

err = NO_ERR;
orderButton = NULL;
bb = new BottomButtons;
if (bb) 
{
	if (editUniverseWindow) 
	{
		editUniverseWindow->Lock();
		editUniverseWindow->buttons[DSN_MINE]->SetEnabled(false);
		editUniverseWindow->Unlock();
	}
	db = new DoableButtons();
	if (db) 
	{
		maint = new DoableButtons();
		if (maint) 
		{
			scg = new SmallConstantsGadgets();
			if (scg) 
			{
				bld = new DoableButtons();
				if (!bld) err = CREATEDNOTADDED;
				else err = CREATEDNOTADDED;
			}
			else err = CREATEDNOTADDED;
		}
		else err = CREATEDNOTADDED;
	}
	else err = CREATEDNOTADDED;
}
else err = CREATEDNOTADDED;
editMineWindow = this;
if (!mineCurrent) if (dataListGlobal[MINE_TYPE]->list->CountItems()) mineCurrent = (Mine *)((DataNode *)dataListGlobal[MINE_TYPE]->list->ItemAt(0))->data;
}//end


EditMineWindow::~EditMineWindow() 
{

if (bb) 
{
	if (editUniverseWindow) 
	{
		editUniverseWindow->Lock();
		editUniverseWindow->buttons[DSN_MINE]->SetEnabled(true);
		editUniverseWindow->Unlock();
	}
	delete bb;
}
if (bld) delete bld;
if (db) delete db;
if (maint) delete maint;
if (scg) delete scg;
if (orderButton) 
{
	orderButton->RemoveSelf();
	delete orderButton;
}
//if (kindButton) 
//{
//	kindButton->RemoveSelf();
//	delete kindButton;
//}
editMineWindow = NULL;
}//end


void EditMineWindow::AddMine(void) 
{

Mine * item = new Mine(mine, scg->nameStrGadget->Text(), dataListGlobal[MINE_TYPE]);
if (item) 
{
	if (err != CREATED) 
	{
		delete item;
		return;
	}
}
else err = NO_MINE;
}//end


void EditMineWindow::MessageReceived(BMessage *message) 
{

bool validate = true;
int32 mineSize = sizeof mine;
if (!strcmp(scg->nameStrGadget->Text(), "")) validate = false;

switch (message->what) 
{
	case SOI_NAME:
	case SOI_VOLUME:
	case SOI_VPER:
	
	break;
	case SOI_MAINTAINABLEBUTTONLABEL:
		if (maint->showing) 
		{
			maint->label->SetLabel(selectMaintValue);
			maint->showing = false;
		}
		else {
			maint->label->SetLabel(showMaintValue);
			maint->showing = true;
		}
		maint->ResetMsg(message->what);
	break;
	case SOI_BUILDABLEBUTTONLABEL:
		if (bld->showing) 
		{
			bld->label->SetLabel(selectProdValue);
			bld->showing = false;
		}
		else {
			bld->label->SetLabel(showProdValue);
			bld->showing = true;
		}
		bld->ResetMsg(message->what);
	break;
	case SOI_DOABLEBUTTONLABEL:
		if (db->showing) 
		{
			db->label->SetLabel(selectConsumeValue);
			db->showing = false;
		}
		else {
			db->label->SetLabel(showConsumeValue);
			db->showing = true;
		}
		db->ResetMsg(message->what);
	break;
	case SOI_GETPOSSORDERS:
		printf("SOI_GETPOSSORDERS pressed\n");
		beep();
	break;
	case SOI_SETKIND:
		printf("SOI_SETKIND pressed\n");
		beep();
	break;
	case SOI_BUILDABLEBUTTONPRIMALELEMENTS:
		GetSomeThings(mine->buildable->elementPrimal->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[ELEMENT_TYPE], MINE_TYPE);
	break;
	case SOI_BUILDABLEBUTTONPRIMALCOMPOUNDS:
		GetSomeThings(mine->buildable->compoundPrimal->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[COMPOUND_TYPE], MINE_TYPE);
	break;
	case SOI_BUILDABLEBUTTONELEMENTS:
		GetSomeThings(mine->buildable->elementManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[ELEMENT_TYPE], MINE_TYPE);
	break;
	case SOI_BUILDABLEBUTTONCOMPOUNDS:
		GetSomeThings(mine->buildable->compoundManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[COMPOUND_TYPE], MINE_TYPE);
	break;
	case SOI_BUILDABLEBUTTONMINES:
		GetSomeThings(mine->buildable->mineManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[MINE_TYPE], MINE_TYPE);
	break;
	case SOI_BUILDABLEBUTTONFACTORYS:
		GetSomeThings(mine->buildable->factoryManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[FACTORY_TYPE], MINE_TYPE);
	break;
	case SOI_BUILDABLEBUTTONENGINES:
		GetSomeThings(mine->buildable->engineManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[ENGINE_TYPE], MINE_TYPE);
	break;
	case SOI_BUILDABLEBUTTONSHIPS:
		GetSomeThings(mine->buildable->shipManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[SHIP_TYPE], MINE_TYPE);
	break;
	case SOI_BUILDABLEBUTTONSSHIELDS:
		GetSomeThings(mine->buildable->shipShieldManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[SSHIELD_TYPE], MINE_TYPE);
	break;
	case SOI_BUILDABLEBUTTONSHIPWEAPONS:
		GetSomeThings(mine->buildable->shipWeaponManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[SHIPWEAPON_TYPE], MINE_TYPE);
	break;
	case SOI_BUILDABLEBUTTONPLANETSHIELDS:
		GetSomeThings(mine->buildable->planetShieldManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[PLANETSHIELD_TYPE], MINE_TYPE);
	break;
	case SOI_BUILDABLEBUTTONPLANETWEAPONS:
		GetSomeThings(mine->buildable->planetWeaponManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[PLANETWEAPON_TYPE], MINE_TYPE);
	break;
	case SOI_DOABLEBUTTONPRIMALELEMENTS:
		GetSomeThings(mine->doable->elementPrimal->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[ELEMENT_TYPE], MINE_TYPE);
	break;
	case SOI_DOABLEBUTTONPRIMALCOMPOUNDS:
		GetSomeThings(mine->doable->compoundPrimal->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[COMPOUND_TYPE], MINE_TYPE);
	break;
	case SOI_DOABLEBUTTONELEMENTS:
		GetSomeThings(mine->doable->elementManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[ELEMENT_TYPE], MINE_TYPE);
	break;
	case SOI_DOABLEBUTTONCOMPOUNDS:
		GetSomeThings(mine->doable->compoundManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[COMPOUND_TYPE], MINE_TYPE);
	break;
	case SOI_DOABLEBUTTONMINES:
		GetSomeThings(mine->doable->mineManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[MINE_TYPE], MINE_TYPE);
	break;
	case SOI_DOABLEBUTTONFACTORYS:
		GetSomeThings(mine->doable->factoryManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[FACTORY_TYPE], MINE_TYPE);
	break;
	case SOI_DOABLEBUTTONENGINES:
		GetSomeThings(mine->doable->engineManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[ENGINE_TYPE], MINE_TYPE);
	break;
	case SOI_DOABLEBUTTONSHIPS:
		GetSomeThings(mine->doable->shipManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[SHIP_TYPE], MINE_TYPE);
	break;
	case SOI_DOABLEBUTTONSSHIELDS:
		GetSomeThings(mine->doable->shipShieldManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[SSHIELD_TYPE], MINE_TYPE);
	break;
	case SOI_DOABLEBUTTONSHIPWEAPONS:
		GetSomeThings(mine->doable->shipWeaponManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[SHIPWEAPON_TYPE], MINE_TYPE);
	break;
	case SOI_DOABLEBUTTONPLANETSHIELDS:
		GetSomeThings(mine->doable->planetShieldManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[PLANETSHIELD_TYPE], MINE_TYPE);
	break;
	case SOI_DOABLEBUTTONPLANETWEAPONS:
		GetSomeThings(mine->doable->planetWeaponManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[PLANETWEAPON_TYPE], MINE_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONPRIMALELEMENTS:
		GetSomeThings(mine->maintainable->elementPrimal->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[ELEMENT_TYPE], MINE_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONPRIMALCOMPOUNDS:
		GetSomeThings(mine->maintainable->compoundPrimal->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[COMPOUND_TYPE], MINE_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONELEMENTS:
		GetSomeThings(mine->maintainable->elementManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[ELEMENT_TYPE], MINE_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONCOMPOUNDS:
		GetSomeThings(mine->maintainable->compoundManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[COMPOUND_TYPE], MINE_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONMINES:
		GetSomeThings(mine->maintainable->mineManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[MINE_TYPE], MINE_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONFACTORYS:
		GetSomeThings(mine->maintainable->factoryManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[FACTORY_TYPE], MINE_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONENGINES:
		GetSomeThings(mine->maintainable->engineManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[ENGINE_TYPE], MINE_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONSHIPS:
		GetSomeThings(mine->maintainable->shipManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[SHIP_TYPE], MINE_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONSSHIELDS:
		GetSomeThings(mine->maintainable->shipShieldManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[SSHIELD_TYPE], MINE_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONSHIPWEAPONS:
		GetSomeThings(mine->maintainable->shipWeaponManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[SHIPWEAPON_TYPE], MINE_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONPLANETSHIELDS:
		GetSomeThings(mine->maintainable->planetShieldManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[PLANETSHIELD_TYPE], MINE_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONPLANETWEAPONS:
		GetSomeThings(mine->maintainable->planetWeaponManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[PLANETWEAPON_TYPE], MINE_TYPE);
	break;
	case SOI_SHOWBUILDPRIMALELEMENTS:
		ShowSomeThings((const void *)&mine, mineSize, mineCurrent->name, MINE_TYPE, mine->buildable->elementPrimal, scg->nameStrGadget->Text(), editMineWindow, dataListGlobal[ELEMENT_TYPE]);
	break;
	case SOI_SHOWBUILDPRIMALCOMPOUNDS:
		ShowSomeThings((const void *)&mine, mineSize, mineCurrent->name, MINE_TYPE, mine->buildable->compoundPrimal, scg->nameStrGadget->Text(), editMineWindow, dataListGlobal[COMPOUND_TYPE]);
	break;
	case SOI_SHOWBUILDELEMENTS:
		ShowSomeThings((const void *)&mine, mineSize, mineCurrent->name, MINE_TYPE, mine->buildable->elementManufactured, scg->nameStrGadget->Text(), editMineWindow, dataListGlobal[ELEMENT_TYPE]);
	break;
	case SOI_SHOWBUILDCOMPOUNDS:
		ShowSomeThings((const void *)&mine, mineSize, mineCurrent->name, MINE_TYPE, mine->buildable->compoundManufactured, scg->nameStrGadget->Text(), editMineWindow, dataListGlobal[COMPOUND_TYPE]);
	break;
	case SOI_SHOWBUILDMINES:
		ShowSomeThings((const void *)&mine, mineSize, mineCurrent->name, MINE_TYPE, mine->buildable->mineManufactured, scg->nameStrGadget->Text(), editMineWindow, dataListGlobal[MINE_TYPE]);
	break;
	case SOI_SHOWBUILDFACTORYS:
		ShowSomeThings((const void *)&mine, mineSize, mineCurrent->name, MINE_TYPE, mine->buildable->factoryManufactured, scg->nameStrGadget->Text(), editMineWindow, dataListGlobal[FACTORY_TYPE]);
	break;
	case SOI_SHOWBUILDENGINES:
		ShowSomeThings((const void *)&mine, mineSize, mineCurrent->name, MINE_TYPE, mine->buildable->engineManufactured, scg->nameStrGadget->Text(), editMineWindow, dataListGlobal[ENGINE_TYPE]);
	break;
	case SOI_SHOWBUILDSHIPS:
		ShowSomeThings((const void *)&mine, mineSize, mineCurrent->name, MINE_TYPE, mine->buildable->shipManufactured, scg->nameStrGadget->Text(), editMineWindow, dataListGlobal[SHIP_TYPE]);
	break;
	case SOI_SHOWBUILDSSHIELDS:
		ShowSomeThings((const void *)&mine, mineSize, mineCurrent->name, MINE_TYPE, mine->buildable->shipShieldManufactured, scg->nameStrGadget->Text(), editMineWindow, dataListGlobal[SSHIELD_TYPE]);
	break;
	case SOI_SHOWBUILDSHIPWEAPONS:
		ShowSomeThings((const void *)&mine, mineSize, mineCurrent->name, MINE_TYPE, mine->buildable->shipWeaponManufactured, scg->nameStrGadget->Text(), editMineWindow, dataListGlobal[SHIPWEAPON_TYPE]);
	break;
	case SOI_SHOWBUILDPLANETSHIELDS:
		ShowSomeThings((const void *)&mine, mineSize, mineCurrent->name, MINE_TYPE, mine->buildable->planetShieldManufactured, scg->nameStrGadget->Text(), editMineWindow, dataListGlobal[PLANETSHIELD_TYPE]);
	break;
	case SOI_SHOWBUILDPLANETWEAPONS:
		ShowSomeThings((const void *)&mine, mineSize, mineCurrent->name, MINE_TYPE, mine->buildable->planetWeaponManufactured, scg->nameStrGadget->Text(), editMineWindow, dataListGlobal[PLANETWEAPON_TYPE]);
	break;
	case SOI_SHOWDOPRIMALELEMENTS:
		ShowSomeThings((const void *)&mine, mineSize, mineCurrent->name, MINE_TYPE, mine->doable->elementPrimal, scg->nameStrGadget->Text(), editMineWindow, dataListGlobal[ELEMENT_TYPE]);
	break;
	case SOI_SHOWDOPRIMALCOMPOUNDS:
		ShowSomeThings((const void *)&mine, mineSize, mineCurrent->name, MINE_TYPE, mine->doable->compoundPrimal, scg->nameStrGadget->Text(), editMineWindow, dataListGlobal[COMPOUND_TYPE]);
	break;
	case SOI_SHOWDOELEMENTS:
		ShowSomeThings((const void *)&mine, mineSize, mineCurrent->name, MINE_TYPE, mine->doable->elementManufactured, scg->nameStrGadget->Text(), editMineWindow, dataListGlobal[ELEMENT_TYPE]);
	break;
	case SOI_SHOWDOCOMPOUNDS:
		ShowSomeThings((const void *)&mine, mineSize, mineCurrent->name, MINE_TYPE, mine->doable->compoundManufactured, scg->nameStrGadget->Text(), editMineWindow, dataListGlobal[COMPOUND_TYPE]);
	break;
	case SOI_SHOWDOMINES:
		ShowSomeThings((const void *)&mine, mineSize, mineCurrent->name, MINE_TYPE, mine->doable->mineManufactured, scg->nameStrGadget->Text(), editMineWindow, dataListGlobal[MINE_TYPE]);
	break;
	case SOI_SHOWDOFACTORYS:
		ShowSomeThings((const void *)&mine, mineSize, mineCurrent->name, MINE_TYPE, mine->doable->factoryManufactured, scg->nameStrGadget->Text(), editMineWindow, dataListGlobal[FACTORY_TYPE]);
	break;
	case SOI_SHOWDOENGINES:
		ShowSomeThings((const void *)&mine, mineSize, mineCurrent->name, MINE_TYPE, mine->doable->engineManufactured, scg->nameStrGadget->Text(), editMineWindow, dataListGlobal[ENGINE_TYPE]);
	break;
	case SOI_SHOWDOSHIPS:
		ShowSomeThings((const void *)&mine, mineSize, mineCurrent->name, MINE_TYPE, mine->doable->shipManufactured, scg->nameStrGadget->Text(), editMineWindow, dataListGlobal[SHIP_TYPE]);
	break;
	case SOI_SHOWDOSSHIELDS:
		ShowSomeThings((const void *)&mine, mineSize, mineCurrent->name, MINE_TYPE, mine->doable->shipShieldManufactured, scg->nameStrGadget->Text(), editMineWindow, dataListGlobal[SSHIELD_TYPE]);
	break;
	case SOI_SHOWDOSHIPWEAPONS:
		ShowSomeThings((const void *)&mine, mineSize, mineCurrent->name, MINE_TYPE, mine->doable->shipWeaponManufactured, scg->nameStrGadget->Text(), editMineWindow, dataListGlobal[SHIPWEAPON_TYPE]);
	break;
	case SOI_SHOWDOPLANETSHIELDS:
		ShowSomeThings((const void *)&mine, mineSize, mineCurrent->name, MINE_TYPE, mine->doable->planetShieldManufactured, scg->nameStrGadget->Text(), editMineWindow, dataListGlobal[PLANETSHIELD_TYPE]);
	break;
	case SOI_SHOWDOPLANETWEAPONS:
		ShowSomeThings((const void *)&mine, mineSize, mineCurrent->name, MINE_TYPE, mine->doable->planetWeaponManufactured, scg->nameStrGadget->Text(), editMineWindow, dataListGlobal[PLANETWEAPON_TYPE]);
	break;
	case SOI_SHOWMAINTPRIMALELEMENTS:
		ShowSomeThings((const void *)&mine, mineSize, mineCurrent->name, MINE_TYPE, mine->maintainable->elementPrimal, scg->nameStrGadget->Text(), editMineWindow, dataListGlobal[ELEMENT_TYPE]);
	break;
	case SOI_SHOWMAINTPRIMALCOMPOUNDS:
		ShowSomeThings((const void *)&mine, mineSize, mineCurrent->name, MINE_TYPE, mine->maintainable->compoundPrimal, scg->nameStrGadget->Text(), editMineWindow, dataListGlobal[COMPOUND_TYPE]);
	break;
	case SOI_SHOWMAINTELEMENTS:
		ShowSomeThings((const void *)&mine, mineSize, mineCurrent->name, MINE_TYPE, mine->maintainable->elementManufactured, scg->nameStrGadget->Text(), editMineWindow, dataListGlobal[ELEMENT_TYPE]);
	break;
	case SOI_SHOWMAINTCOMPOUNDS:
		ShowSomeThings((const void *)&mine, mineSize, mineCurrent->name, MINE_TYPE, mine->maintainable->compoundManufactured, scg->nameStrGadget->Text(), editMineWindow, dataListGlobal[COMPOUND_TYPE]);
	break;
	case SOI_SHOWMAINTMINES:
		ShowSomeThings((const void *)&mine, mineSize, mineCurrent->name, MINE_TYPE, mine->maintainable->mineManufactured, scg->nameStrGadget->Text(), editMineWindow, dataListGlobal[MINE_TYPE]);
	break;
	case SOI_SHOWMAINTFACTORYS:
		ShowSomeThings((const void *)&mine, mineSize, mineCurrent->name, MINE_TYPE, mine->maintainable->factoryManufactured, scg->nameStrGadget->Text(), editMineWindow, dataListGlobal[FACTORY_TYPE]);
	break;
	case SOI_SHOWMAINTENGINES:
		ShowSomeThings((const void *)&mine, mineSize, mineCurrent->name, MINE_TYPE, mine->maintainable->engineManufactured, scg->nameStrGadget->Text(), editMineWindow, dataListGlobal[ENGINE_TYPE]);
	break;
	case SOI_SHOWMAINTSHIPS:
		ShowSomeThings((const void *)&mine, mineSize, mineCurrent->name, MINE_TYPE, mine->maintainable->shipManufactured, scg->nameStrGadget->Text(), editMineWindow, dataListGlobal[SHIP_TYPE]);
	break;
	case SOI_SHOWMAINTSSHIELDS:
		ShowSomeThings((const void *)&mine, mineSize, mineCurrent->name, MINE_TYPE, mine->maintainable->shipShieldManufactured, scg->nameStrGadget->Text(), editMineWindow, dataListGlobal[SSHIELD_TYPE]);
	break;
	case SOI_SHOWMAINTSHIPWEAPONS:
		ShowSomeThings((const void *)&mine, mineSize, mineCurrent->name, MINE_TYPE, mine->maintainable->shipWeaponManufactured, scg->nameStrGadget->Text(), editMineWindow, dataListGlobal[SHIPWEAPON_TYPE]);
	break;
	case SOI_SHOWMAINTPLANETSHIELDS:
		ShowSomeThings((const void *)&mine, mineSize, mineCurrent->name, MINE_TYPE, mine->maintainable->planetShieldManufactured, scg->nameStrGadget->Text(), editMineWindow, dataListGlobal[PLANETSHIELD_TYPE]);
	break;
	case SOI_SHOWMAINTPLANETWEAPONS:
		ShowSomeThings((const void *)&mine, mineSize, mineCurrent->name, MINE_TYPE, mine->maintainable->planetWeaponManufactured, scg->nameStrGadget->Text(), editMineWindow, dataListGlobal[PLANETWEAPON_TYPE]);
	break;
	case SOI_BLREMOVE:
		dataListGlobal[MINE_TYPE]->Remove();
		Quit();
	break;
	case SOI_BLLIST:
		GetFromList((void *)editMineWindow, dataListGlobal[MINE_TYPE], scg->nameStrGadget->Text());
	break;
	case SOI_BLLISTGOT:
		if (validate) ValidateMine();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdateMine();
			mineCurrent = mineNewCurrent;
			mine->Copy(mineCurrent);
			scg->nameStrGadget->SetText(mineCurrent->name);
			thisDNPtr = dataListGlobal[MINE_TYPE]->NextPrevItems((void *)mineCurrent, &nextDNPtr, &prevDNPtr, bb);
			if (!bb->gnu) 
			{
				BRect gnuRect(154,bottom, 189,34);
				bb->gnu = new BButton(gnuRect, "", newStr, new BMessage(SOI_BLGNU));
				AddChild(bb->gnu);
				bb->gnu->SetTarget(this);
				bb->add->SetLabel(removeStr);
				bb->add->SetMessage(new BMessage(SOI_BLREMOVE));
			}
		}
	break;
	case SOI_BLPREV:
		Mine * prevMine = (Mine *)((DataNode *)prevDNPtr)->data;
		if (validate) ValidateMine();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdateMine();
			mineCurrent = prevMine;
			mine->Copy(mineCurrent);
			scg->nameStrGadget->SetText(mineCurrent->name);
			thisDNPtr = dataListGlobal[MINE_TYPE]->NextPrevItems((void *)mineCurrent, &nextDNPtr, &prevDNPtr, bb);
		}
	break;
	case SOI_BLDONE:
		if (!validate) 
		{
			Quit();
		}
		if (!strcmp(removeStr, bb->add->Label())) 
		{
			ValidateMine();
			if (err == NO_ERR) 
			{
				UpdateMine();
			}
		}
		if (err == NO_ERR) 
		{
			Quit();
		}
	break;
	case SOI_BLGNU:
		if (validate) ValidateMine();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdateMine();
			mineCurrent = NULL;
			RemoveChild(bb->gnu);
			delete bb->gnu;
			bb->gnu = NULL;
			bb->add->SetLabel(addStr);
			bb->add->SetMessage(new BMessage(SOI_BLADD));
			scg->nameStrGadget->SetText("");
			scg->nameStrGadget->MakeFocus();
		}
	break;
	case SOI_BLADD:
		if (validate) ValidateMine();
		else {
			err = NO_NAME;
			warning(everythingNamed);
		}//for add don't update
		if (err == NO_ERR) 
		{
			AddMine();
			if (err) 
			{
				if (err != CREATEDNOTADDED) 
				{
					Quit();
				}
			}
			else {
				if (editUniverseWindow) 
				{
					editUniverseWindow->Lock();
					editUniverseWindow->buttons[DSN_MINE]->SetLabel(editThe[MINE_TYPE]);
					editUniverseWindow->bb->save->SetEnabled(true);
					editUniverseWindow->Unlock();
				}
				scg->nameStrGadget->SetText("");
				scg->nameStrGadget->MakeFocus();
				bb->save->SetEnabled(true);
				if (openingWindow) 
				{
					openingWindow->Lock();
					openingWindow->universeButton->SetLabel(editThe[UNIVERSE_TYPE]);
					openingWindow->createUniverseButton->SetEnabled(true);
					openingWindow->realUniverseButton->SetEnabled(true);
					openingWindow->Unlock();
				}
				mine->maintainable->EmptyList();
				mine->buildable->EmptyList();
				mine->doable->EmptyList();
			}
		}
	break;
	case SOI_BLSAVE:
		if (validate) ValidateMine();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdateMine();
			//RunSavePanel("universe", saveThe[UNIVERSE_TYPE], saveStr, cancelStr);
		}
	break;
	case SOI_BLPIC:
	
	break;
	case SOI_LOADUNIVERSEFROMPANEL:
		LoadMines("universe");//debug
		Quit();
	break;
	case SOI_BLLOAD:
		BMessage * bm = new BMessage(SOI_LOADUNIVERSEFROMPANEL);
		if (bm) break;//debug break;//debug be_app->RunFilePanel(loadThe[UNIVERSE_TYPE], loadStr, cancelStr, false, bm);
		else warning(failMemory);
	break;
	case SOI_BLNEXT:
		Mine * nextMine = (Mine *)((DataNode *)nextDNPtr)->data;
		if (validate) ValidateMine();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdateMine();
			mineCurrent = nextMine;
			mine->Copy(mineCurrent);
			scg->nameStrGadget->SetText(mineCurrent->name);
			thisDNPtr = dataListGlobal[MINE_TYPE]->NextPrevItems((void *)mineCurrent, &nextDNPtr, &prevDNPtr, bb);
		}
	break;
	default:
		BWindow::MessageReceived(message);
	break;
}
}//end

bool EditMineWindow::QuitRequested(void) 
{

if (strcmp(scg->nameStrGadget->Text(), "")) 
{
	if (mineCurrent) 
	{
		ValidateMine();
		if (err == NO_ERR) 
		{
			UpdateMine();
			if (err == NO_ERR) 
			{
				Quit();
				return(BWindow::QuitRequested());
			}
			else return false;
		}
		else return false;
	}
}
Quit();
return(BWindow::QuitRequested());
}//end


void EditMineWindow::ValidateMine(void) 
{

UniqueName(dataListGlobal[MINE_TYPE], scg->nameStrGadget->Text());
if (NO_UNIQUE == err) 
{
	warning(failNameUnique[MINE_TYPE]);
	return;
}
uint32 v, vp;

v = s2uint32(scg->vIntGadget->Text());
if (S2UIERR == err) 
{
	warning(SCGVolumeErr);
	return;
}
vp = s2uint32(scg->vperIntGadget->Text());
if (S2UIERR == err) 
{
	warning(SCGVolumePerErr);
	return;
}
mine->volume = v;
mine->vper = vp;
}//end


void EditMineWindow::UpdateMine(void) 
{

err = NO_ERR;
mine->mass = 0;
UIntPtrNode * node;
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)mine->buildable->elementPrimal->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	mine->mass += ((Element *)(node->data))->mass;
	mine->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)mine->buildable->compoundPrimal->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	mine->mass += ((Compound *)(node->data))->mass;
	mine->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)mine->buildable->elementManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	mine->mass += ((Element *)(node->data))->mass;
	mine->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)mine->buildable->compoundManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	mine->mass += ((Compound *)(node->data))->mass;
	mine->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)mine->buildable->mineManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	mine->mass += ((Mine *)(node->data))->mass;
	mine->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)mine->buildable->factoryManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	mine->mass += ((Factory *)(node->data))->mass;
	mine->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)mine->buildable->engineManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	mine->mass += ((Engine *)(node->data))->mass;
	mine->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)mine->buildable->shipManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	mine->mass += ((Ship *)(node->data))->mass;
	mine->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)mine->buildable->shipShieldManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	mine->mass += ((ShipShield *)(node->data))->mass;
	mine->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)mine->buildable->shipWeaponManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	mine->mass += ((ShipWeapon *)(node->data))->mass;
	mine->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)mine->buildable->planetShieldManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	mine->mass += ((PlanetShield *)(node->data))->mass;
	mine->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)mine->buildable->planetWeaponManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	mine->mass += ((PlanetWeapon *)(node->data))->mass;
	mine->mass *= node->number;
}
if (mineCurrent) mineCurrent->Copy(mine);
}//end


void EditMineWindow::SaveMines(const char * fileName) 
{

SaveUniverse(fileName);
}//end


void EditMineWindow::LoadMines(const char * fileName) 
{

LoadUniverse(fileName);
}//end
